"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

import os
import speakeasy.new_openapi
from speakeasy.new_openapi import SDK, models
from speakeasy.new_openapi.types import BaseModel
from tests.test_client import create_test_http_client
from typing import Optional


class AuthenticateOutputs(BaseModel):
    token: str


def authenticate() -> Optional[AuthenticateOutputs]:
    test_http_client = create_test_http_client("authenticate")

    with SDK(
        server_url=os.getenv("TEST_SERVER_URL", "http://localhost:18080"),
        security=speakeasy.new_openapi.Security(
            option4=speakeasy.new_openapi.SecurityOption4(
                app_id="app-speakeasy-123",
                secret="MTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTI",
            ),
        ),
        client=test_http_client,
    ) as sdk:
        assert sdk is not None

        login_res = sdk.login()
        assert login_res is not None
        assert login_res.token is not None and len(login_res.token) > 0

    with SDK(
        server_url=os.getenv("TEST_SERVER_URL", "http://localhost:18080"),
        security=speakeasy.new_openapi.Security(
            option7=speakeasy.new_openapi.SecurityOption7(
                api_key=login_res.token,
            ),
        ),
        client=test_http_client,
    ) as sdk:
        assert sdk is not None

        validate_res = sdk.validate()
        assert validate_res is not None
        assert validate_res.valid is not None
        assert validate_res.valid is True

    return AuthenticateOutputs(
        token=login_res.token,
    )


class UserSetupOutputs(BaseModel):
    user: models.User


def user_setup() -> Optional[UserSetupOutputs]:
    test_http_client = create_test_http_client("userSetup")

    with SDK(
        server_url=os.getenv("TEST_SERVER_URL", "http://localhost:18080"),
        client=test_http_client,
    ) as sdk:
        assert sdk is not None

        create_res = sdk.create_user(
            request=speakeasy.new_openapi.BaseUser(
                email="Trystan_Crooks@hotmail.com",
                first_name="Trystan",
                last_name="Crooks",
                age=32,
                postal_code="94110",
                metadata=speakeasy.new_openapi.Metadata(
                    allergies="none",
                    **{
                        "color": "red",
                        "height": "182",
                        "weight": "77",
                        "is_smoking": "true",
                    },
                ),
            )
        )
        assert create_res is not None
        assert create_res.email == "Trystan_Crooks@hotmail.com"
        assert create_res.postal_code is not None
        assert create_res.postal_code == "94110"

    return UserSetupOutputs(
        user=create_res,
    )


class UserTeardownInputs(BaseModel):
    id: str


def user_teardown(inputs: UserTeardownInputs):
    test_http_client = create_test_http_client("userTeardown")

    with SDK(
        server_url=os.getenv("TEST_SERVER_URL", "http://localhost:18080"),
        client=test_http_client,
    ) as sdk:
        assert sdk is not None

        sdk.delete_user(id=inputs.id)
