from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.chat_completion_tool_choice_option_type_0 import ChatCompletionToolChoiceOptionType0
from ..models.create_chat_completion_request_function_call_type_0 import CreateChatCompletionRequestFunctionCallType0
from ..models.create_chat_completion_request_model_type_1 import CreateChatCompletionRequestModelType1
from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.assistant_message import AssistantMessage
    from ..models.chat_completion_function_call_option import ChatCompletionFunctionCallOption
    from ..models.chat_completion_functions import ChatCompletionFunctions
    from ..models.chat_completion_named_tool_choice import ChatCompletionNamedToolChoice
    from ..models.chat_completion_stream_options_type_0 import ChatCompletionStreamOptionsType0
    from ..models.chat_completion_tool import ChatCompletionTool
    from ..models.create_chat_completion_request_logit_bias_type_0 import CreateChatCompletionRequestLogitBiasType0
    from ..models.create_chat_completion_request_response_format import CreateChatCompletionRequestResponseFormat
    from ..models.function_message import FunctionMessage
    from ..models.system_message import SystemMessage
    from ..models.tool_message import ToolMessage
    from ..models.user_message import UserMessage


T = TypeVar("T", bound="CreateChatCompletionRequest")


@_attrs_define
class CreateChatCompletionRequest:
    """
    Attributes:
        messages (List[Union['AssistantMessage', 'FunctionMessage', 'SystemMessage', 'ToolMessage', 'UserMessage']]): A
            list of messages comprising the conversation so far. [Example Python
            code](https://cookbook.openai.com/examples/how_to_format_inputs_to_chatgpt_models).
        model (Union[CreateChatCompletionRequestModelType1, str]): ID of the model to use. See the [model endpoint
            compatibility](/docs/models/model-endpoint-compatibility) table for details on which models work with the Chat
            API. Example: gpt-4-turbo.
        frequency_penalty (Union[None, Unset, float]): Number between -2.0 and 2.0. Positive values penalize new tokens
            based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line
            verbatim.

            [See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)
             Default: 0.0.
        logit_bias (Union['CreateChatCompletionRequestLogitBiasType0', None, Unset]): Modify the likelihood of specified
            tokens appearing in the completion.

            Accepts a JSON object that maps tokens (specified by their token ID in the tokenizer) to an associated bias
            value from -100 to 100. Mathematically, the bias is added to the logits generated by the model prior to
            sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase
            likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant
            token.
        logprobs (Union[None, Unset, bool]): Whether to return log probabilities of the output tokens or not. If true,
            returns the log probabilities of each output token returned in the `content` of `message`. Default: False.
        top_logprobs (Union[None, Unset, int]): An integer between 0 and 20 specifying the number of most likely tokens
            to return at each token position, each with an associated log probability. `logprobs` must be set to `true` if
            this parameter is used.
        max_tokens (Union[None, Unset, int]): The maximum number of [tokens](/tokenizer) that can be generated in the
            chat completion.

            The total length of input tokens and generated tokens is limited by the model's context length. [Example Python
            code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.
        n (Union[None, Unset, int]): How many chat completion choices to generate for each input message. Note that you
            will be charged based on the number of generated tokens across all of the choices. Keep `n` as `1` to minimize
            costs. Default: 1. Example: 1.
        presence_penalty (Union[None, Unset, float]): Number between -2.0 and 2.0. Positive values penalize new tokens
            based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.

            [See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)
             Default: 0.0.
        response_format (Union[Unset, CreateChatCompletionRequestResponseFormat]): An object specifying the format that
            the model must output. Compatible with [GPT-4 Turbo](/docs/models/gpt-4-and-gpt-4-turbo) and all GPT-3.5 Turbo
            models newer than `gpt-3.5-turbo-1106`.

            Setting to `{ "type": "json_object" }` enables JSON mode, which guarantees the message the model generates is
            valid JSON.

            **Important:** when using JSON mode, you **must** also instruct the model to produce JSON yourself via a system
            or user message. Without this, the model may generate an unending stream of whitespace until the generation
            reaches the token limit, resulting in a long-running and seemingly "stuck" request. Also note that the message
            content may be partially cut off if `finish_reason="length"`, which indicates the generation exceeded
            `max_tokens` or the conversation exceeded the max context length.
        seed (Union[None, Unset, int]): This feature is in Beta.
            If specified, our system will make a best effort to sample deterministically, such that repeated requests with
            the same `seed` and parameters should return the same result.
            Determinism is not guaranteed, and you should refer to the `system_fingerprint` response parameter to monitor
            changes in the backend.
        stop (Union[List[str], None, Unset, str]): Up to 4 sequences where the API will stop generating further tokens.
        stream (Union[None, Unset, bool]): If set, partial message deltas will be sent, like in ChatGPT. Tokens will be
            sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-
            sent_events/Using_server-sent_events#Event_stream_format) as they become available, with the stream terminated
            by a `data: [DONE]` message. [Example Python
            code](https://cookbook.openai.com/examples/how_to_stream_completions).
             Default: False.
        stream_options (Union['ChatCompletionStreamOptionsType0', None, Unset]): Options for streaming response. Only
            set this when you set `stream: true`.
        temperature (Union[None, Unset, float]): What sampling temperature to use, between 0 and 2. Higher values like
            0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.

            We generally recommend altering this or `top_p` but not both.
             Default: 1.0. Example: 1.
        top_p (Union[None, Unset, float]): An alternative to sampling with temperature, called nucleus sampling, where
            the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens
            comprising the top 10% probability mass are considered.

            We generally recommend altering this or `temperature` but not both.
             Default: 1.0. Example: 1.
        tools (Union[Unset, List['ChatCompletionTool']]): A list of tools the model may call. Currently, only functions
            are supported as a tool. Use this to provide a list of functions the model may generate JSON inputs for. A max
            of 128 functions are supported.
        tool_choice (Union['ChatCompletionNamedToolChoice', ChatCompletionToolChoiceOptionType0, Unset]): Controls which
            (if any) tool is called by the model.
            `none` means the model will not call any tool and instead generates a message.
            `auto` means the model can pick between generating a message or calling one or more tools.
            `required` means the model must call one or more tools.
            Specifying a particular tool via `{"type": "function", "function": {"name": "my_function"}}` forces the model to
            call that tool.

            `none` is the default when no tools are present. `auto` is the default if tools are present.
        user (Union[Unset, str]): A unique identifier representing your end-user, which can help OpenAI to monitor and
            detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
             Example: user-1234.
        function_call (Union['ChatCompletionFunctionCallOption', CreateChatCompletionRequestFunctionCallType0, Unset]):
            Deprecated in favor of `tool_choice`.

            Controls which (if any) function is called by the model.
            `none` means the model will not call a function and instead generates a message.
            `auto` means the model can pick between generating a message or calling a function.
            Specifying a particular function via `{"name": "my_function"}` forces the model to call that function.

            `none` is the default when no functions are present. `auto` is the default if functions are present.
        functions (Union[Unset, List['ChatCompletionFunctions']]): Deprecated in favor of `tools`.

            A list of functions the model may generate JSON inputs for.
    """

    messages: List[Union["AssistantMessage", "FunctionMessage", "SystemMessage", "ToolMessage", "UserMessage"]]
    model: Union[CreateChatCompletionRequestModelType1, str]
    frequency_penalty: Union[None, Unset, float] = 0.0
    logit_bias: Union["CreateChatCompletionRequestLogitBiasType0", None, Unset] = UNSET
    logprobs: Union[None, Unset, bool] = False
    top_logprobs: Union[None, Unset, int] = UNSET
    max_tokens: Union[None, Unset, int] = UNSET
    n: Union[None, Unset, int] = 1
    presence_penalty: Union[None, Unset, float] = 0.0
    response_format: Union[Unset, "CreateChatCompletionRequestResponseFormat"] = UNSET
    seed: Union[None, Unset, int] = UNSET
    stop: Union[List[str], None, Unset, str] = UNSET
    stream: Union[None, Unset, bool] = False
    stream_options: Union["ChatCompletionStreamOptionsType0", None, Unset] = UNSET
    temperature: Union[None, Unset, float] = 1.0
    top_p: Union[None, Unset, float] = 1.0
    tools: Union[Unset, List["ChatCompletionTool"]] = UNSET
    tool_choice: Union["ChatCompletionNamedToolChoice", ChatCompletionToolChoiceOptionType0, Unset] = UNSET
    user: Union[Unset, str] = UNSET
    function_call: Union["ChatCompletionFunctionCallOption", CreateChatCompletionRequestFunctionCallType0, Unset] = (
        UNSET
    )
    functions: Union[Unset, List["ChatCompletionFunctions"]] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        from ..models.assistant_message import AssistantMessage
        from ..models.chat_completion_stream_options_type_0 import ChatCompletionStreamOptionsType0
        from ..models.create_chat_completion_request_logit_bias_type_0 import CreateChatCompletionRequestLogitBiasType0
        from ..models.system_message import SystemMessage
        from ..models.tool_message import ToolMessage
        from ..models.user_message import UserMessage

        messages = []
        for messages_item_data in self.messages:
            messages_item: Dict[str, Any]
            if isinstance(messages_item_data, SystemMessage):
                messages_item = messages_item_data.to_dict()
            elif isinstance(messages_item_data, UserMessage):
                messages_item = messages_item_data.to_dict()
            elif isinstance(messages_item_data, AssistantMessage):
                messages_item = messages_item_data.to_dict()
            elif isinstance(messages_item_data, ToolMessage):
                messages_item = messages_item_data.to_dict()
            else:
                messages_item = messages_item_data.to_dict()

            messages.append(messages_item)

        model: str
        if isinstance(self.model, CreateChatCompletionRequestModelType1):
            model = self.model.value
        else:
            model = self.model

        frequency_penalty: Union[None, Unset, float]
        if isinstance(self.frequency_penalty, Unset):
            frequency_penalty = UNSET
        else:
            frequency_penalty = self.frequency_penalty

        logit_bias: Union[Dict[str, Any], None, Unset]
        if isinstance(self.logit_bias, Unset):
            logit_bias = UNSET
        elif isinstance(self.logit_bias, CreateChatCompletionRequestLogitBiasType0):
            logit_bias = self.logit_bias.to_dict()
        else:
            logit_bias = self.logit_bias

        logprobs: Union[None, Unset, bool]
        if isinstance(self.logprobs, Unset):
            logprobs = UNSET
        else:
            logprobs = self.logprobs

        top_logprobs: Union[None, Unset, int]
        if isinstance(self.top_logprobs, Unset):
            top_logprobs = UNSET
        else:
            top_logprobs = self.top_logprobs

        max_tokens: Union[None, Unset, int]
        if isinstance(self.max_tokens, Unset):
            max_tokens = UNSET
        else:
            max_tokens = self.max_tokens

        n: Union[None, Unset, int]
        if isinstance(self.n, Unset):
            n = UNSET
        else:
            n = self.n

        presence_penalty: Union[None, Unset, float]
        if isinstance(self.presence_penalty, Unset):
            presence_penalty = UNSET
        else:
            presence_penalty = self.presence_penalty

        response_format: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.response_format, Unset):
            response_format = self.response_format.to_dict()

        seed: Union[None, Unset, int]
        if isinstance(self.seed, Unset):
            seed = UNSET
        else:
            seed = self.seed

        stop: Union[List[str], None, Unset, str]
        if isinstance(self.stop, Unset):
            stop = UNSET
        elif isinstance(self.stop, list):
            stop = self.stop

        else:
            stop = self.stop

        stream: Union[None, Unset, bool]
        if isinstance(self.stream, Unset):
            stream = UNSET
        else:
            stream = self.stream

        stream_options: Union[Dict[str, Any], None, Unset]
        if isinstance(self.stream_options, Unset):
            stream_options = UNSET
        elif isinstance(self.stream_options, ChatCompletionStreamOptionsType0):
            stream_options = self.stream_options.to_dict()
        else:
            stream_options = self.stream_options

        temperature: Union[None, Unset, float]
        if isinstance(self.temperature, Unset):
            temperature = UNSET
        else:
            temperature = self.temperature

        top_p: Union[None, Unset, float]
        if isinstance(self.top_p, Unset):
            top_p = UNSET
        else:
            top_p = self.top_p

        tools: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.tools, Unset):
            tools = []
            for tools_item_data in self.tools:
                tools_item = tools_item_data.to_dict()
                tools.append(tools_item)

        tool_choice: Union[Dict[str, Any], Unset, str]
        if isinstance(self.tool_choice, Unset):
            tool_choice = UNSET
        elif isinstance(self.tool_choice, ChatCompletionToolChoiceOptionType0):
            tool_choice = self.tool_choice.value
        else:
            tool_choice = self.tool_choice.to_dict()

        user = self.user

        function_call: Union[Dict[str, Any], Unset, str]
        if isinstance(self.function_call, Unset):
            function_call = UNSET
        elif isinstance(self.function_call, CreateChatCompletionRequestFunctionCallType0):
            function_call = self.function_call.value
        else:
            function_call = self.function_call.to_dict()

        functions: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.functions, Unset):
            functions = []
            for functions_item_data in self.functions:
                functions_item = functions_item_data.to_dict()
                functions.append(functions_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "messages": messages,
                "model": model,
            }
        )
        if frequency_penalty is not UNSET:
            field_dict["frequency_penalty"] = frequency_penalty
        if logit_bias is not UNSET:
            field_dict["logit_bias"] = logit_bias
        if logprobs is not UNSET:
            field_dict["logprobs"] = logprobs
        if top_logprobs is not UNSET:
            field_dict["top_logprobs"] = top_logprobs
        if max_tokens is not UNSET:
            field_dict["max_tokens"] = max_tokens
        if n is not UNSET:
            field_dict["n"] = n
        if presence_penalty is not UNSET:
            field_dict["presence_penalty"] = presence_penalty
        if response_format is not UNSET:
            field_dict["response_format"] = response_format
        if seed is not UNSET:
            field_dict["seed"] = seed
        if stop is not UNSET:
            field_dict["stop"] = stop
        if stream is not UNSET:
            field_dict["stream"] = stream
        if stream_options is not UNSET:
            field_dict["stream_options"] = stream_options
        if temperature is not UNSET:
            field_dict["temperature"] = temperature
        if top_p is not UNSET:
            field_dict["top_p"] = top_p
        if tools is not UNSET:
            field_dict["tools"] = tools
        if tool_choice is not UNSET:
            field_dict["tool_choice"] = tool_choice
        if user is not UNSET:
            field_dict["user"] = user
        if function_call is not UNSET:
            field_dict["function_call"] = function_call
        if functions is not UNSET:
            field_dict["functions"] = functions

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.assistant_message import AssistantMessage
        from ..models.chat_completion_function_call_option import ChatCompletionFunctionCallOption
        from ..models.chat_completion_functions import ChatCompletionFunctions
        from ..models.chat_completion_named_tool_choice import ChatCompletionNamedToolChoice
        from ..models.chat_completion_stream_options_type_0 import ChatCompletionStreamOptionsType0
        from ..models.chat_completion_tool import ChatCompletionTool
        from ..models.create_chat_completion_request_logit_bias_type_0 import CreateChatCompletionRequestLogitBiasType0
        from ..models.create_chat_completion_request_response_format import CreateChatCompletionRequestResponseFormat
        from ..models.function_message import FunctionMessage
        from ..models.system_message import SystemMessage
        from ..models.tool_message import ToolMessage
        from ..models.user_message import UserMessage

        d = src_dict.copy()
        messages = []
        _messages = d.pop("messages")
        for messages_item_data in _messages:

            def _parse_messages_item(
                data: object,
            ) -> Union["AssistantMessage", "FunctionMessage", "SystemMessage", "ToolMessage", "UserMessage"]:
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    componentsschemas_chat_completion_request_message_type_0 = SystemMessage.from_dict(data)

                    return componentsschemas_chat_completion_request_message_type_0
                except:  # noqa: E722
                    pass
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    componentsschemas_chat_completion_request_message_type_1 = UserMessage.from_dict(data)

                    return componentsschemas_chat_completion_request_message_type_1
                except:  # noqa: E722
                    pass
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    componentsschemas_chat_completion_request_message_type_2 = AssistantMessage.from_dict(data)

                    return componentsschemas_chat_completion_request_message_type_2
                except:  # noqa: E722
                    pass
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    componentsschemas_chat_completion_request_message_type_3 = ToolMessage.from_dict(data)

                    return componentsschemas_chat_completion_request_message_type_3
                except:  # noqa: E722
                    pass
                if not isinstance(data, dict):
                    raise TypeError()
                componentsschemas_chat_completion_request_message_type_4 = FunctionMessage.from_dict(data)

                return componentsschemas_chat_completion_request_message_type_4

            messages_item = _parse_messages_item(messages_item_data)

            messages.append(messages_item)

        def _parse_model(data: object) -> Union[CreateChatCompletionRequestModelType1, str]:
            try:
                if not isinstance(data, str):
                    raise TypeError()
                model_type_1 = CreateChatCompletionRequestModelType1(data)

                return model_type_1
            except:  # noqa: E722
                pass
            return cast(Union[CreateChatCompletionRequestModelType1, str], data)

        model = _parse_model(d.pop("model"))

        def _parse_frequency_penalty(data: object) -> Union[None, Unset, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, float], data)

        frequency_penalty = _parse_frequency_penalty(d.pop("frequency_penalty", UNSET))

        def _parse_logit_bias(data: object) -> Union["CreateChatCompletionRequestLogitBiasType0", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                logit_bias_type_0 = CreateChatCompletionRequestLogitBiasType0.from_dict(data)

                return logit_bias_type_0
            except:  # noqa: E722
                pass
            return cast(Union["CreateChatCompletionRequestLogitBiasType0", None, Unset], data)

        logit_bias = _parse_logit_bias(d.pop("logit_bias", UNSET))

        def _parse_logprobs(data: object) -> Union[None, Unset, bool]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, bool], data)

        logprobs = _parse_logprobs(d.pop("logprobs", UNSET))

        def _parse_top_logprobs(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        top_logprobs = _parse_top_logprobs(d.pop("top_logprobs", UNSET))

        def _parse_max_tokens(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        max_tokens = _parse_max_tokens(d.pop("max_tokens", UNSET))

        def _parse_n(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        n = _parse_n(d.pop("n", UNSET))

        def _parse_presence_penalty(data: object) -> Union[None, Unset, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, float], data)

        presence_penalty = _parse_presence_penalty(d.pop("presence_penalty", UNSET))

        _response_format = d.pop("response_format", UNSET)
        response_format: Union[Unset, CreateChatCompletionRequestResponseFormat]
        if isinstance(_response_format, Unset):
            response_format = UNSET
        else:
            response_format = CreateChatCompletionRequestResponseFormat.from_dict(_response_format)

        def _parse_seed(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        seed = _parse_seed(d.pop("seed", UNSET))

        def _parse_stop(data: object) -> Union[List[str], None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                stop_type_1 = cast(List[str], data)

                return stop_type_1
            except:  # noqa: E722
                pass
            return cast(Union[List[str], None, Unset, str], data)

        stop = _parse_stop(d.pop("stop", UNSET))

        def _parse_stream(data: object) -> Union[None, Unset, bool]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, bool], data)

        stream = _parse_stream(d.pop("stream", UNSET))

        def _parse_stream_options(data: object) -> Union["ChatCompletionStreamOptionsType0", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                componentsschemas_chat_completion_stream_options_type_0 = ChatCompletionStreamOptionsType0.from_dict(
                    data
                )

                return componentsschemas_chat_completion_stream_options_type_0
            except:  # noqa: E722
                pass
            return cast(Union["ChatCompletionStreamOptionsType0", None, Unset], data)

        stream_options = _parse_stream_options(d.pop("stream_options", UNSET))

        def _parse_temperature(data: object) -> Union[None, Unset, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, float], data)

        temperature = _parse_temperature(d.pop("temperature", UNSET))

        def _parse_top_p(data: object) -> Union[None, Unset, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, float], data)

        top_p = _parse_top_p(d.pop("top_p", UNSET))

        tools = []
        _tools = d.pop("tools", UNSET)
        for tools_item_data in _tools or []:
            tools_item = ChatCompletionTool.from_dict(tools_item_data)

            tools.append(tools_item)

        def _parse_tool_choice(
            data: object,
        ) -> Union["ChatCompletionNamedToolChoice", ChatCompletionToolChoiceOptionType0, Unset]:
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                componentsschemas_chat_completion_tool_choice_option_type_0 = ChatCompletionToolChoiceOptionType0(data)

                return componentsschemas_chat_completion_tool_choice_option_type_0
            except:  # noqa: E722
                pass
            if not isinstance(data, dict):
                raise TypeError()
            componentsschemas_chat_completion_tool_choice_option_type_1 = ChatCompletionNamedToolChoice.from_dict(data)

            return componentsschemas_chat_completion_tool_choice_option_type_1

        tool_choice = _parse_tool_choice(d.pop("tool_choice", UNSET))

        user = d.pop("user", UNSET)

        def _parse_function_call(
            data: object,
        ) -> Union["ChatCompletionFunctionCallOption", CreateChatCompletionRequestFunctionCallType0, Unset]:
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                function_call_type_0 = CreateChatCompletionRequestFunctionCallType0(data)

                return function_call_type_0
            except:  # noqa: E722
                pass
            if not isinstance(data, dict):
                raise TypeError()
            function_call_type_1 = ChatCompletionFunctionCallOption.from_dict(data)

            return function_call_type_1

        function_call = _parse_function_call(d.pop("function_call", UNSET))

        functions = []
        _functions = d.pop("functions", UNSET)
        for functions_item_data in _functions or []:
            functions_item = ChatCompletionFunctions.from_dict(functions_item_data)

            functions.append(functions_item)

        create_chat_completion_request = cls(
            messages=messages,
            model=model,
            frequency_penalty=frequency_penalty,
            logit_bias=logit_bias,
            logprobs=logprobs,
            top_logprobs=top_logprobs,
            max_tokens=max_tokens,
            n=n,
            presence_penalty=presence_penalty,
            response_format=response_format,
            seed=seed,
            stop=stop,
            stream=stream,
            stream_options=stream_options,
            temperature=temperature,
            top_p=top_p,
            tools=tools,
            tool_choice=tool_choice,
            user=user,
            function_call=function_call,
            functions=functions,
        )

        create_chat_completion_request.additional_properties = d
        return create_chat_completion_request

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
