from typing import Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

T = TypeVar("T", bound="ChatCompletionResponseMessageFunctionCall")


@_attrs_define
class ChatCompletionResponseMessageFunctionCall:
    """Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by
    the model.

        Attributes:
            arguments (str): The arguments to call the function with, as generated by the model in JSON format. Note that
                the model does not always generate valid JSON, and may hallucinate parameters not defined by your function
                schema. Validate the arguments in your code before calling your function.
            name (str): The name of the function to call.
    """

    arguments: str
    name: str
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        arguments = self.arguments

        name = self.name

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "arguments": arguments,
                "name": name,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        arguments = d.pop("arguments")

        name = d.pop("name")

        chat_completion_response_message_function_call = cls(
            arguments=arguments,
            name=name,
        )

        chat_completion_response_message_function_call.additional_properties = d
        return chat_completion_response_message_function_call

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
