from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.chat_completion_response_message_role import ChatCompletionResponseMessageRole
from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.chat_completion_message_tool_call import ChatCompletionMessageToolCall
    from ..models.chat_completion_response_message_function_call import ChatCompletionResponseMessageFunctionCall


T = TypeVar("T", bound="ChatCompletionResponseMessage")


@_attrs_define
class ChatCompletionResponseMessage:
    """A chat completion message generated by the model.

    Attributes:
        content (Union[None, str]): The contents of the message.
        role (ChatCompletionResponseMessageRole): The role of the author of this message.
        tool_calls (Union[Unset, List['ChatCompletionMessageToolCall']]): The tool calls generated by the model, such as
            function calls.
        function_call (Union[Unset, ChatCompletionResponseMessageFunctionCall]): Deprecated and replaced by
            `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
    """

    content: Union[None, str]
    role: ChatCompletionResponseMessageRole
    tool_calls: Union[Unset, List["ChatCompletionMessageToolCall"]] = UNSET
    function_call: Union[Unset, "ChatCompletionResponseMessageFunctionCall"] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        content: Union[None, str]
        content = self.content

        role = self.role.value

        tool_calls: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.tool_calls, Unset):
            tool_calls = []
            for componentsschemas_chat_completion_message_tool_calls_item_data in self.tool_calls:
                componentsschemas_chat_completion_message_tool_calls_item = (
                    componentsschemas_chat_completion_message_tool_calls_item_data.to_dict()
                )
                tool_calls.append(componentsschemas_chat_completion_message_tool_calls_item)

        function_call: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.function_call, Unset):
            function_call = self.function_call.to_dict()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "content": content,
                "role": role,
            }
        )
        if tool_calls is not UNSET:
            field_dict["tool_calls"] = tool_calls
        if function_call is not UNSET:
            field_dict["function_call"] = function_call

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.chat_completion_message_tool_call import ChatCompletionMessageToolCall
        from ..models.chat_completion_response_message_function_call import ChatCompletionResponseMessageFunctionCall

        d = src_dict.copy()

        def _parse_content(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        content = _parse_content(d.pop("content"))

        role = ChatCompletionResponseMessageRole(d.pop("role"))

        tool_calls = []
        _tool_calls = d.pop("tool_calls", UNSET)
        for componentsschemas_chat_completion_message_tool_calls_item_data in _tool_calls or []:
            componentsschemas_chat_completion_message_tool_calls_item = ChatCompletionMessageToolCall.from_dict(
                componentsschemas_chat_completion_message_tool_calls_item_data
            )

            tool_calls.append(componentsschemas_chat_completion_message_tool_calls_item)

        _function_call = d.pop("function_call", UNSET)
        function_call: Union[Unset, ChatCompletionResponseMessageFunctionCall]
        if isinstance(_function_call, Unset):
            function_call = UNSET
        else:
            function_call = ChatCompletionResponseMessageFunctionCall.from_dict(_function_call)

        chat_completion_response_message = cls(
            content=content,
            role=role,
            tool_calls=tool_calls,
            function_call=function_call,
        )

        chat_completion_response_message.additional_properties = d
        return chat_completion_response_message

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
