from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.create_completion_request_model_type_1 import CreateCompletionRequestModelType1
from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.chat_completion_stream_options_type_0 import ChatCompletionStreamOptionsType0
    from ..models.create_completion_request_logit_bias_type_0 import CreateCompletionRequestLogitBiasType0


T = TypeVar("T", bound="CreateCompletionRequest")


@_attrs_define
class CreateCompletionRequest:
    """
    Attributes:
        model (Union[CreateCompletionRequestModelType1, str]): ID of the model to use. You can use the [List
            models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model
            overview](/docs/models/overview) for descriptions of them.
        prompt (Union[List[List[int]], List[int], List[str], None, str]): The prompt(s) to generate completions for,
            encoded as a string, array of strings, array of tokens, or array of token arrays.

            Note that <|endoftext|> is the document separator that the model sees during training, so if a prompt is not
            specified the model will generate as if from the beginning of a new document.
             Default: '<|endoftext|>'.
        best_of (Union[None, Unset, int]): Generates `best_of` completions server-side and returns the "best" (the one
            with the highest log probability per token). Results cannot be streamed.

            When used with `n`, `best_of` controls the number of candidate completions and `n` specifies how many to return
            – `best_of` must be greater than `n`.

            **Note:** Because this parameter generates many completions, it can quickly consume your token quota. Use
            carefully and ensure that you have reasonable settings for `max_tokens` and `stop`.
             Default: 1.
        echo (Union[None, Unset, bool]): Echo back the prompt in addition to the completion
             Default: False.
        frequency_penalty (Union[None, Unset, float]): Number between -2.0 and 2.0. Positive values penalize new tokens
            based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line
            verbatim.

            [See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)
             Default: 0.0.
        logit_bias (Union['CreateCompletionRequestLogitBiasType0', None, Unset]): Modify the likelihood of specified
            tokens appearing in the completion.

            Accepts a JSON object that maps tokens (specified by their token ID in the GPT tokenizer) to an associated bias
            value from -100 to 100. You can use this [tokenizer tool](/tokenizer?view=bpe) to convert text to token IDs.
            Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will
            vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like
            -100 or 100 should result in a ban or exclusive selection of the relevant token.

            As an example, you can pass `{"50256": -100}` to prevent the <|endoftext|> token from being generated.
        logprobs (Union[None, Unset, int]): Include the log probabilities on the `logprobs` most likely output tokens,
            as well the chosen tokens. For example, if `logprobs` is 5, the API will return a list of the 5 most likely
            tokens. The API will always return the `logprob` of the sampled token, so there may be up to `logprobs+1`
            elements in the response.

            The maximum value for `logprobs` is 5.
        max_tokens (Union[None, Unset, int]): The maximum number of [tokens](/tokenizer) that can be generated in the
            completion.

            The token count of your prompt plus `max_tokens` cannot exceed the model's context length. [Example Python
            code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.
             Default: 16. Example: 16.
        n (Union[None, Unset, int]): How many completions to generate for each prompt.

            **Note:** Because this parameter generates many completions, it can quickly consume your token quota. Use
            carefully and ensure that you have reasonable settings for `max_tokens` and `stop`.
             Default: 1. Example: 1.
        presence_penalty (Union[None, Unset, float]): Number between -2.0 and 2.0. Positive values penalize new tokens
            based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.

            [See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)
             Default: 0.0.
        seed (Union[None, Unset, int]): If specified, our system will make a best effort to sample deterministically,
            such that repeated requests with the same `seed` and parameters should return the same result.

            Determinism is not guaranteed, and you should refer to the `system_fingerprint` response parameter to monitor
            changes in the backend.
        stop (Union[List[str], None, Unset, str]): Up to 4 sequences where the API will stop generating further tokens.
            The returned text will not contain the stop sequence.
        stream (Union[None, Unset, bool]): Whether to stream back partial progress. If set, tokens will be sent as data-
            only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-
            sent_events#Event_stream_format) as they become available, with the stream terminated by a `data: [DONE]`
            message. [Example Python code](https://cookbook.openai.com/examples/how_to_stream_completions).
             Default: False.
        stream_options (Union['ChatCompletionStreamOptionsType0', None, Unset]): Options for streaming response. Only
            set this when you set `stream: true`.
        suffix (Union[None, Unset, str]): The suffix that comes after a completion of inserted text.

            This parameter is only supported for `gpt-3.5-turbo-instruct`.
             Example: test..
        temperature (Union[None, Unset, float]): What sampling temperature to use, between 0 and 2. Higher values like
            0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.

            We generally recommend altering this or `top_p` but not both.
             Default: 1.0. Example: 1.
        top_p (Union[None, Unset, float]): An alternative to sampling with temperature, called nucleus sampling, where
            the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens
            comprising the top 10% probability mass are considered.

            We generally recommend altering this or `temperature` but not both.
             Default: 1.0. Example: 1.
        user (Union[Unset, str]): A unique identifier representing your end-user, which can help OpenAI to monitor and
            detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
             Example: user-1234.
    """

    model: Union[CreateCompletionRequestModelType1, str]
    prompt: Union[List[List[int]], List[int], List[str], None, str] = "<|endoftext|>"
    best_of: Union[None, Unset, int] = 1
    echo: Union[None, Unset, bool] = False
    frequency_penalty: Union[None, Unset, float] = 0.0
    logit_bias: Union["CreateCompletionRequestLogitBiasType0", None, Unset] = UNSET
    logprobs: Union[None, Unset, int] = UNSET
    max_tokens: Union[None, Unset, int] = 16
    n: Union[None, Unset, int] = 1
    presence_penalty: Union[None, Unset, float] = 0.0
    seed: Union[None, Unset, int] = UNSET
    stop: Union[List[str], None, Unset, str] = UNSET
    stream: Union[None, Unset, bool] = False
    stream_options: Union["ChatCompletionStreamOptionsType0", None, Unset] = UNSET
    suffix: Union[None, Unset, str] = UNSET
    temperature: Union[None, Unset, float] = 1.0
    top_p: Union[None, Unset, float] = 1.0
    user: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        from ..models.chat_completion_stream_options_type_0 import ChatCompletionStreamOptionsType0
        from ..models.create_completion_request_logit_bias_type_0 import CreateCompletionRequestLogitBiasType0

        model: str
        if isinstance(self.model, CreateCompletionRequestModelType1):
            model = self.model.value
        else:
            model = self.model

        prompt: Union[List[List[int]], List[int], List[str], None, str]
        if isinstance(self.prompt, list):
            prompt = self.prompt

        elif isinstance(self.prompt, list):
            prompt = self.prompt

        elif isinstance(self.prompt, list):
            prompt = []
            for prompt_type_3_item_data in self.prompt:
                prompt_type_3_item = prompt_type_3_item_data

                prompt.append(prompt_type_3_item)

        else:
            prompt = self.prompt

        best_of: Union[None, Unset, int]
        if isinstance(self.best_of, Unset):
            best_of = UNSET
        else:
            best_of = self.best_of

        echo: Union[None, Unset, bool]
        if isinstance(self.echo, Unset):
            echo = UNSET
        else:
            echo = self.echo

        frequency_penalty: Union[None, Unset, float]
        if isinstance(self.frequency_penalty, Unset):
            frequency_penalty = UNSET
        else:
            frequency_penalty = self.frequency_penalty

        logit_bias: Union[Dict[str, Any], None, Unset]
        if isinstance(self.logit_bias, Unset):
            logit_bias = UNSET
        elif isinstance(self.logit_bias, CreateCompletionRequestLogitBiasType0):
            logit_bias = self.logit_bias.to_dict()
        else:
            logit_bias = self.logit_bias

        logprobs: Union[None, Unset, int]
        if isinstance(self.logprobs, Unset):
            logprobs = UNSET
        else:
            logprobs = self.logprobs

        max_tokens: Union[None, Unset, int]
        if isinstance(self.max_tokens, Unset):
            max_tokens = UNSET
        else:
            max_tokens = self.max_tokens

        n: Union[None, Unset, int]
        if isinstance(self.n, Unset):
            n = UNSET
        else:
            n = self.n

        presence_penalty: Union[None, Unset, float]
        if isinstance(self.presence_penalty, Unset):
            presence_penalty = UNSET
        else:
            presence_penalty = self.presence_penalty

        seed: Union[None, Unset, int]
        if isinstance(self.seed, Unset):
            seed = UNSET
        else:
            seed = self.seed

        stop: Union[List[str], None, Unset, str]
        if isinstance(self.stop, Unset):
            stop = UNSET
        elif isinstance(self.stop, list):
            stop = self.stop

        else:
            stop = self.stop

        stream: Union[None, Unset, bool]
        if isinstance(self.stream, Unset):
            stream = UNSET
        else:
            stream = self.stream

        stream_options: Union[Dict[str, Any], None, Unset]
        if isinstance(self.stream_options, Unset):
            stream_options = UNSET
        elif isinstance(self.stream_options, ChatCompletionStreamOptionsType0):
            stream_options = self.stream_options.to_dict()
        else:
            stream_options = self.stream_options

        suffix: Union[None, Unset, str]
        if isinstance(self.suffix, Unset):
            suffix = UNSET
        else:
            suffix = self.suffix

        temperature: Union[None, Unset, float]
        if isinstance(self.temperature, Unset):
            temperature = UNSET
        else:
            temperature = self.temperature

        top_p: Union[None, Unset, float]
        if isinstance(self.top_p, Unset):
            top_p = UNSET
        else:
            top_p = self.top_p

        user = self.user

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "model": model,
                "prompt": prompt,
            }
        )
        if best_of is not UNSET:
            field_dict["best_of"] = best_of
        if echo is not UNSET:
            field_dict["echo"] = echo
        if frequency_penalty is not UNSET:
            field_dict["frequency_penalty"] = frequency_penalty
        if logit_bias is not UNSET:
            field_dict["logit_bias"] = logit_bias
        if logprobs is not UNSET:
            field_dict["logprobs"] = logprobs
        if max_tokens is not UNSET:
            field_dict["max_tokens"] = max_tokens
        if n is not UNSET:
            field_dict["n"] = n
        if presence_penalty is not UNSET:
            field_dict["presence_penalty"] = presence_penalty
        if seed is not UNSET:
            field_dict["seed"] = seed
        if stop is not UNSET:
            field_dict["stop"] = stop
        if stream is not UNSET:
            field_dict["stream"] = stream
        if stream_options is not UNSET:
            field_dict["stream_options"] = stream_options
        if suffix is not UNSET:
            field_dict["suffix"] = suffix
        if temperature is not UNSET:
            field_dict["temperature"] = temperature
        if top_p is not UNSET:
            field_dict["top_p"] = top_p
        if user is not UNSET:
            field_dict["user"] = user

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.chat_completion_stream_options_type_0 import ChatCompletionStreamOptionsType0
        from ..models.create_completion_request_logit_bias_type_0 import CreateCompletionRequestLogitBiasType0

        d = src_dict.copy()

        def _parse_model(data: object) -> Union[CreateCompletionRequestModelType1, str]:
            try:
                if not isinstance(data, str):
                    raise TypeError()
                model_type_1 = CreateCompletionRequestModelType1(data)

                return model_type_1
            except:  # noqa: E722
                pass
            return cast(Union[CreateCompletionRequestModelType1, str], data)

        model = _parse_model(d.pop("model"))

        def _parse_prompt(data: object) -> Union[List[List[int]], List[int], List[str], None, str]:
            if data is None:
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                prompt_type_1 = cast(List[str], data)

                return prompt_type_1
            except:  # noqa: E722
                pass
            try:
                if not isinstance(data, list):
                    raise TypeError()
                prompt_type_2 = cast(List[int], data)

                return prompt_type_2
            except:  # noqa: E722
                pass
            try:
                if not isinstance(data, list):
                    raise TypeError()
                prompt_type_3 = []
                _prompt_type_3 = data
                for prompt_type_3_item_data in _prompt_type_3:
                    prompt_type_3_item = cast(List[int], prompt_type_3_item_data)

                    prompt_type_3.append(prompt_type_3_item)

                return prompt_type_3
            except:  # noqa: E722
                pass
            return cast(Union[List[List[int]], List[int], List[str], None, str], data)

        prompt = _parse_prompt(d.pop("prompt"))

        def _parse_best_of(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        best_of = _parse_best_of(d.pop("best_of", UNSET))

        def _parse_echo(data: object) -> Union[None, Unset, bool]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, bool], data)

        echo = _parse_echo(d.pop("echo", UNSET))

        def _parse_frequency_penalty(data: object) -> Union[None, Unset, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, float], data)

        frequency_penalty = _parse_frequency_penalty(d.pop("frequency_penalty", UNSET))

        def _parse_logit_bias(data: object) -> Union["CreateCompletionRequestLogitBiasType0", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                logit_bias_type_0 = CreateCompletionRequestLogitBiasType0.from_dict(data)

                return logit_bias_type_0
            except:  # noqa: E722
                pass
            return cast(Union["CreateCompletionRequestLogitBiasType0", None, Unset], data)

        logit_bias = _parse_logit_bias(d.pop("logit_bias", UNSET))

        def _parse_logprobs(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        logprobs = _parse_logprobs(d.pop("logprobs", UNSET))

        def _parse_max_tokens(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        max_tokens = _parse_max_tokens(d.pop("max_tokens", UNSET))

        def _parse_n(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        n = _parse_n(d.pop("n", UNSET))

        def _parse_presence_penalty(data: object) -> Union[None, Unset, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, float], data)

        presence_penalty = _parse_presence_penalty(d.pop("presence_penalty", UNSET))

        def _parse_seed(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        seed = _parse_seed(d.pop("seed", UNSET))

        def _parse_stop(data: object) -> Union[List[str], None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                stop_type_1 = cast(List[str], data)

                return stop_type_1
            except:  # noqa: E722
                pass
            return cast(Union[List[str], None, Unset, str], data)

        stop = _parse_stop(d.pop("stop", UNSET))

        def _parse_stream(data: object) -> Union[None, Unset, bool]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, bool], data)

        stream = _parse_stream(d.pop("stream", UNSET))

        def _parse_stream_options(data: object) -> Union["ChatCompletionStreamOptionsType0", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                componentsschemas_chat_completion_stream_options_type_0 = ChatCompletionStreamOptionsType0.from_dict(
                    data
                )

                return componentsschemas_chat_completion_stream_options_type_0
            except:  # noqa: E722
                pass
            return cast(Union["ChatCompletionStreamOptionsType0", None, Unset], data)

        stream_options = _parse_stream_options(d.pop("stream_options", UNSET))

        def _parse_suffix(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        suffix = _parse_suffix(d.pop("suffix", UNSET))

        def _parse_temperature(data: object) -> Union[None, Unset, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, float], data)

        temperature = _parse_temperature(d.pop("temperature", UNSET))

        def _parse_top_p(data: object) -> Union[None, Unset, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, float], data)

        top_p = _parse_top_p(d.pop("top_p", UNSET))

        user = d.pop("user", UNSET)

        create_completion_request = cls(
            model=model,
            prompt=prompt,
            best_of=best_of,
            echo=echo,
            frequency_penalty=frequency_penalty,
            logit_bias=logit_bias,
            logprobs=logprobs,
            max_tokens=max_tokens,
            n=n,
            presence_penalty=presence_penalty,
            seed=seed,
            stop=stop,
            stream=stream,
            stream_options=stream_options,
            suffix=suffix,
            temperature=temperature,
            top_p=top_p,
            user=user,
        )

        create_completion_request.additional_properties = d
        return create_completion_request

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
