from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.chat_completion_stream_response_delta_role import ChatCompletionStreamResponseDeltaRole
from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.chat_completion_message_tool_call_chunk import ChatCompletionMessageToolCallChunk
    from ..models.chat_completion_stream_response_delta_function_call import (
        ChatCompletionStreamResponseDeltaFunctionCall,
    )


T = TypeVar("T", bound="ChatCompletionStreamResponseDelta")


@_attrs_define
class ChatCompletionStreamResponseDelta:
    """A chat completion delta generated by streamed model responses.

    Attributes:
        content (Union[None, Unset, str]): The contents of the chunk message.
        function_call (Union[Unset, ChatCompletionStreamResponseDeltaFunctionCall]): Deprecated and replaced by
            `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
        tool_calls (Union[Unset, List['ChatCompletionMessageToolCallChunk']]):
        role (Union[Unset, ChatCompletionStreamResponseDeltaRole]): The role of the author of this message.
    """

    content: Union[None, Unset, str] = UNSET
    function_call: Union[Unset, "ChatCompletionStreamResponseDeltaFunctionCall"] = UNSET
    tool_calls: Union[Unset, List["ChatCompletionMessageToolCallChunk"]] = UNSET
    role: Union[Unset, ChatCompletionStreamResponseDeltaRole] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        content: Union[None, Unset, str]
        if isinstance(self.content, Unset):
            content = UNSET
        else:
            content = self.content

        function_call: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.function_call, Unset):
            function_call = self.function_call.to_dict()

        tool_calls: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.tool_calls, Unset):
            tool_calls = []
            for tool_calls_item_data in self.tool_calls:
                tool_calls_item = tool_calls_item_data.to_dict()
                tool_calls.append(tool_calls_item)

        role: Union[Unset, str] = UNSET
        if not isinstance(self.role, Unset):
            role = self.role.value

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if content is not UNSET:
            field_dict["content"] = content
        if function_call is not UNSET:
            field_dict["function_call"] = function_call
        if tool_calls is not UNSET:
            field_dict["tool_calls"] = tool_calls
        if role is not UNSET:
            field_dict["role"] = role

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.chat_completion_message_tool_call_chunk import ChatCompletionMessageToolCallChunk
        from ..models.chat_completion_stream_response_delta_function_call import (
            ChatCompletionStreamResponseDeltaFunctionCall,
        )

        d = src_dict.copy()

        def _parse_content(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        content = _parse_content(d.pop("content", UNSET))

        _function_call = d.pop("function_call", UNSET)
        function_call: Union[Unset, ChatCompletionStreamResponseDeltaFunctionCall]
        if isinstance(_function_call, Unset):
            function_call = UNSET
        else:
            function_call = ChatCompletionStreamResponseDeltaFunctionCall.from_dict(_function_call)

        tool_calls = []
        _tool_calls = d.pop("tool_calls", UNSET)
        for tool_calls_item_data in _tool_calls or []:
            tool_calls_item = ChatCompletionMessageToolCallChunk.from_dict(tool_calls_item_data)

            tool_calls.append(tool_calls_item)

        _role = d.pop("role", UNSET)
        role: Union[Unset, ChatCompletionStreamResponseDeltaRole]
        if isinstance(_role, Unset):
            role = UNSET
        else:
            role = ChatCompletionStreamResponseDeltaRole(_role)

        chat_completion_stream_response_delta = cls(
            content=content,
            function_call=function_call,
            tool_calls=tool_calls,
            role=role,
        )

        chat_completion_stream_response_delta.additional_properties = d
        return chat_completion_stream_response_delta

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
