# OpenAPI CLI

OpenAPI CLI is a command-line interface (CLI) tool designed to interact with APIs generated by `openapi-python-client`. This tool allows you to configure and use API clients with ease.

## Features

- Configure API client modules
- Validate client modules
- Generate API client instances

## Installation

To install OpenAPI CLI, use `poetry`:

```sh
poetry install openapi-cli
```

## Usage

To use OpenAPI CLI in your project add the following to your `pyproject.toml`:

```toml

    [tool.poetry.scripts]
    openapi-cli = "openapi_cli:cli"

```

Then, you can run the CLI using in venv activated shell:

```sh

    openapi-cli --help

```

### Configure the CLI

Before using the CLI, you need to configure it with your client module, base URL, and token.

```sh
openapi configure --client-module <client_module_name> --base-url <base_url> --token <token>
```

### Requirements

- Python 3.11+
- Poetry

### Setup

1. Clone the repository.
2. Install dependencies using `poetry install`.

### Code Formatting

This project uses `black` and `isort` for code formatting. To format the code, run:

```sh
poetry run black .
poetry run isort .
```

## License

This project is licensed under the MIT License. See the `LICENSE` file for more details.
