# OpenAPI CLI

OpenAPI CLI is a command-line interface (CLI) tool designed to interact with APIs generated by `openapi-python-client`. This tool allows you to configure and use API clients with ease.

## Features

- Configure API client modules
- Validate client modules
- Generate API client instances

## Installation

To install OpenAPI CLI, use `poetry`:

```sh
poetry add openapi-cli[full]
```

To install the CLI globally, use `pip`:

```sh
pip install openapi-cli[full]
```

## Optional
If you want to just use separator for your operation ids use:

```bash
poetry add openapi-cli
```

This will not have a cli, but you can use the separator in your code.
If you want to still have ability to generate clients use the following:

```bash
poetry add openapi-cli[full] --group dev
```

This will keep your project build clean and will not install the cli in your production environment.

## Usage

To use OpenAPI CLI in your project add the following to your `pyproject.toml`:

```toml

    [tool.poetry.scripts]
    your-api-cli = "openapi_cli:cli"

```

Then, you can run the CLI using in venv activated shell:

```sh

    your-api-cli --help

```

### Configure the CLI

Before using the CLI, you need to configure it with your client module, base URL, and token.

Install the client module using downloaded module using `openapi-python-client`:
```sh
your-api-cli client install --module <name_of_your_module> 
```

Set the base URL and token for the client module:

```sh
openapi client api-config --base-url <url_of_your_api>
openapi client auth --token <your_token>
```

Patch the client to support nesting:

```sh
openapi client patch --separator <your_operation_id_separator>  # default is '_oaps_'
```

You can import separator to integrate it with your code:

```python
from openapi_cli.separator import CLI_SEPARATOR
```

### Requirements

- Python 3.12+
- Poetry

### Setup

1. Clone the repository.
2. Install dependencies using `poetry install`.

### Code Formatting

This project uses `black` and `isort` for code formatting. To format the code, run:

```sh
poetry run black .
poetry run isort .
```

## License

This project is licensed under the MIT License. See the `LICENSE` file for more details.
