[![triaxtec](https://circleci.com/gh/triaxtec/openapi-python-client.svg?style=svg)](https://circleci.com/gh/triaxtec/openapi-python-client)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)
[![codecov](https://codecov.io/gh/triaxtec/openapi-python-client/branch/master/graph/badge.svg)](https://codecov.io/gh/triaxtec/openapi-python-client)
[![PyPI version shields.io](https://img.shields.io/pypi/v/openapi-python-client.svg)](https://pypi.python.org/pypi/openapi-python-client/)

# openapi-python-client
Generate modern Python clients from OpenAPI

**This project is still in early development and does not support all OpenAPI features**

## Why This?
The Python clients generated by openapi-generator support Python 2 and therefore come with a lot of baggage. This tool 
aims to generate clients which:
1. Use all the latest and greatest Python features like type annotations and dataclasses
1. Don't carry around a bunch of compatibility code for older version of Python (e.g. the `six` package)
1. Have better documentation and more obvious usage instructions

Additionally, because this generator is written in Python, it should be more accessible to contribution by the people 
using it (Python developers).

## Installation
`pip install openapi-python-client`

## Usage
`openapi-python-client generate --url https://my.api.com/openapi.json`

This will generate a new client library named based on the title in your OpenAPI spec.  For example, if the title 
of your API is "My API", the expected output will be "my-api-client".  If a folder already exists by that name, you'll 
get an error.

## What You Get
1. A `pyproject.toml` file with some basic metadata intended to be used with [Poetry].
1. A `README.md` you'll most definitely need to update with your project's details
1. A Python module named just like the auto-generated project name (e.g. "my_api_client") which contains:
    1. A `client` module which will have both a `Client` class and an `AuthenticatedClient` class.  You'll need these 
    for calling the functions in the `api` module.
    1. An `api` module which will contain one module for each tag in your OpenAPI spec, as well as a `default` module 
    for endpoints without a tag.  Each of these modules in turn contains one function for calling each endpoint.
    1. A `models` module which has all the classes defined by the various schemas in your OpenAPI spec
    
## OpenAPI features supported
1. All HTTP Methods
1. JSON and form bodies, path and query parameters
1. float, string, int, datetimes, string enums, and custom schemas or lists containing any of those
1. html/text or application/json responses containing any of the previous types
1. Bearer token security


## Contributors 
 - Dylan Anthony <danthony@triaxtec.com> (Owner)


[CHANGELOG.md]: CHANGELOG.md
[Poetry]: https://python-poetry.org/
