# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class ObjectFieldSelector(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, api_version=None, field_path=None):  # noqa: E501
        """ObjectFieldSelector - a model defined in OpenAPI

        :param api_version: The api_version of this ObjectFieldSelector.  # noqa: E501
        :type api_version: str
        :param field_path: The field_path of this ObjectFieldSelector.  # noqa: E501
        :type field_path: str
        """
        self.openapi_types = {
            'api_version': str,
            'field_path': str
        }

        self.attribute_map = {
            'api_version': 'api_version',
            'field_path': 'field_path'
        }

        self._api_version = api_version
        self._field_path = field_path

    @classmethod
    def from_dict(cls, dikt) -> 'ObjectFieldSelector':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ObjectFieldSelector of this ObjectFieldSelector.  # noqa: E501
        :rtype: ObjectFieldSelector
        """
        return util.deserialize_model(dikt, cls)

    @property
    def api_version(self):
        """Gets the api_version of this ObjectFieldSelector.

        Version of the schema the FieldPath is written in terms of, defaults to \"v1\".  # noqa: E501

        :return: The api_version of this ObjectFieldSelector.
        :rtype: str
        """
        return self._api_version

    @api_version.setter
    def api_version(self, api_version):
        """Sets the api_version of this ObjectFieldSelector.

        Version of the schema the FieldPath is written in terms of, defaults to \"v1\".  # noqa: E501

        :param api_version: The api_version of this ObjectFieldSelector.
        :type api_version: str
        """

        self._api_version = api_version

    @property
    def field_path(self):
        """Gets the field_path of this ObjectFieldSelector.

        Path of the field to select in the specified API version.  # noqa: E501

        :return: The field_path of this ObjectFieldSelector.
        :rtype: str
        """
        return self._field_path

    @field_path.setter
    def field_path(self, field_path):
        """Sets the field_path of this ObjectFieldSelector.

        Path of the field to select in the specified API version.  # noqa: E501

        :param field_path: The field_path of this ObjectFieldSelector.
        :type field_path: str
        """

        self._field_path = field_path
