# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server.models.rbac_rule import RBACRule
from openapi_server import util

from openapi_server.models.rbac_rule import RBACRule  # noqa: E501

class Role(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, kind=None, namespace=None, labels=None, rules=None):  # noqa: E501
        """Role - a model defined in OpenAPI

        :param name: The name of this Role.  # noqa: E501
        :type name: str
        :param kind: The kind of this Role.  # noqa: E501
        :type kind: str
        :param namespace: The namespace of this Role.  # noqa: E501
        :type namespace: str
        :param labels: The labels of this Role.  # noqa: E501
        :type labels: List[str]
        :param rules: The rules of this Role.  # noqa: E501
        :type rules: List[RBACRule]
        """
        self.openapi_types = {
            'name': str,
            'kind': str,
            'namespace': str,
            'labels': List[str],
            'rules': List[RBACRule]
        }

        self.attribute_map = {
            'name': 'name',
            'kind': 'kind',
            'namespace': 'namespace',
            'labels': 'labels',
            'rules': 'rules'
        }

        self._name = name
        self._kind = kind
        self._namespace = namespace
        self._labels = labels
        self._rules = rules

    @classmethod
    def from_dict(cls, dikt) -> 'Role':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Role of this Role.  # noqa: E501
        :rtype: Role
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this Role.

        name of Role or ClusterRole  # noqa: E501

        :return: The name of this Role.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Role.

        name of Role or ClusterRole  # noqa: E501

        :param name: The name of this Role.
        :type name: str
        """

        self._name = name

    @property
    def kind(self):
        """Gets the kind of this Role.

        kind of Role, value supports Role and ClusterRole. Role is default.  # noqa: E501

        :return: The kind of this Role.
        :rtype: str
        """
        return self._kind

    @kind.setter
    def kind(self, kind):
        """Sets the kind of this Role.

        kind of Role, value supports Role and ClusterRole. Role is default.  # noqa: E501

        :param kind: The kind of this Role.
        :type kind: str
        """
        allowed_values = ["Role", "ClusterRole"]  # noqa: E501
        if kind not in allowed_values:
            raise ValueError(
                "Invalid value for `kind` ({0}), must be one of {1}"
                .format(kind, allowed_values)
            )

        self._kind = kind

    @property
    def namespace(self):
        """Gets the namespace of this Role.

        namespace of Role or ClusterRole  # noqa: E501

        :return: The namespace of this Role.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this Role.

        namespace of Role or ClusterRole  # noqa: E501

        :param namespace: The namespace of this Role.
        :type namespace: str
        """

        self._namespace = namespace

    @property
    def labels(self):
        """Gets the labels of this Role.

        Map of string keys and values that can be used to organize and categorize (scope and select) objects  # noqa: E501

        :return: The labels of this Role.
        :rtype: List[str]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this Role.

        Map of string keys and values that can be used to organize and categorize (scope and select) objects  # noqa: E501

        :param labels: The labels of this Role.
        :type labels: List[str]
        """

        self._labels = labels

    @property
    def rules(self):
        """Gets the rules of this Role.


        :return: The rules of this Role.
        :rtype: List[RBACRule]
        """
        return self._rules

    @rules.setter
    def rules(self, rules):
        """Sets the rules of this Role.


        :param rules: The rules of this Role.
        :type rules: List[RBACRule]
        """

        self._rules = rules
