# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class UpdateStrategyRollingUpdateConfig(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, max_surge=None, max_unavailable=None, partition=None):  # noqa: E501
        """UpdateStrategyRollingUpdateConfig - a model defined in OpenAPI

        :param max_surge: The max_surge of this UpdateStrategyRollingUpdateConfig.  # noqa: E501
        :type max_surge: str
        :param max_unavailable: The max_unavailable of this UpdateStrategyRollingUpdateConfig.  # noqa: E501
        :type max_unavailable: str
        :param partition: The partition of this UpdateStrategyRollingUpdateConfig.  # noqa: E501
        :type partition: int
        """
        self.openapi_types = {
            'max_surge': str,
            'max_unavailable': str,
            'partition': int
        }

        self.attribute_map = {
            'max_surge': 'max_surge',
            'max_unavailable': 'max_unavailable',
            'partition': 'partition'
        }

        self._max_surge = max_surge
        self._max_unavailable = max_unavailable
        self._partition = partition

    @classmethod
    def from_dict(cls, dikt) -> 'UpdateStrategyRollingUpdateConfig':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The UpdateStrategy_rolling_update_config of this UpdateStrategyRollingUpdateConfig.  # noqa: E501
        :rtype: UpdateStrategyRollingUpdateConfig
        """
        return util.deserialize_model(dikt, cls)

    @property
    def max_surge(self):
        """Gets the max_surge of this UpdateStrategyRollingUpdateConfig.

        used in Deployment/DaemonSet; The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).  # noqa: E501

        :return: The max_surge of this UpdateStrategyRollingUpdateConfig.
        :rtype: str
        """
        return self._max_surge

    @max_surge.setter
    def max_surge(self, max_surge):
        """Sets the max_surge of this UpdateStrategyRollingUpdateConfig.

        used in Deployment/DaemonSet; The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).  # noqa: E501

        :param max_surge: The max_surge of this UpdateStrategyRollingUpdateConfig.
        :type max_surge: str
        """

        self._max_surge = max_surge

    @property
    def max_unavailable(self):
        """Gets the max_unavailable of this UpdateStrategyRollingUpdateConfig.

        used in Deployment/DaemonSet/StatefulSet; The maximum number of pods that can be unavailable during the update; Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).  # noqa: E501

        :return: The max_unavailable of this UpdateStrategyRollingUpdateConfig.
        :rtype: str
        """
        return self._max_unavailable

    @max_unavailable.setter
    def max_unavailable(self, max_unavailable):
        """Sets the max_unavailable of this UpdateStrategyRollingUpdateConfig.

        used in Deployment/DaemonSet/StatefulSet; The maximum number of pods that can be unavailable during the update; Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).  # noqa: E501

        :param max_unavailable: The max_unavailable of this UpdateStrategyRollingUpdateConfig.
        :type max_unavailable: str
        """

        self._max_unavailable = max_unavailable

    @property
    def partition(self):
        """Gets the partition of this UpdateStrategyRollingUpdateConfig.

        used in StatefulSet; Partition indicates the ordinal at which the Workload should be partitioned for updates. During a rolling update, all pods from ordinal Partition-1 to Replica are updated. All pods from ordinal Partition-1 to 0 remain untouched.   # noqa: E501

        :return: The partition of this UpdateStrategyRollingUpdateConfig.
        :rtype: int
        """
        return self._partition

    @partition.setter
    def partition(self, partition):
        """Sets the partition of this UpdateStrategyRollingUpdateConfig.

        used in StatefulSet; Partition indicates the ordinal at which the Workload should be partitioned for updates. During a rolling update, all pods from ordinal Partition-1 to Replica are updated. All pods from ordinal Partition-1 to 0 remain untouched.   # noqa: E501

        :param partition: The partition of this UpdateStrategyRollingUpdateConfig.
        :type partition: int
        """

        self._partition = partition
