# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class DeployPlatformResource(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, platform=None, pop=None, space=None, cpu_requested=None, cpu_limit=None, cpu_used=None, memory_requested=None, memory_used=None, storage_requested=None, storage_used=None):  # noqa: E501
        """DeployPlatformResource - a model defined in OpenAPI

        :param platform: The platform of this DeployPlatformResource.  # noqa: E501
        :type platform: str
        :param pop: The pop of this DeployPlatformResource.  # noqa: E501
        :type pop: str
        :param space: The space of this DeployPlatformResource.  # noqa: E501
        :type space: str
        :param cpu_requested: The cpu_requested of this DeployPlatformResource.  # noqa: E501
        :type cpu_requested: int
        :param cpu_limit: The cpu_limit of this DeployPlatformResource.  # noqa: E501
        :type cpu_limit: int
        :param cpu_used: The cpu_used of this DeployPlatformResource.  # noqa: E501
        :type cpu_used: int
        :param memory_requested: The memory_requested of this DeployPlatformResource.  # noqa: E501
        :type memory_requested: int
        :param memory_used: The memory_used of this DeployPlatformResource.  # noqa: E501
        :type memory_used: int
        :param storage_requested: The storage_requested of this DeployPlatformResource.  # noqa: E501
        :type storage_requested: int
        :param storage_used: The storage_used of this DeployPlatformResource.  # noqa: E501
        :type storage_used: int
        """
        self.openapi_types = {
            'platform': str,
            'pop': str,
            'space': str,
            'cpu_requested': int,
            'cpu_limit': int,
            'cpu_used': int,
            'memory_requested': int,
            'memory_used': int,
            'storage_requested': int,
            'storage_used': int
        }

        self.attribute_map = {
            'platform': 'platform',
            'pop': 'pop',
            'space': 'space',
            'cpu_requested': 'cpu_requested',
            'cpu_limit': 'cpu_limit',
            'cpu_used': 'cpu_used',
            'memory_requested': 'memory_requested',
            'memory_used': 'memory_used',
            'storage_requested': 'storage_requested',
            'storage_used': 'storage_used'
        }

        self._platform = platform
        self._pop = pop
        self._space = space
        self._cpu_requested = cpu_requested
        self._cpu_limit = cpu_limit
        self._cpu_used = cpu_used
        self._memory_requested = memory_requested
        self._memory_used = memory_used
        self._storage_requested = storage_requested
        self._storage_used = storage_used

    @classmethod
    def from_dict(cls, dikt) -> 'DeployPlatformResource':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The DeployPlatformResource of this DeployPlatformResource.  # noqa: E501
        :rtype: DeployPlatformResource
        """
        return util.deserialize_model(dikt, cls)

    @property
    def platform(self):
        """Gets the platform of this DeployPlatformResource.

        Name of the deploy platform.  # noqa: E501

        :return: The platform of this DeployPlatformResource.
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform):
        """Sets the platform of this DeployPlatformResource.

        Name of the deploy platform.  # noqa: E501

        :param platform: The platform of this DeployPlatformResource.
        :type platform: str
        """

        self._platform = platform

    @property
    def pop(self):
        """Gets the pop of this DeployPlatformResource.

        Name of the pop.  # noqa: E501

        :return: The pop of this DeployPlatformResource.
        :rtype: str
        """
        return self._pop

    @pop.setter
    def pop(self, pop):
        """Sets the pop of this DeployPlatformResource.

        Name of the pop.  # noqa: E501

        :param pop: The pop of this DeployPlatformResource.
        :type pop: str
        """

        self._pop = pop

    @property
    def space(self):
        """Gets the space of this DeployPlatformResource.

        Name of the deploy space.  # noqa: E501

        :return: The space of this DeployPlatformResource.
        :rtype: str
        """
        return self._space

    @space.setter
    def space(self, space):
        """Sets the space of this DeployPlatformResource.

        Name of the deploy space.  # noqa: E501

        :param space: The space of this DeployPlatformResource.
        :type space: str
        """

        self._space = space

    @property
    def cpu_requested(self):
        """Gets the cpu_requested of this DeployPlatformResource.

        The CPU Quota requested for the deploy space. The unit is milicpu, 1 core equals 1000.  # noqa: E501

        :return: The cpu_requested of this DeployPlatformResource.
        :rtype: int
        """
        return self._cpu_requested

    @cpu_requested.setter
    def cpu_requested(self, cpu_requested):
        """Sets the cpu_requested of this DeployPlatformResource.

        The CPU Quota requested for the deploy space. The unit is milicpu, 1 core equals 1000.  # noqa: E501

        :param cpu_requested: The cpu_requested of this DeployPlatformResource.
        :type cpu_requested: int
        """

        self._cpu_requested = cpu_requested

    @property
    def cpu_limit(self):
        """Gets the cpu_limit of this DeployPlatformResource.

        The max possibly CPU that can be utilized by the deploy space. The unit is milicpu, 1 core equals 1000.  # noqa: E501

        :return: The cpu_limit of this DeployPlatformResource.
        :rtype: int
        """
        return self._cpu_limit

    @cpu_limit.setter
    def cpu_limit(self, cpu_limit):
        """Sets the cpu_limit of this DeployPlatformResource.

        The max possibly CPU that can be utilized by the deploy space. The unit is milicpu, 1 core equals 1000.  # noqa: E501

        :param cpu_limit: The cpu_limit of this DeployPlatformResource.
        :type cpu_limit: int
        """

        self._cpu_limit = cpu_limit

    @property
    def cpu_used(self):
        """Gets the cpu_used of this DeployPlatformResource.

        The CPU amount used in the deploy space. The unit is milicpu, 1 core equals 1000.  # noqa: E501

        :return: The cpu_used of this DeployPlatformResource.
        :rtype: int
        """
        return self._cpu_used

    @cpu_used.setter
    def cpu_used(self, cpu_used):
        """Sets the cpu_used of this DeployPlatformResource.

        The CPU amount used in the deploy space. The unit is milicpu, 1 core equals 1000.  # noqa: E501

        :param cpu_used: The cpu_used of this DeployPlatformResource.
        :type cpu_used: int
        """

        self._cpu_used = cpu_used

    @property
    def memory_requested(self):
        """Gets the memory_requested of this DeployPlatformResource.

        The memory Quota requested for the deploy space. The unit is MB.  # noqa: E501

        :return: The memory_requested of this DeployPlatformResource.
        :rtype: int
        """
        return self._memory_requested

    @memory_requested.setter
    def memory_requested(self, memory_requested):
        """Sets the memory_requested of this DeployPlatformResource.

        The memory Quota requested for the deploy space. The unit is MB.  # noqa: E501

        :param memory_requested: The memory_requested of this DeployPlatformResource.
        :type memory_requested: int
        """

        self._memory_requested = memory_requested

    @property
    def memory_used(self):
        """Gets the memory_used of this DeployPlatformResource.

        The memory amount used in the deploy space. The unit is MB.  # noqa: E501

        :return: The memory_used of this DeployPlatformResource.
        :rtype: int
        """
        return self._memory_used

    @memory_used.setter
    def memory_used(self, memory_used):
        """Sets the memory_used of this DeployPlatformResource.

        The memory amount used in the deploy space. The unit is MB.  # noqa: E501

        :param memory_used: The memory_used of this DeployPlatformResource.
        :type memory_used: int
        """

        self._memory_used = memory_used

    @property
    def storage_requested(self):
        """Gets the storage_requested of this DeployPlatformResource.

        The storage Quota requested for the deploy space. The unit is GB.  # noqa: E501

        :return: The storage_requested of this DeployPlatformResource.
        :rtype: int
        """
        return self._storage_requested

    @storage_requested.setter
    def storage_requested(self, storage_requested):
        """Sets the storage_requested of this DeployPlatformResource.

        The storage Quota requested for the deploy space. The unit is GB.  # noqa: E501

        :param storage_requested: The storage_requested of this DeployPlatformResource.
        :type storage_requested: int
        """

        self._storage_requested = storage_requested

    @property
    def storage_used(self):
        """Gets the storage_used of this DeployPlatformResource.

        The storage amount used in the deploy space. The unit is MB.  # noqa: E501

        :return: The storage_used of this DeployPlatformResource.
        :rtype: int
        """
        return self._storage_used

    @storage_used.setter
    def storage_used(self, storage_used):
        """Sets the storage_used of this DeployPlatformResource.

        The storage amount used in the deploy space. The unit is MB.  # noqa: E501

        :param storage_used: The storage_used of this DeployPlatformResource.
        :type storage_used: int
        """

        self._storage_used = storage_used
