# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server.models.relabel_config import RelabelConfig
from openapi_server import util

from openapi_server.models.relabel_config import RelabelConfig  # noqa: E501

class Endpoint(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, honor_labels=None, interval=None, scrape_timeout=None, path=None, scheme=None, target_port=None, params=None, relabelings=None, port=None, honor_timestamps=None, metric_relabelings=None):  # noqa: E501
        """Endpoint - a model defined in OpenAPI

        :param honor_labels: The honor_labels of this Endpoint.  # noqa: E501
        :type honor_labels: bool
        :param interval: The interval of this Endpoint.  # noqa: E501
        :type interval: str
        :param scrape_timeout: The scrape_timeout of this Endpoint.  # noqa: E501
        :type scrape_timeout: str
        :param path: The path of this Endpoint.  # noqa: E501
        :type path: str
        :param scheme: The scheme of this Endpoint.  # noqa: E501
        :type scheme: str
        :param target_port: The target_port of this Endpoint.  # noqa: E501
        :type target_port: int
        :param params: The params of this Endpoint.  # noqa: E501
        :type params: Dict[str, List[str]]
        :param relabelings: The relabelings of this Endpoint.  # noqa: E501
        :type relabelings: List[RelabelConfig]
        :param port: The port of this Endpoint.  # noqa: E501
        :type port: int
        :param honor_timestamps: The honor_timestamps of this Endpoint.  # noqa: E501
        :type honor_timestamps: bool
        :param metric_relabelings: The metric_relabelings of this Endpoint.  # noqa: E501
        :type metric_relabelings: List[RelabelConfig]
        """
        self.openapi_types = {
            'honor_labels': bool,
            'interval': str,
            'scrape_timeout': str,
            'path': str,
            'scheme': str,
            'target_port': int,
            'params': Dict[str, List[str]],
            'relabelings': List[RelabelConfig],
            'port': int,
            'honor_timestamps': bool,
            'metric_relabelings': List[RelabelConfig]
        }

        self.attribute_map = {
            'honor_labels': 'honor_labels',
            'interval': 'interval',
            'scrape_timeout': 'scrape_timeout',
            'path': 'path',
            'scheme': 'scheme',
            'target_port': 'target_port',
            'params': 'params',
            'relabelings': 'relabelings',
            'port': 'port',
            'honor_timestamps': 'honor_timestamps',
            'metric_relabelings': 'metric_relabelings'
        }

        self._honor_labels = honor_labels
        self._interval = interval
        self._scrape_timeout = scrape_timeout
        self._path = path
        self._scheme = scheme
        self._target_port = target_port
        self._params = params
        self._relabelings = relabelings
        self._port = port
        self._honor_timestamps = honor_timestamps
        self._metric_relabelings = metric_relabelings

    @classmethod
    def from_dict(cls, dikt) -> 'Endpoint':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Endpoint of this Endpoint.  # noqa: E501
        :rtype: Endpoint
        """
        return util.deserialize_model(dikt, cls)

    @property
    def honor_labels(self):
        """Gets the honor_labels of this Endpoint.

        honorLabels chooses the metric's labels on collisions with target labels.  # noqa: E501

        :return: The honor_labels of this Endpoint.
        :rtype: bool
        """
        return self._honor_labels

    @honor_labels.setter
    def honor_labels(self, honor_labels):
        """Sets the honor_labels of this Endpoint.

        honorLabels chooses the metric's labels on collisions with target labels.  # noqa: E501

        :param honor_labels: The honor_labels of this Endpoint.
        :type honor_labels: bool
        """

        self._honor_labels = honor_labels

    @property
    def interval(self):
        """Gets the interval of this Endpoint.

        Interval at which metrics should be scraped  # noqa: E501

        :return: The interval of this Endpoint.
        :rtype: str
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """Sets the interval of this Endpoint.

        Interval at which metrics should be scraped  # noqa: E501

        :param interval: The interval of this Endpoint.
        :type interval: str
        """

        self._interval = interval

    @property
    def scrape_timeout(self):
        """Gets the scrape_timeout of this Endpoint.

        Timeout after which the scrape is ended  # noqa: E501

        :return: The scrape_timeout of this Endpoint.
        :rtype: str
        """
        return self._scrape_timeout

    @scrape_timeout.setter
    def scrape_timeout(self, scrape_timeout):
        """Sets the scrape_timeout of this Endpoint.

        Timeout after which the scrape is ended  # noqa: E501

        :param scrape_timeout: The scrape_timeout of this Endpoint.
        :type scrape_timeout: str
        """

        self._scrape_timeout = scrape_timeout

    @property
    def path(self):
        """Gets the path of this Endpoint.

        HTTP path to scrape for metrics.  # noqa: E501

        :return: The path of this Endpoint.
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this Endpoint.

        HTTP path to scrape for metrics.  # noqa: E501

        :param path: The path of this Endpoint.
        :type path: str
        """

        self._path = path

    @property
    def scheme(self):
        """Gets the scheme of this Endpoint.

        HTTP scheme to use for scraping.  # noqa: E501

        :return: The scheme of this Endpoint.
        :rtype: str
        """
        return self._scheme

    @scheme.setter
    def scheme(self, scheme):
        """Sets the scheme of this Endpoint.

        HTTP scheme to use for scraping.  # noqa: E501

        :param scheme: The scheme of this Endpoint.
        :type scheme: str
        """

        self._scheme = scheme

    @property
    def target_port(self):
        """Gets the target_port of this Endpoint.

        Number of the target port of the Pod behind the Service, the port must be specified with container port property. Mutually exclusive with port.  # noqa: E501

        :return: The target_port of this Endpoint.
        :rtype: int
        """
        return self._target_port

    @target_port.setter
    def target_port(self, target_port):
        """Sets the target_port of this Endpoint.

        Number of the target port of the Pod behind the Service, the port must be specified with container port property. Mutually exclusive with port.  # noqa: E501

        :param target_port: The target_port of this Endpoint.
        :type target_port: int
        """

        self._target_port = target_port

    @property
    def params(self):
        """Gets the params of this Endpoint.

        Params is a set of URL parameters to be appended to the scrape URL before scraping.  # noqa: E501

        :return: The params of this Endpoint.
        :rtype: Dict[str, List[str]]
        """
        return self._params

    @params.setter
    def params(self, params):
        """Sets the params of this Endpoint.

        Params is a set of URL parameters to be appended to the scrape URL before scraping.  # noqa: E501

        :param params: The params of this Endpoint.
        :type params: Dict[str, List[str]]
        """

        self._params = params

    @property
    def relabelings(self):
        """Gets the relabelings of this Endpoint.


        :return: The relabelings of this Endpoint.
        :rtype: List[RelabelConfig]
        """
        return self._relabelings

    @relabelings.setter
    def relabelings(self, relabelings):
        """Sets the relabelings of this Endpoint.


        :param relabelings: The relabelings of this Endpoint.
        :type relabelings: List[RelabelConfig]
        """

        self._relabelings = relabelings

    @property
    def port(self):
        """Gets the port of this Endpoint.

        Name of the service port this endpoint refers to. Mutually exclusive with targetPort.  # noqa: E501

        :return: The port of this Endpoint.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this Endpoint.

        Name of the service port this endpoint refers to. Mutually exclusive with targetPort.  # noqa: E501

        :param port: The port of this Endpoint.
        :type port: int
        """

        self._port = port

    @property
    def honor_timestamps(self):
        """Gets the honor_timestamps of this Endpoint.

        honorTimestamps controls whether Prometheus respects the timestamps present in scraped data.  # noqa: E501

        :return: The honor_timestamps of this Endpoint.
        :rtype: bool
        """
        return self._honor_timestamps

    @honor_timestamps.setter
    def honor_timestamps(self, honor_timestamps):
        """Sets the honor_timestamps of this Endpoint.

        honorTimestamps controls whether Prometheus respects the timestamps present in scraped data.  # noqa: E501

        :param honor_timestamps: The honor_timestamps of this Endpoint.
        :type honor_timestamps: bool
        """

        self._honor_timestamps = honor_timestamps

    @property
    def metric_relabelings(self):
        """Gets the metric_relabelings of this Endpoint.


        :return: The metric_relabelings of this Endpoint.
        :rtype: List[RelabelConfig]
        """
        return self._metric_relabelings

    @metric_relabelings.setter
    def metric_relabelings(self, metric_relabelings):
        """Sets the metric_relabelings of this Endpoint.


        :param metric_relabelings: The metric_relabelings of this Endpoint.
        :type metric_relabelings: List[RelabelConfig]
        """

        self._metric_relabelings = metric_relabelings
