# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class PodAffinityTerm(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, label_selector=None, namespaces=None, topology_key=None):  # noqa: E501
        """PodAffinityTerm - a model defined in OpenAPI

        :param label_selector: The label_selector of this PodAffinityTerm.  # noqa: E501
        :type label_selector: List[str]
        :param namespaces: The namespaces of this PodAffinityTerm.  # noqa: E501
        :type namespaces: List[str]
        :param topology_key: The topology_key of this PodAffinityTerm.  # noqa: E501
        :type topology_key: str
        """
        self.openapi_types = {
            'label_selector': List[str],
            'namespaces': List[str],
            'topology_key': str
        }

        self.attribute_map = {
            'label_selector': 'label_selector',
            'namespaces': 'namespaces',
            'topology_key': 'topology_key'
        }

        self._label_selector = label_selector
        self._namespaces = namespaces
        self._topology_key = topology_key

    @classmethod
    def from_dict(cls, dikt) -> 'PodAffinityTerm':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The PodAffinityTerm of this PodAffinityTerm.  # noqa: E501
        :rtype: PodAffinityTerm
        """
        return util.deserialize_model(dikt, cls)

    @property
    def label_selector(self):
        """Gets the label_selector of this PodAffinityTerm.

        An array of label selector rule, the rule can either be a match label or match expression, referring the example (first is a match label, second is a match expression)   # noqa: E501

        :return: The label_selector of this PodAffinityTerm.
        :rtype: List[str]
        """
        return self._label_selector

    @label_selector.setter
    def label_selector(self, label_selector):
        """Sets the label_selector of this PodAffinityTerm.

        An array of label selector rule, the rule can either be a match label or match expression, referring the example (first is a match label, second is a match expression)   # noqa: E501

        :param label_selector: The label_selector of this PodAffinityTerm.
        :type label_selector: List[str]
        """

        self._label_selector = label_selector

    @property
    def namespaces(self):
        """Gets the namespaces of this PodAffinityTerm.


        :return: The namespaces of this PodAffinityTerm.
        :rtype: List[str]
        """
        return self._namespaces

    @namespaces.setter
    def namespaces(self, namespaces):
        """Sets the namespaces of this PodAffinityTerm.


        :param namespaces: The namespaces of this PodAffinityTerm.
        :type namespaces: List[str]
        """

        self._namespaces = namespaces

    @property
    def topology_key(self):
        """Gets the topology_key of this PodAffinityTerm.


        :return: The topology_key of this PodAffinityTerm.
        :rtype: str
        """
        return self._topology_key

    @topology_key.setter
    def topology_key(self, topology_key):
        """Sets the topology_key of this PodAffinityTerm.


        :param topology_key: The topology_key of this PodAffinityTerm.
        :type topology_key: str
        """

        self._topology_key = topology_key
