# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server.models.sysctl import Sysctl
from openapi_server import util

from openapi_server.models.sysctl import Sysctl  # noqa: E501

class PodSecContext(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, run_as_user=None, run_as_group=None, sysctls=None):  # noqa: E501
        """PodSecContext - a model defined in OpenAPI

        :param run_as_user: The run_as_user of this PodSecContext.  # noqa: E501
        :type run_as_user: int
        :param run_as_group: The run_as_group of this PodSecContext.  # noqa: E501
        :type run_as_group: int
        :param sysctls: The sysctls of this PodSecContext.  # noqa: E501
        :type sysctls: List[Sysctl]
        """
        self.openapi_types = {
            'run_as_user': int,
            'run_as_group': int,
            'sysctls': List[Sysctl]
        }

        self.attribute_map = {
            'run_as_user': 'run_as_user',
            'run_as_group': 'run_as_group',
            'sysctls': 'sysctls'
        }

        self._run_as_user = run_as_user
        self._run_as_group = run_as_group
        self._sysctls = sysctls

    @classmethod
    def from_dict(cls, dikt) -> 'PodSecContext':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The PodSecContext of this PodSecContext.  # noqa: E501
        :rtype: PodSecContext
        """
        return util.deserialize_model(dikt, cls)

    @property
    def run_as_user(self):
        """Gets the run_as_user of this PodSecContext.

        The UID to run the entrypoint of the container process.  # noqa: E501

        :return: The run_as_user of this PodSecContext.
        :rtype: int
        """
        return self._run_as_user

    @run_as_user.setter
    def run_as_user(self, run_as_user):
        """Sets the run_as_user of this PodSecContext.

        The UID to run the entrypoint of the container process.  # noqa: E501

        :param run_as_user: The run_as_user of this PodSecContext.
        :type run_as_user: int
        """

        self._run_as_user = run_as_user

    @property
    def run_as_group(self):
        """Gets the run_as_group of this PodSecContext.

        The GID to run the entrypoint of the container process.  # noqa: E501

        :return: The run_as_group of this PodSecContext.
        :rtype: int
        """
        return self._run_as_group

    @run_as_group.setter
    def run_as_group(self, run_as_group):
        """Sets the run_as_group of this PodSecContext.

        The GID to run the entrypoint of the container process.  # noqa: E501

        :param run_as_group: The run_as_group of this PodSecContext.
        :type run_as_group: int
        """

        self._run_as_group = run_as_group

    @property
    def sysctls(self):
        """Gets the sysctls of this PodSecContext.

        Sysctls hold a list of namespaced sysctls used for the pod.  # noqa: E501

        :return: The sysctls of this PodSecContext.
        :rtype: List[Sysctl]
        """
        return self._sysctls

    @sysctls.setter
    def sysctls(self, sysctls):
        """Sets the sysctls of this PodSecContext.

        Sysctls hold a list of namespaced sysctls used for the pod.  # noqa: E501

        :param sysctls: The sysctls of this PodSecContext.
        :type sysctls: List[Sysctl]
        """

        self._sysctls = sysctls
