# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class RBACRoleRef(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, api_group=None, kind=None, name=None):  # noqa: E501
        """RBACRoleRef - a model defined in OpenAPI

        :param api_group: The api_group of this RBACRoleRef.  # noqa: E501
        :type api_group: str
        :param kind: The kind of this RBACRoleRef.  # noqa: E501
        :type kind: str
        :param name: The name of this RBACRoleRef.  # noqa: E501
        :type name: str
        """
        self.openapi_types = {
            'api_group': str,
            'kind': str,
            'name': str
        }

        self.attribute_map = {
            'api_group': 'api_group',
            'kind': 'kind',
            'name': 'name'
        }

        self._api_group = api_group
        self._kind = kind
        self._name = name

    @classmethod
    def from_dict(cls, dikt) -> 'RBACRoleRef':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The RBACRoleRef of this RBACRoleRef.  # noqa: E501
        :rtype: RBACRoleRef
        """
        return util.deserialize_model(dikt, cls)

    @property
    def api_group(self):
        """Gets the api_group of this RBACRoleRef.

        Specifies the API group for the role being referenced.  # noqa: E501

        :return: The api_group of this RBACRoleRef.
        :rtype: str
        """
        return self._api_group

    @api_group.setter
    def api_group(self, api_group):
        """Sets the api_group of this RBACRoleRef.

        Specifies the API group for the role being referenced.  # noqa: E501

        :param api_group: The api_group of this RBACRoleRef.
        :type api_group: str
        """

        self._api_group = api_group

    @property
    def kind(self):
        """Gets the kind of this RBACRoleRef.

        Indicates the type of the referenced role.  # noqa: E501

        :return: The kind of this RBACRoleRef.
        :rtype: str
        """
        return self._kind

    @kind.setter
    def kind(self, kind):
        """Sets the kind of this RBACRoleRef.

        Indicates the type of the referenced role.  # noqa: E501

        :param kind: The kind of this RBACRoleRef.
        :type kind: str
        """

        self._kind = kind

    @property
    def name(self):
        """Gets the name of this RBACRoleRef.

        The name of the role being referenced.  # noqa: E501

        :return: The name of this RBACRoleRef.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this RBACRoleRef.

        The name of the role being referenced.  # noqa: E501

        :param name: The name of this RBACRoleRef.
        :type name: str
        """

        self._name = name
