# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class RefVolumeSource(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, optional=None, default_mode=None):  # noqa: E501
        """RefVolumeSource - a model defined in OpenAPI

        :param name: The name of this RefVolumeSource.  # noqa: E501
        :type name: str
        :param optional: The optional of this RefVolumeSource.  # noqa: E501
        :type optional: bool
        :param default_mode: The default_mode of this RefVolumeSource.  # noqa: E501
        :type default_mode: int
        """
        self.openapi_types = {
            'name': str,
            'optional': bool,
            'default_mode': int
        }

        self.attribute_map = {
            'name': 'name',
            'optional': 'optional',
            'default_mode': 'default_mode'
        }

        self._name = name
        self._optional = optional
        self._default_mode = default_mode

    @classmethod
    def from_dict(cls, dikt) -> 'RefVolumeSource':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The RefVolumeSource of this RefVolumeSource.  # noqa: E501
        :rtype: RefVolumeSource
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this RefVolumeSource.

        volume source (configMap/Secret) name  # noqa: E501

        :return: The name of this RefVolumeSource.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this RefVolumeSource.

        volume source (configMap/Secret) name  # noqa: E501

        :param name: The name of this RefVolumeSource.
        :type name: str
        """

        self._name = name

    @property
    def optional(self):
        """Gets the optional of this RefVolumeSource.

        specify whether the volume source or its keys must be defined  # noqa: E501

        :return: The optional of this RefVolumeSource.
        :rtype: bool
        """
        return self._optional

    @optional.setter
    def optional(self, optional):
        """Sets the optional of this RefVolumeSource.

        specify whether the volume source or its keys must be defined  # noqa: E501

        :param optional: The optional of this RefVolumeSource.
        :type optional: bool
        """

        self._optional = optional

    @property
    def default_mode(self):
        """Gets the default_mode of this RefVolumeSource.

        mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511   # noqa: E501

        :return: The default_mode of this RefVolumeSource.
        :rtype: int
        """
        return self._default_mode

    @default_mode.setter
    def default_mode(self, default_mode):
        """Sets the default_mode of this RefVolumeSource.

        mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511   # noqa: E501

        :param default_mode: The default_mode of this RefVolumeSource.
        :type default_mode: int
        """

        self._default_mode = default_mode
