# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server.models.update_strategy_rolling_update_config import UpdateStrategyRollingUpdateConfig
from openapi_server import util

from openapi_server.models.update_strategy_rolling_update_config import UpdateStrategyRollingUpdateConfig  # noqa: E501

class UpdateStrategy(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, strategy_type=None, rolling_update_config=None):  # noqa: E501
        """UpdateStrategy - a model defined in OpenAPI

        :param strategy_type: The strategy_type of this UpdateStrategy.  # noqa: E501
        :type strategy_type: str
        :param rolling_update_config: The rolling_update_config of this UpdateStrategy.  # noqa: E501
        :type rolling_update_config: UpdateStrategyRollingUpdateConfig
        """
        self.openapi_types = {
            'strategy_type': str,
            'rolling_update_config': UpdateStrategyRollingUpdateConfig
        }

        self.attribute_map = {
            'strategy_type': 'strategy_type',
            'rolling_update_config': 'rolling_update_config'
        }

        self._strategy_type = strategy_type
        self._rolling_update_config = rolling_update_config

    @classmethod
    def from_dict(cls, dikt) -> 'UpdateStrategy':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The UpdateStrategy of this UpdateStrategy.  # noqa: E501
        :rtype: UpdateStrategy
        """
        return util.deserialize_model(dikt, cls)

    @property
    def strategy_type(self):
        """Gets the strategy_type of this UpdateStrategy.

        Update strategy type， used to specify the update strategy for the Workload.  # noqa: E501

        :return: The strategy_type of this UpdateStrategy.
        :rtype: str
        """
        return self._strategy_type

    @strategy_type.setter
    def strategy_type(self, strategy_type):
        """Sets the strategy_type of this UpdateStrategy.

        Update strategy type， used to specify the update strategy for the Workload.  # noqa: E501

        :param strategy_type: The strategy_type of this UpdateStrategy.
        :type strategy_type: str
        """
        allowed_values = ["Recreate", "RollingUpdate", "OnDelete"]  # noqa: E501
        if strategy_type not in allowed_values:
            raise ValueError(
                "Invalid value for `strategy_type` ({0}), must be one of {1}"
                .format(strategy_type, allowed_values)
            )

        self._strategy_type = strategy_type

    @property
    def rolling_update_config(self):
        """Gets the rolling_update_config of this UpdateStrategy.


        :return: The rolling_update_config of this UpdateStrategy.
        :rtype: UpdateStrategyRollingUpdateConfig
        """
        return self._rolling_update_config

    @rolling_update_config.setter
    def rolling_update_config(self, rolling_update_config):
        """Sets the rolling_update_config of this UpdateStrategy.


        :param rolling_update_config: The rolling_update_config of this UpdateStrategy.
        :type rolling_update_config: UpdateStrategyRollingUpdateConfig
        """

        self._rolling_update_config = rolling_update_config
