# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server.models.ref_volume_source import RefVolumeSource
from openapi_server.models.volume_empty_dir import VolumeEmptyDir
from openapi_server.models.volume_host_path import VolumeHostPath
from openapi_server.models.volume_persistent_volume_claim import VolumePersistentVolumeClaim
from openapi_server import util

from openapi_server.models.ref_volume_source import RefVolumeSource  # noqa: E501
from openapi_server.models.volume_empty_dir import VolumeEmptyDir  # noqa: E501
from openapi_server.models.volume_host_path import VolumeHostPath  # noqa: E501
from openapi_server.models.volume_persistent_volume_claim import VolumePersistentVolumeClaim  # noqa: E501

class Volume(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, config_map=None, secret=None, persistent_volume_claim=None, empty_dir=None, host_path=None):  # noqa: E501
        """Volume - a model defined in OpenAPI

        :param name: The name of this Volume.  # noqa: E501
        :type name: str
        :param config_map: The config_map of this Volume.  # noqa: E501
        :type config_map: RefVolumeSource
        :param secret: The secret of this Volume.  # noqa: E501
        :type secret: RefVolumeSource
        :param persistent_volume_claim: The persistent_volume_claim of this Volume.  # noqa: E501
        :type persistent_volume_claim: VolumePersistentVolumeClaim
        :param empty_dir: The empty_dir of this Volume.  # noqa: E501
        :type empty_dir: VolumeEmptyDir
        :param host_path: The host_path of this Volume.  # noqa: E501
        :type host_path: VolumeHostPath
        """
        self.openapi_types = {
            'name': str,
            'config_map': RefVolumeSource,
            'secret': RefVolumeSource,
            'persistent_volume_claim': VolumePersistentVolumeClaim,
            'empty_dir': VolumeEmptyDir,
            'host_path': VolumeHostPath
        }

        self.attribute_map = {
            'name': 'name',
            'config_map': 'config_map',
            'secret': 'secret',
            'persistent_volume_claim': 'persistent_volume_claim',
            'empty_dir': 'empty_dir',
            'host_path': 'host_path'
        }

        self._name = name
        self._config_map = config_map
        self._secret = secret
        self._persistent_volume_claim = persistent_volume_claim
        self._empty_dir = empty_dir
        self._host_path = host_path

    @classmethod
    def from_dict(cls, dikt) -> 'Volume':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Volume of this Volume.  # noqa: E501
        :rtype: Volume
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this Volume.

        Name of the volume. Must be a DNS_LABEL and unique within the pod  # noqa: E501

        :return: The name of this Volume.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Volume.

        Name of the volume. Must be a DNS_LABEL and unique within the pod  # noqa: E501

        :param name: The name of this Volume.
        :type name: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def config_map(self):
        """Gets the config_map of this Volume.


        :return: The config_map of this Volume.
        :rtype: RefVolumeSource
        """
        return self._config_map

    @config_map.setter
    def config_map(self, config_map):
        """Sets the config_map of this Volume.


        :param config_map: The config_map of this Volume.
        :type config_map: RefVolumeSource
        """

        self._config_map = config_map

    @property
    def secret(self):
        """Gets the secret of this Volume.


        :return: The secret of this Volume.
        :rtype: RefVolumeSource
        """
        return self._secret

    @secret.setter
    def secret(self, secret):
        """Sets the secret of this Volume.


        :param secret: The secret of this Volume.
        :type secret: RefVolumeSource
        """

        self._secret = secret

    @property
    def persistent_volume_claim(self):
        """Gets the persistent_volume_claim of this Volume.


        :return: The persistent_volume_claim of this Volume.
        :rtype: VolumePersistentVolumeClaim
        """
        return self._persistent_volume_claim

    @persistent_volume_claim.setter
    def persistent_volume_claim(self, persistent_volume_claim):
        """Sets the persistent_volume_claim of this Volume.


        :param persistent_volume_claim: The persistent_volume_claim of this Volume.
        :type persistent_volume_claim: VolumePersistentVolumeClaim
        """

        self._persistent_volume_claim = persistent_volume_claim

    @property
    def empty_dir(self):
        """Gets the empty_dir of this Volume.


        :return: The empty_dir of this Volume.
        :rtype: VolumeEmptyDir
        """
        return self._empty_dir

    @empty_dir.setter
    def empty_dir(self, empty_dir):
        """Sets the empty_dir of this Volume.


        :param empty_dir: The empty_dir of this Volume.
        :type empty_dir: VolumeEmptyDir
        """

        self._empty_dir = empty_dir

    @property
    def host_path(self):
        """Gets the host_path of this Volume.


        :return: The host_path of this Volume.
        :rtype: VolumeHostPath
        """
        return self._host_path

    @host_path.setter
    def host_path(self, host_path):
        """Sets the host_path of this Volume.


        :param host_path: The host_path of this Volume.
        :type host_path: VolumeHostPath
        """

        self._host_path = host_path
