# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class VolumeMount(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, path=None, sub_path=None, read_only=None):  # noqa: E501
        """VolumeMount - a model defined in OpenAPI

        :param name: The name of this VolumeMount.  # noqa: E501
        :type name: object
        :param path: The path of this VolumeMount.  # noqa: E501
        :type path: str
        :param sub_path: The sub_path of this VolumeMount.  # noqa: E501
        :type sub_path: str
        :param read_only: The read_only of this VolumeMount.  # noqa: E501
        :type read_only: bool
        """
        self.openapi_types = {
            'name': object,
            'path': str,
            'sub_path': str,
            'read_only': bool
        }

        self.attribute_map = {
            'name': 'name',
            'path': 'path',
            'sub_path': 'sub_path',
            'read_only': 'read_only'
        }

        self._name = name
        self._path = path
        self._sub_path = sub_path
        self._read_only = read_only

    @classmethod
    def from_dict(cls, dikt) -> 'VolumeMount':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The VolumeMount of this VolumeMount.  # noqa: E501
        :rtype: VolumeMount
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this VolumeMount.

        Must match the Name of a Volume  # noqa: E501

        :return: The name of this VolumeMount.
        :rtype: object
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VolumeMount.

        Must match the Name of a Volume  # noqa: E501

        :param name: The name of this VolumeMount.
        :type name: object
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def path(self):
        """Gets the path of this VolumeMount.

        Path within the container at which the volume should be mounted  # noqa: E501

        :return: The path of this VolumeMount.
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this VolumeMount.

        Path within the container at which the volume should be mounted  # noqa: E501

        :param path: The path of this VolumeMount.
        :type path: str
        """

        self._path = path

    @property
    def sub_path(self):
        """Gets the sub_path of this VolumeMount.

        Path within the volume from which the container's volume should be mounted  # noqa: E501

        :return: The sub_path of this VolumeMount.
        :rtype: str
        """
        return self._sub_path

    @sub_path.setter
    def sub_path(self, sub_path):
        """Sets the sub_path of this VolumeMount.

        Path within the volume from which the container's volume should be mounted  # noqa: E501

        :param sub_path: The sub_path of this VolumeMount.
        :type sub_path: str
        """

        self._sub_path = sub_path

    @property
    def read_only(self):
        """Gets the read_only of this VolumeMount.

        Will force the ReadOnly setting in VolumeMounts  # noqa: E501

        :return: The read_only of this VolumeMount.
        :rtype: bool
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """Sets the read_only of this VolumeMount.

        Will force the ReadOnly setting in VolumeMounts  # noqa: E501

        :param read_only: The read_only of this VolumeMount.
        :type read_only: bool
        """

        self._read_only = read_only
