# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server.models.persistent_volume_claim import PersistentVolumeClaim
from openapi_server.models.pod import Pod
from openapi_server.models.update_strategy import UpdateStrategy
from openapi_server import util

from openapi_server.models.persistent_volume_claim import PersistentVolumeClaim  # noqa: E501
from openapi_server.models.pod import Pod  # noqa: E501
from openapi_server.models.update_strategy import UpdateStrategy  # noqa: E501

class Workload(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, workload_type=None, namespace=None, annotations=None, labels=None, replicas=None, label_selector=None, update_strategy=None, revision_history_limit=None, pod=None, service_name=None, volume_claim_templates=None):  # noqa: E501
        """Workload - a model defined in OpenAPI

        :param name: The name of this Workload.  # noqa: E501
        :type name: str
        :param workload_type: The workload_type of this Workload.  # noqa: E501
        :type workload_type: str
        :param namespace: The namespace of this Workload.  # noqa: E501
        :type namespace: str
        :param annotations: The annotations of this Workload.  # noqa: E501
        :type annotations: List[str]
        :param labels: The labels of this Workload.  # noqa: E501
        :type labels: List[str]
        :param replicas: The replicas of this Workload.  # noqa: E501
        :type replicas: int
        :param label_selector: The label_selector of this Workload.  # noqa: E501
        :type label_selector: List[str]
        :param update_strategy: The update_strategy of this Workload.  # noqa: E501
        :type update_strategy: UpdateStrategy
        :param revision_history_limit: The revision_history_limit of this Workload.  # noqa: E501
        :type revision_history_limit: int
        :param pod: The pod of this Workload.  # noqa: E501
        :type pod: Pod
        :param service_name: The service_name of this Workload.  # noqa: E501
        :type service_name: str
        :param volume_claim_templates: The volume_claim_templates of this Workload.  # noqa: E501
        :type volume_claim_templates: List[PersistentVolumeClaim]
        """
        self.openapi_types = {
            'name': str,
            'workload_type': str,
            'namespace': str,
            'annotations': List[str],
            'labels': List[str],
            'replicas': int,
            'label_selector': List[str],
            'update_strategy': UpdateStrategy,
            'revision_history_limit': int,
            'pod': Pod,
            'service_name': str,
            'volume_claim_templates': List[PersistentVolumeClaim]
        }

        self.attribute_map = {
            'name': 'name',
            'workload_type': 'workload_type',
            'namespace': 'namespace',
            'annotations': 'annotations',
            'labels': 'labels',
            'replicas': 'replicas',
            'label_selector': 'label_selector',
            'update_strategy': 'update_strategy',
            'revision_history_limit': 'revision_history_limit',
            'pod': 'pod',
            'service_name': 'service_name',
            'volume_claim_templates': 'volume_claim_templates'
        }

        self._name = name
        self._workload_type = workload_type
        self._namespace = namespace
        self._annotations = annotations
        self._labels = labels
        self._replicas = replicas
        self._label_selector = label_selector
        self._update_strategy = update_strategy
        self._revision_history_limit = revision_history_limit
        self._pod = pod
        self._service_name = service_name
        self._volume_claim_templates = volume_claim_templates

    @classmethod
    def from_dict(cls, dikt) -> 'Workload':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Workload of this Workload.  # noqa: E501
        :rtype: Workload
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this Workload.

        workload name.  # noqa: E501

        :return: The name of this Workload.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Workload.

        workload name.  # noqa: E501

        :param name: The name of this Workload.
        :type name: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def workload_type(self):
        """Gets the workload_type of this Workload.


        :return: The workload_type of this Workload.
        :rtype: str
        """
        return self._workload_type

    @workload_type.setter
    def workload_type(self, workload_type):
        """Sets the workload_type of this Workload.


        :param workload_type: The workload_type of this Workload.
        :type workload_type: str
        """
        allowed_values = ["Deployment", "StatefulSet", "DaemonSet", "Job"]  # noqa: E501
        if workload_type not in allowed_values:
            raise ValueError(
                "Invalid value for `workload_type` ({0}), must be one of {1}"
                .format(workload_type, allowed_values)
            )

        self._workload_type = workload_type

    @property
    def namespace(self):
        """Gets the namespace of this Workload.

        namespace for resource.  # noqa: E501

        :return: The namespace of this Workload.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this Workload.

        namespace for resource.  # noqa: E501

        :param namespace: The namespace of this Workload.
        :type namespace: str
        """

        self._namespace = namespace

    @property
    def annotations(self):
        """Gets the annotations of this Workload.

        An unstructured key value map that can be used to attach arbitrary metadata  # noqa: E501

        :return: The annotations of this Workload.
        :rtype: List[str]
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations):
        """Sets the annotations of this Workload.

        An unstructured key value map that can be used to attach arbitrary metadata  # noqa: E501

        :param annotations: The annotations of this Workload.
        :type annotations: List[str]
        """

        self._annotations = annotations

    @property
    def labels(self):
        """Gets the labels of this Workload.

        Map of string keys and values that can be used to organize and categorize (scope and select) objects  # noqa: E501

        :return: The labels of this Workload.
        :rtype: List[str]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this Workload.

        Map of string keys and values that can be used to organize and categorize (scope and select) objects  # noqa: E501

        :param labels: The labels of this Workload.
        :type labels: List[str]
        """

        self._labels = labels

    @property
    def replicas(self):
        """Gets the replicas of this Workload.


        :return: The replicas of this Workload.
        :rtype: int
        """
        return self._replicas

    @replicas.setter
    def replicas(self, replicas):
        """Sets the replicas of this Workload.


        :param replicas: The replicas of this Workload.
        :type replicas: int
        """

        self._replicas = replicas

    @property
    def label_selector(self):
        """Gets the label_selector of this Workload.

        An array of label selector rule, the rule can either be a match label or match expression, referring the example (first is a match label, second is a match expression)   # noqa: E501

        :return: The label_selector of this Workload.
        :rtype: List[str]
        """
        return self._label_selector

    @label_selector.setter
    def label_selector(self, label_selector):
        """Sets the label_selector of this Workload.

        An array of label selector rule, the rule can either be a match label or match expression, referring the example (first is a match label, second is a match expression)   # noqa: E501

        :param label_selector: The label_selector of this Workload.
        :type label_selector: List[str]
        """

        self._label_selector = label_selector

    @property
    def update_strategy(self):
        """Gets the update_strategy of this Workload.


        :return: The update_strategy of this Workload.
        :rtype: UpdateStrategy
        """
        return self._update_strategy

    @update_strategy.setter
    def update_strategy(self, update_strategy):
        """Sets the update_strategy of this Workload.


        :param update_strategy: The update_strategy of this Workload.
        :type update_strategy: UpdateStrategy
        """

        self._update_strategy = update_strategy

    @property
    def revision_history_limit(self):
        """Gets the revision_history_limit of this Workload.

        It determines the number of old ReplicaSets to retain for the purpose of rollback and historical analysis.  # noqa: E501

        :return: The revision_history_limit of this Workload.
        :rtype: int
        """
        return self._revision_history_limit

    @revision_history_limit.setter
    def revision_history_limit(self, revision_history_limit):
        """Sets the revision_history_limit of this Workload.

        It determines the number of old ReplicaSets to retain for the purpose of rollback and historical analysis.  # noqa: E501

        :param revision_history_limit: The revision_history_limit of this Workload.
        :type revision_history_limit: int
        """

        self._revision_history_limit = revision_history_limit

    @property
    def pod(self):
        """Gets the pod of this Workload.


        :return: The pod of this Workload.
        :rtype: Pod
        """
        return self._pod

    @pod.setter
    def pod(self, pod):
        """Sets the pod of this Workload.


        :param pod: The pod of this Workload.
        :type pod: Pod
        """

        self._pod = pod

    @property
    def service_name(self):
        """Gets the service_name of this Workload.

        It is used for StatefulSet. The name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where \"pod-specific-string\" is managed by the StatefulSet controller.  If not specified, the name of the StatefulSet will be used.   # noqa: E501

        :return: The service_name of this Workload.
        :rtype: str
        """
        return self._service_name

    @service_name.setter
    def service_name(self, service_name):
        """Sets the service_name of this Workload.

        It is used for StatefulSet. The name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where \"pod-specific-string\" is managed by the StatefulSet controller.  If not specified, the name of the StatefulSet will be used.   # noqa: E501

        :param service_name: The service_name of this Workload.
        :type service_name: str
        """

        self._service_name = service_name

    @property
    def volume_claim_templates(self):
        """Gets the volume_claim_templates of this Workload.

        volumeClaimTemplates is a list of claims that pods are allowed to reference, only valid when workload_type is StatefulSet.  # noqa: E501

        :return: The volume_claim_templates of this Workload.
        :rtype: List[PersistentVolumeClaim]
        """
        return self._volume_claim_templates

    @volume_claim_templates.setter
    def volume_claim_templates(self, volume_claim_templates):
        """Sets the volume_claim_templates of this Workload.

        volumeClaimTemplates is a list of claims that pods are allowed to reference, only valid when workload_type is StatefulSet.  # noqa: E501

        :param volume_claim_templates: The volume_claim_templates of this Workload.
        :type volume_claim_templates: List[PersistentVolumeClaim]
        """

        self._volume_claim_templates = volume_claim_templates
