# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class HttpGet(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, port=None, host=None, http_headers=None, path=None, scheme=None):  # noqa: E501
        """HttpGet - a model defined in OpenAPI

        :param port: The port of this HttpGet.  # noqa: E501
        :type port: int
        :param host: The host of this HttpGet.  # noqa: E501
        :type host: str
        :param http_headers: The http_headers of this HttpGet.  # noqa: E501
        :type http_headers: List[str]
        :param path: The path of this HttpGet.  # noqa: E501
        :type path: str
        :param scheme: The scheme of this HttpGet.  # noqa: E501
        :type scheme: str
        """
        self.openapi_types = {
            'port': int,
            'host': str,
            'http_headers': List[str],
            'path': str,
            'scheme': str
        }

        self.attribute_map = {
            'port': 'port',
            'host': 'host',
            'http_headers': 'http_headers',
            'path': 'path',
            'scheme': 'scheme'
        }

        self._port = port
        self._host = host
        self._http_headers = http_headers
        self._path = path
        self._scheme = scheme

    @classmethod
    def from_dict(cls, dikt) -> 'HttpGet':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The HttpGet of this HttpGet.  # noqa: E501
        :rtype: HttpGet
        """
        return util.deserialize_model(dikt, cls)

    @property
    def port(self):
        """Gets the port of this HttpGet.

        Number of the port to access on the container.  # noqa: E501

        :return: The port of this HttpGet.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this HttpGet.

        Number of the port to access on the container.  # noqa: E501

        :param port: The port of this HttpGet.
        :type port: int
        """
        if port is None:
            raise ValueError("Invalid value for `port`, must not be `None`")  # noqa: E501

        self._port = port

    @property
    def host(self):
        """Gets the host of this HttpGet.

        Host name to connect to, defaults to the pod IP.  # noqa: E501

        :return: The host of this HttpGet.
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this HttpGet.

        Host name to connect to, defaults to the pod IP.  # noqa: E501

        :param host: The host of this HttpGet.
        :type host: str
        """

        self._host = host

    @property
    def http_headers(self):
        """Gets the http_headers of this HttpGet.

        Custom headers to set in the request.  # noqa: E501

        :return: The http_headers of this HttpGet.
        :rtype: List[str]
        """
        return self._http_headers

    @http_headers.setter
    def http_headers(self, http_headers):
        """Sets the http_headers of this HttpGet.

        Custom headers to set in the request.  # noqa: E501

        :param http_headers: The http_headers of this HttpGet.
        :type http_headers: List[str]
        """

        self._http_headers = http_headers

    @property
    def path(self):
        """Gets the path of this HttpGet.

        Path to access on the HTTP server.  # noqa: E501

        :return: The path of this HttpGet.
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this HttpGet.

        Path to access on the HTTP server.  # noqa: E501

        :param path: The path of this HttpGet.
        :type path: str
        """

        self._path = path

    @property
    def scheme(self):
        """Gets the scheme of this HttpGet.

        Scheme to use for connecting to the host. Defaults to HTTP.  # noqa: E501

        :return: The scheme of this HttpGet.
        :rtype: str
        """
        return self._scheme

    @scheme.setter
    def scheme(self, scheme):
        """Sets the scheme of this HttpGet.

        Scheme to use for connecting to the host. Defaults to HTTP.  # noqa: E501

        :param scheme: The scheme of this HttpGet.
        :type scheme: str
        """

        self._scheme = scheme
