# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server.models.container_life_cycle import ContainerLifeCycle
from openapi_server.models.container_port import ContainerPort
from openapi_server.models.container_sec_context import ContainerSecContext
from openapi_server.models.env_from_source import EnvFromSource
from openapi_server.models.env_var import EnvVar
from openapi_server.models.probe import Probe
from openapi_server.models.resource_requirements import ResourceRequirements
from openapi_server.models.volume_device import VolumeDevice
from openapi_server.models.volume_mount import VolumeMount
from openapi_server import util

from openapi_server.models.container_life_cycle import ContainerLifeCycle  # noqa: E501
from openapi_server.models.container_port import ContainerPort  # noqa: E501
from openapi_server.models.container_sec_context import ContainerSecContext  # noqa: E501
from openapi_server.models.env_from_source import EnvFromSource  # noqa: E501
from openapi_server.models.env_var import EnvVar  # noqa: E501
from openapi_server.models.probe import Probe  # noqa: E501
from openapi_server.models.resource_requirements import ResourceRequirements  # noqa: E501
from openapi_server.models.volume_device import VolumeDevice  # noqa: E501
from openapi_server.models.volume_mount import VolumeMount  # noqa: E501

class Container(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, container_type=None, env=None, env_from=None, image=None, image_pull_policy=None, args=None, command=None, security_context=None, life_cycle=None, ports=None, volume_mounts=None, volume_devices=None, resources=None, liveness_probe=None, readiness_probe=None, startup_probe=None):  # noqa: E501
        """Container - a model defined in OpenAPI

        :param name: The name of this Container.  # noqa: E501
        :type name: str
        :param container_type: The container_type of this Container.  # noqa: E501
        :type container_type: str
        :param env: The env of this Container.  # noqa: E501
        :type env: List[EnvVar]
        :param env_from: The env_from of this Container.  # noqa: E501
        :type env_from: List[EnvFromSource]
        :param image: The image of this Container.  # noqa: E501
        :type image: str
        :param image_pull_policy: The image_pull_policy of this Container.  # noqa: E501
        :type image_pull_policy: str
        :param args: The args of this Container.  # noqa: E501
        :type args: List[str]
        :param command: The command of this Container.  # noqa: E501
        :type command: List[str]
        :param security_context: The security_context of this Container.  # noqa: E501
        :type security_context: ContainerSecContext
        :param life_cycle: The life_cycle of this Container.  # noqa: E501
        :type life_cycle: ContainerLifeCycle
        :param ports: The ports of this Container.  # noqa: E501
        :type ports: List[ContainerPort]
        :param volume_mounts: The volume_mounts of this Container.  # noqa: E501
        :type volume_mounts: List[VolumeMount]
        :param volume_devices: The volume_devices of this Container.  # noqa: E501
        :type volume_devices: List[VolumeDevice]
        :param resources: The resources of this Container.  # noqa: E501
        :type resources: ResourceRequirements
        :param liveness_probe: The liveness_probe of this Container.  # noqa: E501
        :type liveness_probe: Probe
        :param readiness_probe: The readiness_probe of this Container.  # noqa: E501
        :type readiness_probe: Probe
        :param startup_probe: The startup_probe of this Container.  # noqa: E501
        :type startup_probe: Probe
        """
        self.openapi_types = {
            'name': str,
            'container_type': str,
            'env': List[EnvVar],
            'env_from': List[EnvFromSource],
            'image': str,
            'image_pull_policy': str,
            'args': List[str],
            'command': List[str],
            'security_context': ContainerSecContext,
            'life_cycle': ContainerLifeCycle,
            'ports': List[ContainerPort],
            'volume_mounts': List[VolumeMount],
            'volume_devices': List[VolumeDevice],
            'resources': ResourceRequirements,
            'liveness_probe': Probe,
            'readiness_probe': Probe,
            'startup_probe': Probe
        }

        self.attribute_map = {
            'name': 'name',
            'container_type': 'container_type',
            'env': 'env',
            'env_from': 'env_from',
            'image': 'image',
            'image_pull_policy': 'image_pull_policy',
            'args': 'args',
            'command': 'command',
            'security_context': 'security_context',
            'life_cycle': 'life_cycle',
            'ports': 'ports',
            'volume_mounts': 'volume_mounts',
            'volume_devices': 'volume_devices',
            'resources': 'resources',
            'liveness_probe': 'liveness_probe',
            'readiness_probe': 'readiness_probe',
            'startup_probe': 'startup_probe'
        }

        self._name = name
        self._container_type = container_type
        self._env = env
        self._env_from = env_from
        self._image = image
        self._image_pull_policy = image_pull_policy
        self._args = args
        self._command = command
        self._security_context = security_context
        self._life_cycle = life_cycle
        self._ports = ports
        self._volume_mounts = volume_mounts
        self._volume_devices = volume_devices
        self._resources = resources
        self._liveness_probe = liveness_probe
        self._readiness_probe = readiness_probe
        self._startup_probe = startup_probe

    @classmethod
    def from_dict(cls, dikt) -> 'Container':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Container of this Container.  # noqa: E501
        :rtype: Container
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this Container.

        Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated   # noqa: E501

        :return: The name of this Container.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Container.

        Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated   # noqa: E501

        :param name: The name of this Container.
        :type name: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def container_type(self):
        """Gets the container_type of this Container.


        :return: The container_type of this Container.
        :rtype: str
        """
        return self._container_type

    @container_type.setter
    def container_type(self, container_type):
        """Sets the container_type of this Container.


        :param container_type: The container_type of this Container.
        :type container_type: str
        """
        allowed_values = ["Init", "Regular"]  # noqa: E501
        if container_type not in allowed_values:
            raise ValueError(
                "Invalid value for `container_type` ({0}), must be one of {1}"
                .format(container_type, allowed_values)
            )

        self._container_type = container_type

    @property
    def env(self):
        """Gets the env of this Container.

        List of environment variables to set in the container.  # noqa: E501

        :return: The env of this Container.
        :rtype: List[EnvVar]
        """
        return self._env

    @env.setter
    def env(self, env):
        """Sets the env of this Container.

        List of environment variables to set in the container.  # noqa: E501

        :param env: The env of this Container.
        :type env: List[EnvVar]
        """

        self._env = env

    @property
    def env_from(self):
        """Gets the env_from of this Container.

        List of sources to populate environment variables in the container.  # noqa: E501

        :return: The env_from of this Container.
        :rtype: List[EnvFromSource]
        """
        return self._env_from

    @env_from.setter
    def env_from(self, env_from):
        """Sets the env_from of this Container.

        List of sources to populate environment variables in the container.  # noqa: E501

        :param env_from: The env_from of this Container.
        :type env_from: List[EnvFromSource]
        """

        self._env_from = env_from

    @property
    def image(self):
        """Gets the image of this Container.

        Docker image url  # noqa: E501

        :return: The image of this Container.
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this Container.

        Docker image url  # noqa: E501

        :param image: The image of this Container.
        :type image: str
        """

        self._image = image

    @property
    def image_pull_policy(self):
        """Gets the image_pull_policy of this Container.

        Defaults to Always  # noqa: E501

        :return: The image_pull_policy of this Container.
        :rtype: str
        """
        return self._image_pull_policy

    @image_pull_policy.setter
    def image_pull_policy(self, image_pull_policy):
        """Sets the image_pull_policy of this Container.

        Defaults to Always  # noqa: E501

        :param image_pull_policy: The image_pull_policy of this Container.
        :type image_pull_policy: str
        """
        allowed_values = ["IfNotPresent", "Always", "Never"]  # noqa: E501
        if image_pull_policy not in allowed_values:
            raise ValueError(
                "Invalid value for `image_pull_policy` ({0}), must be one of {1}"
                .format(image_pull_policy, allowed_values)
            )

        self._image_pull_policy = image_pull_policy

    @property
    def args(self):
        """Gets the args of this Container.

        Arguments to the entrypoint. The container image's CMD is used if this is not provided  # noqa: E501

        :return: The args of this Container.
        :rtype: List[str]
        """
        return self._args

    @args.setter
    def args(self, args):
        """Sets the args of this Container.

        Arguments to the entrypoint. The container image's CMD is used if this is not provided  # noqa: E501

        :param args: The args of this Container.
        :type args: List[str]
        """

        self._args = args

    @property
    def command(self):
        """Gets the command of this Container.

        Entrypoint array. Not executed within a shell. The container image's ENTRYPOINT is used if this is not provided.   # noqa: E501

        :return: The command of this Container.
        :rtype: List[str]
        """
        return self._command

    @command.setter
    def command(self, command):
        """Sets the command of this Container.

        Entrypoint array. Not executed within a shell. The container image's ENTRYPOINT is used if this is not provided.   # noqa: E501

        :param command: The command of this Container.
        :type command: List[str]
        """

        self._command = command

    @property
    def security_context(self):
        """Gets the security_context of this Container.


        :return: The security_context of this Container.
        :rtype: ContainerSecContext
        """
        return self._security_context

    @security_context.setter
    def security_context(self, security_context):
        """Sets the security_context of this Container.


        :param security_context: The security_context of this Container.
        :type security_context: ContainerSecContext
        """

        self._security_context = security_context

    @property
    def life_cycle(self):
        """Gets the life_cycle of this Container.


        :return: The life_cycle of this Container.
        :rtype: ContainerLifeCycle
        """
        return self._life_cycle

    @life_cycle.setter
    def life_cycle(self, life_cycle):
        """Sets the life_cycle of this Container.


        :param life_cycle: The life_cycle of this Container.
        :type life_cycle: ContainerLifeCycle
        """

        self._life_cycle = life_cycle

    @property
    def ports(self):
        """Gets the ports of this Container.


        :return: The ports of this Container.
        :rtype: List[ContainerPort]
        """
        return self._ports

    @ports.setter
    def ports(self, ports):
        """Sets the ports of this Container.


        :param ports: The ports of this Container.
        :type ports: List[ContainerPort]
        """

        self._ports = ports

    @property
    def volume_mounts(self):
        """Gets the volume_mounts of this Container.


        :return: The volume_mounts of this Container.
        :rtype: List[VolumeMount]
        """
        return self._volume_mounts

    @volume_mounts.setter
    def volume_mounts(self, volume_mounts):
        """Sets the volume_mounts of this Container.


        :param volume_mounts: The volume_mounts of this Container.
        :type volume_mounts: List[VolumeMount]
        """

        self._volume_mounts = volume_mounts

    @property
    def volume_devices(self):
        """Gets the volume_devices of this Container.


        :return: The volume_devices of this Container.
        :rtype: List[VolumeDevice]
        """
        return self._volume_devices

    @volume_devices.setter
    def volume_devices(self, volume_devices):
        """Sets the volume_devices of this Container.


        :param volume_devices: The volume_devices of this Container.
        :type volume_devices: List[VolumeDevice]
        """

        self._volume_devices = volume_devices

    @property
    def resources(self):
        """Gets the resources of this Container.


        :return: The resources of this Container.
        :rtype: ResourceRequirements
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """Sets the resources of this Container.


        :param resources: The resources of this Container.
        :type resources: ResourceRequirements
        """

        self._resources = resources

    @property
    def liveness_probe(self):
        """Gets the liveness_probe of this Container.


        :return: The liveness_probe of this Container.
        :rtype: Probe
        """
        return self._liveness_probe

    @liveness_probe.setter
    def liveness_probe(self, liveness_probe):
        """Sets the liveness_probe of this Container.


        :param liveness_probe: The liveness_probe of this Container.
        :type liveness_probe: Probe
        """

        self._liveness_probe = liveness_probe

    @property
    def readiness_probe(self):
        """Gets the readiness_probe of this Container.


        :return: The readiness_probe of this Container.
        :rtype: Probe
        """
        return self._readiness_probe

    @readiness_probe.setter
    def readiness_probe(self, readiness_probe):
        """Sets the readiness_probe of this Container.


        :param readiness_probe: The readiness_probe of this Container.
        :type readiness_probe: Probe
        """

        self._readiness_probe = readiness_probe

    @property
    def startup_probe(self):
        """Gets the startup_probe of this Container.


        :return: The startup_probe of this Container.
        :rtype: Probe
        """
        return self._startup_probe

    @startup_probe.setter
    def startup_probe(self, startup_probe):
        """Sets the startup_probe of this Container.


        :param startup_probe: The startup_probe of this Container.
        :type startup_probe: Probe
        """

        self._startup_probe = startup_probe
