# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server.models.ingress_backend import IngressBackend
from openapi_server import util

from openapi_server.models.ingress_backend import IngressBackend  # noqa: E501

class HTTPIngressPath(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, path=None, path_type=None, backend=None):  # noqa: E501
        """HTTPIngressPath - a model defined in OpenAPI

        :param name: The name of this HTTPIngressPath.  # noqa: E501
        :type name: str
        :param path: The path of this HTTPIngressPath.  # noqa: E501
        :type path: str
        :param path_type: The path_type of this HTTPIngressPath.  # noqa: E501
        :type path_type: str
        :param backend: The backend of this HTTPIngressPath.  # noqa: E501
        :type backend: IngressBackend
        """
        self.openapi_types = {
            'name': str,
            'path': str,
            'path_type': str,
            'backend': IngressBackend
        }

        self.attribute_map = {
            'name': 'name',
            'path': 'path',
            'path_type': 'path_type',
            'backend': 'backend'
        }

        self._name = name
        self._path = path
        self._path_type = path_type
        self._backend = backend

    @classmethod
    def from_dict(cls, dikt) -> 'HTTPIngressPath':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The HTTPIngressPath of this HTTPIngressPath.  # noqa: E501
        :rtype: HTTPIngressPath
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this HTTPIngressPath.

        The ingress path name.  # noqa: E501

        :return: The name of this HTTPIngressPath.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this HTTPIngressPath.

        The ingress path name.  # noqa: E501

        :param name: The name of this HTTPIngressPath.
        :type name: str
        """

        self._name = name

    @property
    def path(self):
        """Gets the path of this HTTPIngressPath.

        The path that is matched against the path of an incoming request. Must begin with a '/'.  # noqa: E501

        :return: The path of this HTTPIngressPath.
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this HTTPIngressPath.

        The path that is matched against the path of an incoming request. Must begin with a '/'.  # noqa: E501

        :param path: The path of this HTTPIngressPath.
        :type path: str
        """

        self._path = path

    @property
    def path_type(self):
        """Gets the path_type of this HTTPIngressPath.

        PathType determines the interpretation of the Path matching.  # noqa: E501

        :return: The path_type of this HTTPIngressPath.
        :rtype: str
        """
        return self._path_type

    @path_type.setter
    def path_type(self, path_type):
        """Sets the path_type of this HTTPIngressPath.

        PathType determines the interpretation of the Path matching.  # noqa: E501

        :param path_type: The path_type of this HTTPIngressPath.
        :type path_type: str
        """
        allowed_values = ["Exact", "Prefix"]  # noqa: E501
        if path_type not in allowed_values:
            raise ValueError(
                "Invalid value for `path_type` ({0}), must be one of {1}"
                .format(path_type, allowed_values)
            )

        self._path_type = path_type

    @property
    def backend(self):
        """Gets the backend of this HTTPIngressPath.


        :return: The backend of this HTTPIngressPath.
        :rtype: IngressBackend
        """
        return self._backend

    @backend.setter
    def backend(self, backend):
        """Sets the backend of this HTTPIngressPath.


        :param backend: The backend of this HTTPIngressPath.
        :type backend: IngressBackend
        """

        self._backend = backend
