# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class TcpSocket(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, port=None, host=None):  # noqa: E501
        """TcpSocket - a model defined in OpenAPI

        :param port: The port of this TcpSocket.  # noqa: E501
        :type port: int
        :param host: The host of this TcpSocket.  # noqa: E501
        :type host: str
        """
        self.openapi_types = {
            'port': int,
            'host': str
        }

        self.attribute_map = {
            'port': 'port',
            'host': 'host'
        }

        self._port = port
        self._host = host

    @classmethod
    def from_dict(cls, dikt) -> 'TcpSocket':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The TcpSocket of this TcpSocket.  # noqa: E501
        :rtype: TcpSocket
        """
        return util.deserialize_model(dikt, cls)

    @property
    def port(self):
        """Gets the port of this TcpSocket.

        Number of the port to access on the container.  # noqa: E501

        :return: The port of this TcpSocket.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this TcpSocket.

        Number of the port to access on the container.  # noqa: E501

        :param port: The port of this TcpSocket.
        :type port: int
        """
        if port is None:
            raise ValueError("Invalid value for `port`, must not be `None`")  # noqa: E501

        self._port = port

    @property
    def host(self):
        """Gets the host of this TcpSocket.

        Host name to connect to, defaults to the pod IP.  # noqa: E501

        :return: The host of this TcpSocket.
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this TcpSocket.

        Host name to connect to, defaults to the pod IP.  # noqa: E501

        :param host: The host of this TcpSocket.
        :type host: str
        """

        self._host = host
