# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class VolumeDevice(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, device_path=None, bcache_nums=None):  # noqa: E501
        """VolumeDevice - a model defined in OpenAPI

        :param name: The name of this VolumeDevice.  # noqa: E501
        :type name: object
        :param device_path: The device_path of this VolumeDevice.  # noqa: E501
        :type device_path: str
        :param bcache_nums: The bcache_nums of this VolumeDevice.  # noqa: E501
        :type bcache_nums: int
        """
        self.openapi_types = {
            'name': object,
            'device_path': str,
            'bcache_nums': int
        }

        self.attribute_map = {
            'name': 'name',
            'device_path': 'device_path',
            'bcache_nums': 'bcache_nums'
        }

        self._name = name
        self._device_path = device_path
        self._bcache_nums = bcache_nums

    @classmethod
    def from_dict(cls, dikt) -> 'VolumeDevice':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The VolumeDevice of this VolumeDevice.  # noqa: E501
        :rtype: VolumeDevice
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this VolumeDevice.

        Must match the Name of a Volume  # noqa: E501

        :return: The name of this VolumeDevice.
        :rtype: object
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VolumeDevice.

        Must match the Name of a Volume  # noqa: E501

        :param name: The name of this VolumeDevice.
        :type name: object
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def device_path(self):
        """Gets the device_path of this VolumeDevice.

        Path of the device within the container  # noqa: E501

        :return: The device_path of this VolumeDevice.
        :rtype: str
        """
        return self._device_path

    @device_path.setter
    def device_path(self, device_path):
        """Sets the device_path of this VolumeDevice.

        Path of the device within the container  # noqa: E501

        :param device_path: The device_path of this VolumeDevice.
        :type device_path: str
        """

        self._device_path = device_path

    @property
    def bcache_nums(self):
        """Gets the bcache_nums of this VolumeDevice.

        Used for ATS deployment to automatically generate bcache_nums volume devices and related contents.  # noqa: E501

        :return: The bcache_nums of this VolumeDevice.
        :rtype: int
        """
        return self._bcache_nums

    @bcache_nums.setter
    def bcache_nums(self, bcache_nums):
        """Sets the bcache_nums of this VolumeDevice.

        Used for ATS deployment to automatically generate bcache_nums volume devices and related contents.  # noqa: E501

        :param bcache_nums: The bcache_nums of this VolumeDevice.
        :type bcache_nums: int
        """

        self._bcache_nums = bcache_nums
