# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server.models.config import Config
from openapi_server.models.ingress import Ingress
from openapi_server.models.persistent_volume_claim import PersistentVolumeClaim
from openapi_server.models.role import Role
from openapi_server.models.role_binding import RoleBinding
from openapi_server.models.secret import Secret
from openapi_server.models.service import Service
from openapi_server.models.service_monitor import ServiceMonitor
from openapi_server.models.workload import Workload
from openapi_server import util

from openapi_server.models.config import Config  # noqa: E501
from openapi_server.models.ingress import Ingress  # noqa: E501
from openapi_server.models.persistent_volume_claim import PersistentVolumeClaim  # noqa: E501
from openapi_server.models.role import Role  # noqa: E501
from openapi_server.models.role_binding import RoleBinding  # noqa: E501
from openapi_server.models.secret import Secret  # noqa: E501
from openapi_server.models.service import Service  # noqa: E501
from openapi_server.models.service_monitor import ServiceMonitor  # noqa: E501
from openapi_server.models.workload import Workload  # noqa: E501

class DeployResources(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, workloads=None, services=None, configs=None, secrets=None, persistent_volume_claims=None, ingress=None, service_monitors=None, roles=None, role_bindings=None):  # noqa: E501
        """DeployResources - a model defined in OpenAPI

        :param workloads: The workloads of this DeployResources.  # noqa: E501
        :type workloads: List[Workload]
        :param services: The services of this DeployResources.  # noqa: E501
        :type services: List[Service]
        :param configs: The configs of this DeployResources.  # noqa: E501
        :type configs: List[Config]
        :param secrets: The secrets of this DeployResources.  # noqa: E501
        :type secrets: List[Secret]
        :param persistent_volume_claims: The persistent_volume_claims of this DeployResources.  # noqa: E501
        :type persistent_volume_claims: List[PersistentVolumeClaim]
        :param ingress: The ingress of this DeployResources.  # noqa: E501
        :type ingress: List[Ingress]
        :param service_monitors: The service_monitors of this DeployResources.  # noqa: E501
        :type service_monitors: List[ServiceMonitor]
        :param roles: The roles of this DeployResources.  # noqa: E501
        :type roles: List[Role]
        :param role_bindings: The role_bindings of this DeployResources.  # noqa: E501
        :type role_bindings: List[RoleBinding]
        """
        self.openapi_types = {
            'workloads': List[Workload],
            'services': List[Service],
            'configs': List[Config],
            'secrets': List[Secret],
            'persistent_volume_claims': List[PersistentVolumeClaim],
            'ingress': List[Ingress],
            'service_monitors': List[ServiceMonitor],
            'roles': List[Role],
            'role_bindings': List[RoleBinding]
        }

        self.attribute_map = {
            'workloads': 'workloads',
            'services': 'services',
            'configs': 'configs',
            'secrets': 'secrets',
            'persistent_volume_claims': 'persistent_volume_claims',
            'ingress': 'ingress',
            'service_monitors': 'service_monitors',
            'roles': 'roles',
            'role_bindings': 'role_bindings'
        }

        self._workloads = workloads
        self._services = services
        self._configs = configs
        self._secrets = secrets
        self._persistent_volume_claims = persistent_volume_claims
        self._ingress = ingress
        self._service_monitors = service_monitors
        self._roles = roles
        self._role_bindings = role_bindings

    @classmethod
    def from_dict(cls, dikt) -> 'DeployResources':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The DeployResources of this DeployResources.  # noqa: E501
        :rtype: DeployResources
        """
        return util.deserialize_model(dikt, cls)

    @property
    def workloads(self):
        """Gets the workloads of this DeployResources.


        :return: The workloads of this DeployResources.
        :rtype: List[Workload]
        """
        return self._workloads

    @workloads.setter
    def workloads(self, workloads):
        """Sets the workloads of this DeployResources.


        :param workloads: The workloads of this DeployResources.
        :type workloads: List[Workload]
        """

        self._workloads = workloads

    @property
    def services(self):
        """Gets the services of this DeployResources.


        :return: The services of this DeployResources.
        :rtype: List[Service]
        """
        return self._services

    @services.setter
    def services(self, services):
        """Sets the services of this DeployResources.


        :param services: The services of this DeployResources.
        :type services: List[Service]
        """

        self._services = services

    @property
    def configs(self):
        """Gets the configs of this DeployResources.


        :return: The configs of this DeployResources.
        :rtype: List[Config]
        """
        return self._configs

    @configs.setter
    def configs(self, configs):
        """Sets the configs of this DeployResources.


        :param configs: The configs of this DeployResources.
        :type configs: List[Config]
        """

        self._configs = configs

    @property
    def secrets(self):
        """Gets the secrets of this DeployResources.


        :return: The secrets of this DeployResources.
        :rtype: List[Secret]
        """
        return self._secrets

    @secrets.setter
    def secrets(self, secrets):
        """Sets the secrets of this DeployResources.


        :param secrets: The secrets of this DeployResources.
        :type secrets: List[Secret]
        """

        self._secrets = secrets

    @property
    def persistent_volume_claims(self):
        """Gets the persistent_volume_claims of this DeployResources.

        List of Persistent Volume Claims  # noqa: E501

        :return: The persistent_volume_claims of this DeployResources.
        :rtype: List[PersistentVolumeClaim]
        """
        return self._persistent_volume_claims

    @persistent_volume_claims.setter
    def persistent_volume_claims(self, persistent_volume_claims):
        """Sets the persistent_volume_claims of this DeployResources.

        List of Persistent Volume Claims  # noqa: E501

        :param persistent_volume_claims: The persistent_volume_claims of this DeployResources.
        :type persistent_volume_claims: List[PersistentVolumeClaim]
        """

        self._persistent_volume_claims = persistent_volume_claims

    @property
    def ingress(self):
        """Gets the ingress of this DeployResources.

        List of Ingress configs for k8s Ingress Controller  # noqa: E501

        :return: The ingress of this DeployResources.
        :rtype: List[Ingress]
        """
        return self._ingress

    @ingress.setter
    def ingress(self, ingress):
        """Sets the ingress of this DeployResources.

        List of Ingress configs for k8s Ingress Controller  # noqa: E501

        :param ingress: The ingress of this DeployResources.
        :type ingress: List[Ingress]
        """

        self._ingress = ingress

    @property
    def service_monitors(self):
        """Gets the service_monitors of this DeployResources.

        List of Service Monitors for Prometheus Operator  # noqa: E501

        :return: The service_monitors of this DeployResources.
        :rtype: List[ServiceMonitor]
        """
        return self._service_monitors

    @service_monitors.setter
    def service_monitors(self, service_monitors):
        """Sets the service_monitors of this DeployResources.

        List of Service Monitors for Prometheus Operator  # noqa: E501

        :param service_monitors: The service_monitors of this DeployResources.
        :type service_monitors: List[ServiceMonitor]
        """

        self._service_monitors = service_monitors

    @property
    def roles(self):
        """Gets the roles of this DeployResources.

        List of roles and clusterRoles.  # noqa: E501

        :return: The roles of this DeployResources.
        :rtype: List[Role]
        """
        return self._roles

    @roles.setter
    def roles(self, roles):
        """Sets the roles of this DeployResources.

        List of roles and clusterRoles.  # noqa: E501

        :param roles: The roles of this DeployResources.
        :type roles: List[Role]
        """

        self._roles = roles

    @property
    def role_bindings(self):
        """Gets the role_bindings of this DeployResources.

        List of role bindings and cluster role bindings.  # noqa: E501

        :return: The role_bindings of this DeployResources.
        :rtype: List[RoleBinding]
        """
        return self._role_bindings

    @role_bindings.setter
    def role_bindings(self, role_bindings):
        """Sets the role_bindings of this DeployResources.

        List of role bindings and cluster role bindings.  # noqa: E501

        :param role_bindings: The role_bindings of this DeployResources.
        :type role_bindings: List[RoleBinding]
        """

        self._role_bindings = role_bindings
