# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server.models.http_ingress_path import HTTPIngressPath
from openapi_server import util

from openapi_server.models.http_ingress_path import HTTPIngressPath  # noqa: E501

class IngressRule(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, host=None, paths=None):  # noqa: E501
        """IngressRule - a model defined in OpenAPI

        :param name: The name of this IngressRule.  # noqa: E501
        :type name: str
        :param host: The host of this IngressRule.  # noqa: E501
        :type host: str
        :param paths: The paths of this IngressRule.  # noqa: E501
        :type paths: List[HTTPIngressPath]
        """
        self.openapi_types = {
            'name': str,
            'host': str,
            'paths': List[HTTPIngressPath]
        }

        self.attribute_map = {
            'name': 'name',
            'host': 'host',
            'paths': 'paths'
        }

        self._name = name
        self._host = host
        self._paths = paths

    @classmethod
    def from_dict(cls, dikt) -> 'IngressRule':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The IngressRule of this IngressRule.  # noqa: E501
        :rtype: IngressRule
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this IngressRule.

        The rule name.  # noqa: E501

        :return: The name of this IngressRule.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this IngressRule.

        The rule name.  # noqa: E501

        :param name: The name of this IngressRule.
        :type name: str
        """

        self._name = name

    @property
    def host(self):
        """Gets the host of this IngressRule.

        A fully qualified domain name of a network host.  # noqa: E501

        :return: The host of this IngressRule.
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this IngressRule.

        A fully qualified domain name of a network host.  # noqa: E501

        :param host: The host of this IngressRule.
        :type host: str
        """

        self._host = host

    @property
    def paths(self):
        """Gets the paths of this IngressRule.


        :return: The paths of this IngressRule.
        :rtype: List[HTTPIngressPath]
        """
        return self._paths

    @paths.setter
    def paths(self, paths):
        """Sets the paths of this IngressRule.


        :param paths: The paths of this IngressRule.
        :type paths: List[HTTPIngressPath]
        """

        self._paths = paths
