# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server.models.resource_requirements import ResourceRequirements
from openapi_server import util

from openapi_server.models.resource_requirements import ResourceRequirements  # noqa: E501

class PersistentVolumeClaim(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, namespace=None, labels=None, annotations=None, storage_class_name=None, access_modes=None, volume_name=None, volume_mode=None, request_resources=None):  # noqa: E501
        """PersistentVolumeClaim - a model defined in OpenAPI

        :param name: The name of this PersistentVolumeClaim.  # noqa: E501
        :type name: str
        :param namespace: The namespace of this PersistentVolumeClaim.  # noqa: E501
        :type namespace: str
        :param labels: The labels of this PersistentVolumeClaim.  # noqa: E501
        :type labels: List[str]
        :param annotations: The annotations of this PersistentVolumeClaim.  # noqa: E501
        :type annotations: List[str]
        :param storage_class_name: The storage_class_name of this PersistentVolumeClaim.  # noqa: E501
        :type storage_class_name: str
        :param access_modes: The access_modes of this PersistentVolumeClaim.  # noqa: E501
        :type access_modes: List[str]
        :param volume_name: The volume_name of this PersistentVolumeClaim.  # noqa: E501
        :type volume_name: str
        :param volume_mode: The volume_mode of this PersistentVolumeClaim.  # noqa: E501
        :type volume_mode: str
        :param request_resources: The request_resources of this PersistentVolumeClaim.  # noqa: E501
        :type request_resources: ResourceRequirements
        """
        self.openapi_types = {
            'name': str,
            'namespace': str,
            'labels': List[str],
            'annotations': List[str],
            'storage_class_name': str,
            'access_modes': List[str],
            'volume_name': str,
            'volume_mode': str,
            'request_resources': ResourceRequirements
        }

        self.attribute_map = {
            'name': 'name',
            'namespace': 'namespace',
            'labels': 'labels',
            'annotations': 'annotations',
            'storage_class_name': 'storage_class_name',
            'access_modes': 'access_modes',
            'volume_name': 'volume_name',
            'volume_mode': 'volume_mode',
            'request_resources': 'request_resources'
        }

        self._name = name
        self._namespace = namespace
        self._labels = labels
        self._annotations = annotations
        self._storage_class_name = storage_class_name
        self._access_modes = access_modes
        self._volume_name = volume_name
        self._volume_mode = volume_mode
        self._request_resources = request_resources

    @classmethod
    def from_dict(cls, dikt) -> 'PersistentVolumeClaim':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The PersistentVolumeClaim of this PersistentVolumeClaim.  # noqa: E501
        :rtype: PersistentVolumeClaim
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this PersistentVolumeClaim.

        name of persistent volume claim, used in metadata.name  # noqa: E501

        :return: The name of this PersistentVolumeClaim.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PersistentVolumeClaim.

        name of persistent volume claim, used in metadata.name  # noqa: E501

        :param name: The name of this PersistentVolumeClaim.
        :type name: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def namespace(self):
        """Gets the namespace of this PersistentVolumeClaim.

        namespace for resource.  # noqa: E501

        :return: The namespace of this PersistentVolumeClaim.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this PersistentVolumeClaim.

        namespace for resource.  # noqa: E501

        :param namespace: The namespace of this PersistentVolumeClaim.
        :type namespace: str
        """

        self._namespace = namespace

    @property
    def labels(self):
        """Gets the labels of this PersistentVolumeClaim.

        Map of string keys and values that can be used to organize and categorize (scope and select) objects  # noqa: E501

        :return: The labels of this PersistentVolumeClaim.
        :rtype: List[str]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this PersistentVolumeClaim.

        Map of string keys and values that can be used to organize and categorize (scope and select) objects  # noqa: E501

        :param labels: The labels of this PersistentVolumeClaim.
        :type labels: List[str]
        """

        self._labels = labels

    @property
    def annotations(self):
        """Gets the annotations of this PersistentVolumeClaim.

        An unstructured key value map that can be used to attach arbitrary metadata  # noqa: E501

        :return: The annotations of this PersistentVolumeClaim.
        :rtype: List[str]
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations):
        """Sets the annotations of this PersistentVolumeClaim.

        An unstructured key value map that can be used to attach arbitrary metadata  # noqa: E501

        :param annotations: The annotations of this PersistentVolumeClaim.
        :type annotations: List[str]
        """

        self._annotations = annotations

    @property
    def storage_class_name(self):
        """Gets the storage_class_name of this PersistentVolumeClaim.

        Name of the StorageClass for the Persistent Volume Claim  # noqa: E501

        :return: The storage_class_name of this PersistentVolumeClaim.
        :rtype: str
        """
        return self._storage_class_name

    @storage_class_name.setter
    def storage_class_name(self, storage_class_name):
        """Sets the storage_class_name of this PersistentVolumeClaim.

        Name of the StorageClass for the Persistent Volume Claim  # noqa: E501

        :param storage_class_name: The storage_class_name of this PersistentVolumeClaim.
        :type storage_class_name: str
        """

        self._storage_class_name = storage_class_name

    @property
    def access_modes(self):
        """Gets the access_modes of this PersistentVolumeClaim.

        List of access modes for the Persistent Volume, e.g. ReadWriteOnce, ReadOnlyMany, etc.  # noqa: E501

        :return: The access_modes of this PersistentVolumeClaim.
        :rtype: List[str]
        """
        return self._access_modes

    @access_modes.setter
    def access_modes(self, access_modes):
        """Sets the access_modes of this PersistentVolumeClaim.

        List of access modes for the Persistent Volume, e.g. ReadWriteOnce, ReadOnlyMany, etc.  # noqa: E501

        :param access_modes: The access_modes of this PersistentVolumeClaim.
        :type access_modes: List[str]
        """

        self._access_modes = access_modes

    @property
    def volume_name(self):
        """Gets the volume_name of this PersistentVolumeClaim.

        Name of the Persistent Volume bound to the claim  # noqa: E501

        :return: The volume_name of this PersistentVolumeClaim.
        :rtype: str
        """
        return self._volume_name

    @volume_name.setter
    def volume_name(self, volume_name):
        """Sets the volume_name of this PersistentVolumeClaim.

        Name of the Persistent Volume bound to the claim  # noqa: E501

        :param volume_name: The volume_name of this PersistentVolumeClaim.
        :type volume_name: str
        """

        self._volume_name = volume_name

    @property
    def volume_mode(self):
        """Gets the volume_mode of this PersistentVolumeClaim.

        Mode of the volume, either \"Filesystem\" or \"Block\"  # noqa: E501

        :return: The volume_mode of this PersistentVolumeClaim.
        :rtype: str
        """
        return self._volume_mode

    @volume_mode.setter
    def volume_mode(self, volume_mode):
        """Sets the volume_mode of this PersistentVolumeClaim.

        Mode of the volume, either \"Filesystem\" or \"Block\"  # noqa: E501

        :param volume_mode: The volume_mode of this PersistentVolumeClaim.
        :type volume_mode: str
        """

        self._volume_mode = volume_mode

    @property
    def request_resources(self):
        """Gets the request_resources of this PersistentVolumeClaim.


        :return: The request_resources of this PersistentVolumeClaim.
        :rtype: ResourceRequirements
        """
        return self._request_resources

    @request_resources.setter
    def request_resources(self, request_resources):
        """Sets the request_resources of this PersistentVolumeClaim.


        :param request_resources: The request_resources of this PersistentVolumeClaim.
        :type request_resources: ResourceRequirements
        """

        self._request_resources = request_resources
