# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server.models.affinity import Affinity
from openapi_server.models.container import Container
from openapi_server.models.pod_sec_context import PodSecContext
from openapi_server.models.topology_spread_constraint import TopologySpreadConstraint
from openapi_server.models.volume import Volume
from openapi_server import util

from openapi_server.models.affinity import Affinity  # noqa: E501
from openapi_server.models.container import Container  # noqa: E501
from openapi_server.models.pod_sec_context import PodSecContext  # noqa: E501
from openapi_server.models.topology_spread_constraint import TopologySpreadConstraint  # noqa: E501
from openapi_server.models.volume import Volume  # noqa: E501

class Pod(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, labels=None, annotations=None, containers=None, topology_spread_constraints=None, dns_policy=None, restart_policy=None, image_pull_secrets=None, scheduler_name=None, termination_grace_period_seconds=None, volumes=None, affinity=None, security_context=None):  # noqa: E501
        """Pod - a model defined in OpenAPI

        :param labels: The labels of this Pod.  # noqa: E501
        :type labels: List[str]
        :param annotations: The annotations of this Pod.  # noqa: E501
        :type annotations: List[str]
        :param containers: The containers of this Pod.  # noqa: E501
        :type containers: List[Container]
        :param topology_spread_constraints: The topology_spread_constraints of this Pod.  # noqa: E501
        :type topology_spread_constraints: List[TopologySpreadConstraint]
        :param dns_policy: The dns_policy of this Pod.  # noqa: E501
        :type dns_policy: str
        :param restart_policy: The restart_policy of this Pod.  # noqa: E501
        :type restart_policy: str
        :param image_pull_secrets: The image_pull_secrets of this Pod.  # noqa: E501
        :type image_pull_secrets: List[str]
        :param scheduler_name: The scheduler_name of this Pod.  # noqa: E501
        :type scheduler_name: str
        :param termination_grace_period_seconds: The termination_grace_period_seconds of this Pod.  # noqa: E501
        :type termination_grace_period_seconds: int
        :param volumes: The volumes of this Pod.  # noqa: E501
        :type volumes: List[Volume]
        :param affinity: The affinity of this Pod.  # noqa: E501
        :type affinity: Affinity
        :param security_context: The security_context of this Pod.  # noqa: E501
        :type security_context: PodSecContext
        """
        self.openapi_types = {
            'labels': List[str],
            'annotations': List[str],
            'containers': List[Container],
            'topology_spread_constraints': List[TopologySpreadConstraint],
            'dns_policy': str,
            'restart_policy': str,
            'image_pull_secrets': List[str],
            'scheduler_name': str,
            'termination_grace_period_seconds': int,
            'volumes': List[Volume],
            'affinity': Affinity,
            'security_context': PodSecContext
        }

        self.attribute_map = {
            'labels': 'labels',
            'annotations': 'annotations',
            'containers': 'containers',
            'topology_spread_constraints': 'topology_spread_constraints',
            'dns_policy': 'dns_policy',
            'restart_policy': 'restart_policy',
            'image_pull_secrets': 'image_pull_secrets',
            'scheduler_name': 'scheduler_name',
            'termination_grace_period_seconds': 'termination_grace_period_seconds',
            'volumes': 'volumes',
            'affinity': 'affinity',
            'security_context': 'security_context'
        }

        self._labels = labels
        self._annotations = annotations
        self._containers = containers
        self._topology_spread_constraints = topology_spread_constraints
        self._dns_policy = dns_policy
        self._restart_policy = restart_policy
        self._image_pull_secrets = image_pull_secrets
        self._scheduler_name = scheduler_name
        self._termination_grace_period_seconds = termination_grace_period_seconds
        self._volumes = volumes
        self._affinity = affinity
        self._security_context = security_context

    @classmethod
    def from_dict(cls, dikt) -> 'Pod':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Pod of this Pod.  # noqa: E501
        :rtype: Pod
        """
        return util.deserialize_model(dikt, cls)

    @property
    def labels(self):
        """Gets the labels of this Pod.

        Map of string keys and values that can be used to organize and categorize (scope and select) objects  # noqa: E501

        :return: The labels of this Pod.
        :rtype: List[str]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this Pod.

        Map of string keys and values that can be used to organize and categorize (scope and select) objects  # noqa: E501

        :param labels: The labels of this Pod.
        :type labels: List[str]
        """

        self._labels = labels

    @property
    def annotations(self):
        """Gets the annotations of this Pod.

        An unstructured key value map that can be used to attach arbitrary metadata  # noqa: E501

        :return: The annotations of this Pod.
        :rtype: List[str]
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations):
        """Sets the annotations of this Pod.

        An unstructured key value map that can be used to attach arbitrary metadata  # noqa: E501

        :param annotations: The annotations of this Pod.
        :type annotations: List[str]
        """

        self._annotations = annotations

    @property
    def containers(self):
        """Gets the containers of this Pod.


        :return: The containers of this Pod.
        :rtype: List[Container]
        """
        return self._containers

    @containers.setter
    def containers(self, containers):
        """Sets the containers of this Pod.


        :param containers: The containers of this Pod.
        :type containers: List[Container]
        """

        self._containers = containers

    @property
    def topology_spread_constraints(self):
        """Gets the topology_spread_constraints of this Pod.


        :return: The topology_spread_constraints of this Pod.
        :rtype: List[TopologySpreadConstraint]
        """
        return self._topology_spread_constraints

    @topology_spread_constraints.setter
    def topology_spread_constraints(self, topology_spread_constraints):
        """Sets the topology_spread_constraints of this Pod.


        :param topology_spread_constraints: The topology_spread_constraints of this Pod.
        :type topology_spread_constraints: List[TopologySpreadConstraint]
        """

        self._topology_spread_constraints = topology_spread_constraints

    @property
    def dns_policy(self):
        """Gets the dns_policy of this Pod.

        This specifies the DNS resolution policy for the Pod.  # noqa: E501

        :return: The dns_policy of this Pod.
        :rtype: str
        """
        return self._dns_policy

    @dns_policy.setter
    def dns_policy(self, dns_policy):
        """Sets the dns_policy of this Pod.

        This specifies the DNS resolution policy for the Pod.  # noqa: E501

        :param dns_policy: The dns_policy of this Pod.
        :type dns_policy: str
        """

        self._dns_policy = dns_policy

    @property
    def restart_policy(self):
        """Gets the restart_policy of this Pod.

        This sets the restart policy for the Pod, which applies to all containers in the Pod.  # noqa: E501

        :return: The restart_policy of this Pod.
        :rtype: str
        """
        return self._restart_policy

    @restart_policy.setter
    def restart_policy(self, restart_policy):
        """Sets the restart_policy of this Pod.

        This sets the restart policy for the Pod, which applies to all containers in the Pod.  # noqa: E501

        :param restart_policy: The restart_policy of this Pod.
        :type restart_policy: str
        """

        self._restart_policy = restart_policy

    @property
    def image_pull_secrets(self):
        """Gets the image_pull_secrets of this Pod.

        This defines an array of image pull secrets for the Pod.  # noqa: E501

        :return: The image_pull_secrets of this Pod.
        :rtype: List[str]
        """
        return self._image_pull_secrets

    @image_pull_secrets.setter
    def image_pull_secrets(self, image_pull_secrets):
        """Sets the image_pull_secrets of this Pod.

        This defines an array of image pull secrets for the Pod.  # noqa: E501

        :param image_pull_secrets: The image_pull_secrets of this Pod.
        :type image_pull_secrets: List[str]
        """

        self._image_pull_secrets = image_pull_secrets

    @property
    def scheduler_name(self):
        """Gets the scheduler_name of this Pod.

        This specifies the name of the scheduler that should be used to schedule the Pod.  # noqa: E501

        :return: The scheduler_name of this Pod.
        :rtype: str
        """
        return self._scheduler_name

    @scheduler_name.setter
    def scheduler_name(self, scheduler_name):
        """Sets the scheduler_name of this Pod.

        This specifies the name of the scheduler that should be used to schedule the Pod.  # noqa: E501

        :param scheduler_name: The scheduler_name of this Pod.
        :type scheduler_name: str
        """

        self._scheduler_name = scheduler_name

    @property
    def termination_grace_period_seconds(self):
        """Gets the termination_grace_period_seconds of this Pod.

        This sets the grace period, in seconds, for the Pod's termination.  # noqa: E501

        :return: The termination_grace_period_seconds of this Pod.
        :rtype: int
        """
        return self._termination_grace_period_seconds

    @termination_grace_period_seconds.setter
    def termination_grace_period_seconds(self, termination_grace_period_seconds):
        """Sets the termination_grace_period_seconds of this Pod.

        This sets the grace period, in seconds, for the Pod's termination.  # noqa: E501

        :param termination_grace_period_seconds: The termination_grace_period_seconds of this Pod.
        :type termination_grace_period_seconds: int
        """

        self._termination_grace_period_seconds = termination_grace_period_seconds

    @property
    def volumes(self):
        """Gets the volumes of this Pod.


        :return: The volumes of this Pod.
        :rtype: List[Volume]
        """
        return self._volumes

    @volumes.setter
    def volumes(self, volumes):
        """Sets the volumes of this Pod.


        :param volumes: The volumes of this Pod.
        :type volumes: List[Volume]
        """

        self._volumes = volumes

    @property
    def affinity(self):
        """Gets the affinity of this Pod.


        :return: The affinity of this Pod.
        :rtype: Affinity
        """
        return self._affinity

    @affinity.setter
    def affinity(self, affinity):
        """Sets the affinity of this Pod.


        :param affinity: The affinity of this Pod.
        :type affinity: Affinity
        """

        self._affinity = affinity

    @property
    def security_context(self):
        """Gets the security_context of this Pod.


        :return: The security_context of this Pod.
        :rtype: PodSecContext
        """
        return self._security_context

    @security_context.setter
    def security_context(self, security_context):
        """Sets the security_context of this Pod.


        :param security_context: The security_context of this Pod.
        :type security_context: PodSecContext
        """

        self._security_context = security_context
