# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server.models.http_get import HttpGet
from openapi_server.models.tcp_socket import TcpSocket
from openapi_server import util

from openapi_server.models.http_get import HttpGet  # noqa: E501
from openapi_server.models.tcp_socket import TcpSocket  # noqa: E501

class Probe(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, exec_command=None, http_get=None, tcp_socket=None, failure_threshold=None, period_seconds=None, timeout_seconds=None, initial_delay_seconds=None):  # noqa: E501
        """Probe - a model defined in OpenAPI

        :param exec_command: The exec_command of this Probe.  # noqa: E501
        :type exec_command: List[str]
        :param http_get: The http_get of this Probe.  # noqa: E501
        :type http_get: HttpGet
        :param tcp_socket: The tcp_socket of this Probe.  # noqa: E501
        :type tcp_socket: TcpSocket
        :param failure_threshold: The failure_threshold of this Probe.  # noqa: E501
        :type failure_threshold: int
        :param period_seconds: The period_seconds of this Probe.  # noqa: E501
        :type period_seconds: int
        :param timeout_seconds: The timeout_seconds of this Probe.  # noqa: E501
        :type timeout_seconds: int
        :param initial_delay_seconds: The initial_delay_seconds of this Probe.  # noqa: E501
        :type initial_delay_seconds: int
        """
        self.openapi_types = {
            'exec_command': List[str],
            'http_get': HttpGet,
            'tcp_socket': TcpSocket,
            'failure_threshold': int,
            'period_seconds': int,
            'timeout_seconds': int,
            'initial_delay_seconds': int
        }

        self.attribute_map = {
            'exec_command': 'exec_command',
            'http_get': 'http_get',
            'tcp_socket': 'tcp_socket',
            'failure_threshold': 'failure_threshold',
            'period_seconds': 'period_seconds',
            'timeout_seconds': 'timeout_seconds',
            'initial_delay_seconds': 'initial_delay_seconds'
        }

        self._exec_command = exec_command
        self._http_get = http_get
        self._tcp_socket = tcp_socket
        self._failure_threshold = failure_threshold
        self._period_seconds = period_seconds
        self._timeout_seconds = timeout_seconds
        self._initial_delay_seconds = initial_delay_seconds

    @classmethod
    def from_dict(cls, dikt) -> 'Probe':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Probe of this Probe.  # noqa: E501
        :rtype: Probe
        """
        return util.deserialize_model(dikt, cls)

    @property
    def exec_command(self):
        """Gets the exec_command of this Probe.

        Command line to execute inside the container  # noqa: E501

        :return: The exec_command of this Probe.
        :rtype: List[str]
        """
        return self._exec_command

    @exec_command.setter
    def exec_command(self, exec_command):
        """Sets the exec_command of this Probe.

        Command line to execute inside the container  # noqa: E501

        :param exec_command: The exec_command of this Probe.
        :type exec_command: List[str]
        """

        self._exec_command = exec_command

    @property
    def http_get(self):
        """Gets the http_get of this Probe.


        :return: The http_get of this Probe.
        :rtype: HttpGet
        """
        return self._http_get

    @http_get.setter
    def http_get(self, http_get):
        """Sets the http_get of this Probe.


        :param http_get: The http_get of this Probe.
        :type http_get: HttpGet
        """

        self._http_get = http_get

    @property
    def tcp_socket(self):
        """Gets the tcp_socket of this Probe.


        :return: The tcp_socket of this Probe.
        :rtype: TcpSocket
        """
        return self._tcp_socket

    @tcp_socket.setter
    def tcp_socket(self, tcp_socket):
        """Sets the tcp_socket of this Probe.


        :param tcp_socket: The tcp_socket of this Probe.
        :type tcp_socket: TcpSocket
        """

        self._tcp_socket = tcp_socket

    @property
    def failure_threshold(self):
        """Gets the failure_threshold of this Probe.

        Minimum consecutive failures for the probe to be considered failed after having succeeded.  # noqa: E501

        :return: The failure_threshold of this Probe.
        :rtype: int
        """
        return self._failure_threshold

    @failure_threshold.setter
    def failure_threshold(self, failure_threshold):
        """Sets the failure_threshold of this Probe.

        Minimum consecutive failures for the probe to be considered failed after having succeeded.  # noqa: E501

        :param failure_threshold: The failure_threshold of this Probe.
        :type failure_threshold: int
        """

        self._failure_threshold = failure_threshold

    @property
    def period_seconds(self):
        """Gets the period_seconds of this Probe.

        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.  # noqa: E501

        :return: The period_seconds of this Probe.
        :rtype: int
        """
        return self._period_seconds

    @period_seconds.setter
    def period_seconds(self, period_seconds):
        """Sets the period_seconds of this Probe.

        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.  # noqa: E501

        :param period_seconds: The period_seconds of this Probe.
        :type period_seconds: int
        """

        self._period_seconds = period_seconds

    @property
    def timeout_seconds(self):
        """Gets the timeout_seconds of this Probe.

        Number of seconds after which the probe times out. Defaults to 1 second.  # noqa: E501

        :return: The timeout_seconds of this Probe.
        :rtype: int
        """
        return self._timeout_seconds

    @timeout_seconds.setter
    def timeout_seconds(self, timeout_seconds):
        """Sets the timeout_seconds of this Probe.

        Number of seconds after which the probe times out. Defaults to 1 second.  # noqa: E501

        :param timeout_seconds: The timeout_seconds of this Probe.
        :type timeout_seconds: int
        """

        self._timeout_seconds = timeout_seconds

    @property
    def initial_delay_seconds(self):
        """Gets the initial_delay_seconds of this Probe.

        Number of seconds after the container has started before liveness probes are initiated.  # noqa: E501

        :return: The initial_delay_seconds of this Probe.
        :rtype: int
        """
        return self._initial_delay_seconds

    @initial_delay_seconds.setter
    def initial_delay_seconds(self, initial_delay_seconds):
        """Sets the initial_delay_seconds of this Probe.

        Number of seconds after the container has started before liveness probes are initiated.  # noqa: E501

        :param initial_delay_seconds: The initial_delay_seconds of this Probe.
        :type initial_delay_seconds: int
        """

        self._initial_delay_seconds = initial_delay_seconds
