# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class ResourceRequirements(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, limits=None, requests=None):  # noqa: E501
        """ResourceRequirements - a model defined in OpenAPI

        :param limits: The limits of this ResourceRequirements.  # noqa: E501
        :type limits: Dict[str, str]
        :param requests: The requests of this ResourceRequirements.  # noqa: E501
        :type requests: Dict[str, str]
        """
        self.openapi_types = {
            'limits': Dict[str, str],
            'requests': Dict[str, str]
        }

        self.attribute_map = {
            'limits': 'limits',
            'requests': 'requests'
        }

        self._limits = limits
        self._requests = requests

    @classmethod
    def from_dict(cls, dikt) -> 'ResourceRequirements':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ResourceRequirements of this ResourceRequirements.  # noqa: E501
        :rtype: ResourceRequirements
        """
        return util.deserialize_model(dikt, cls)

    @property
    def limits(self):
        """Gets the limits of this ResourceRequirements.

        used to specify the maximum amount of resources that can be consumed.  # noqa: E501

        :return: The limits of this ResourceRequirements.
        :rtype: Dict[str, str]
        """
        return self._limits

    @limits.setter
    def limits(self, limits):
        """Sets the limits of this ResourceRequirements.

        used to specify the maximum amount of resources that can be consumed.  # noqa: E501

        :param limits: The limits of this ResourceRequirements.
        :type limits: Dict[str, str]
        """

        self._limits = limits

    @property
    def requests(self):
        """Gets the requests of this ResourceRequirements.

        used to specify the minimum amount of resources that should be consumed.  # noqa: E501

        :return: The requests of this ResourceRequirements.
        :rtype: Dict[str, str]
        """
        return self._requests

    @requests.setter
    def requests(self, requests):
        """Sets the requests of this ResourceRequirements.

        used to specify the minimum amount of resources that should be consumed.  # noqa: E501

        :param requests: The requests of this ResourceRequirements.
        :type requests: Dict[str, str]
        """

        self._requests = requests
