# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server.models.rbac_role_ref import RBACRoleRef
from openapi_server.models.role_binding_subject import RoleBindingSubject
from openapi_server import util

from openapi_server.models.rbac_role_ref import RBACRoleRef  # noqa: E501
from openapi_server.models.role_binding_subject import RoleBindingSubject  # noqa: E501

class RoleBinding(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, kind=None, namespace=None, labels=None, role_ref=None, subjects=None):  # noqa: E501
        """RoleBinding - a model defined in OpenAPI

        :param name: The name of this RoleBinding.  # noqa: E501
        :type name: str
        :param kind: The kind of this RoleBinding.  # noqa: E501
        :type kind: str
        :param namespace: The namespace of this RoleBinding.  # noqa: E501
        :type namespace: str
        :param labels: The labels of this RoleBinding.  # noqa: E501
        :type labels: List[str]
        :param role_ref: The role_ref of this RoleBinding.  # noqa: E501
        :type role_ref: RBACRoleRef
        :param subjects: The subjects of this RoleBinding.  # noqa: E501
        :type subjects: List[RoleBindingSubject]
        """
        self.openapi_types = {
            'name': str,
            'kind': str,
            'namespace': str,
            'labels': List[str],
            'role_ref': RBACRoleRef,
            'subjects': List[RoleBindingSubject]
        }

        self.attribute_map = {
            'name': 'name',
            'kind': 'kind',
            'namespace': 'namespace',
            'labels': 'labels',
            'role_ref': 'role_ref',
            'subjects': 'subjects'
        }

        self._name = name
        self._kind = kind
        self._namespace = namespace
        self._labels = labels
        self._role_ref = role_ref
        self._subjects = subjects

    @classmethod
    def from_dict(cls, dikt) -> 'RoleBinding':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The RoleBinding of this RoleBinding.  # noqa: E501
        :rtype: RoleBinding
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this RoleBinding.

        name of RoleBinding or ClusterRoleBinding  # noqa: E501

        :return: The name of this RoleBinding.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this RoleBinding.

        name of RoleBinding or ClusterRoleBinding  # noqa: E501

        :param name: The name of this RoleBinding.
        :type name: str
        """

        self._name = name

    @property
    def kind(self):
        """Gets the kind of this RoleBinding.

        kind of RoleBinding, value supports RoleBinding and ClusterRoleBinding. RoleBinding is default.  # noqa: E501

        :return: The kind of this RoleBinding.
        :rtype: str
        """
        return self._kind

    @kind.setter
    def kind(self, kind):
        """Sets the kind of this RoleBinding.

        kind of RoleBinding, value supports RoleBinding and ClusterRoleBinding. RoleBinding is default.  # noqa: E501

        :param kind: The kind of this RoleBinding.
        :type kind: str
        """
        allowed_values = ["RoleBinding", "ClusterRoleBinding"]  # noqa: E501
        if kind not in allowed_values:
            raise ValueError(
                "Invalid value for `kind` ({0}), must be one of {1}"
                .format(kind, allowed_values)
            )

        self._kind = kind

    @property
    def namespace(self):
        """Gets the namespace of this RoleBinding.

        namespace of RoleBinding or ClusterRoleBinding  # noqa: E501

        :return: The namespace of this RoleBinding.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this RoleBinding.

        namespace of RoleBinding or ClusterRoleBinding  # noqa: E501

        :param namespace: The namespace of this RoleBinding.
        :type namespace: str
        """

        self._namespace = namespace

    @property
    def labels(self):
        """Gets the labels of this RoleBinding.

        Map of string keys and values that can be used to organize and categorize (scope and select) objects  # noqa: E501

        :return: The labels of this RoleBinding.
        :rtype: List[str]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this RoleBinding.

        Map of string keys and values that can be used to organize and categorize (scope and select) objects  # noqa: E501

        :param labels: The labels of this RoleBinding.
        :type labels: List[str]
        """

        self._labels = labels

    @property
    def role_ref(self):
        """Gets the role_ref of this RoleBinding.


        :return: The role_ref of this RoleBinding.
        :rtype: RBACRoleRef
        """
        return self._role_ref

    @role_ref.setter
    def role_ref(self, role_ref):
        """Sets the role_ref of this RoleBinding.


        :param role_ref: The role_ref of this RoleBinding.
        :type role_ref: RBACRoleRef
        """

        self._role_ref = role_ref

    @property
    def subjects(self):
        """Gets the subjects of this RoleBinding.


        :return: The subjects of this RoleBinding.
        :rtype: List[RoleBindingSubject]
        """
        return self._subjects

    @subjects.setter
    def subjects(self, subjects):
        """Sets the subjects of this RoleBinding.


        :param subjects: The subjects of this RoleBinding.
        :type subjects: List[RoleBindingSubject]
        """

        self._subjects = subjects
