# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class Secret(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, labels=None, annotations=None, files=None):  # noqa: E501
        """Secret - a model defined in OpenAPI

        :param name: The name of this Secret.  # noqa: E501
        :type name: str
        :param labels: The labels of this Secret.  # noqa: E501
        :type labels: List[str]
        :param annotations: The annotations of this Secret.  # noqa: E501
        :type annotations: List[str]
        :param files: The files of this Secret.  # noqa: E501
        :type files: List[str]
        """
        self.openapi_types = {
            'name': str,
            'labels': List[str],
            'annotations': List[str],
            'files': List[str]
        }

        self.attribute_map = {
            'name': 'name',
            'labels': 'labels',
            'annotations': 'annotations',
            'files': 'files'
        }

        self._name = name
        self._labels = labels
        self._annotations = annotations
        self._files = files

    @classmethod
    def from_dict(cls, dikt) -> 'Secret':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Secret of this Secret.  # noqa: E501
        :rtype: Secret
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this Secret.

        The name of secret.  # noqa: E501

        :return: The name of this Secret.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Secret.

        The name of secret.  # noqa: E501

        :param name: The name of this Secret.
        :type name: str
        """

        self._name = name

    @property
    def labels(self):
        """Gets the labels of this Secret.

        Map of string keys and values that can be used to organize and categorize (scope and select) objects  # noqa: E501

        :return: The labels of this Secret.
        :rtype: List[str]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this Secret.

        Map of string keys and values that can be used to organize and categorize (scope and select) objects  # noqa: E501

        :param labels: The labels of this Secret.
        :type labels: List[str]
        """

        self._labels = labels

    @property
    def annotations(self):
        """Gets the annotations of this Secret.

        An unstructured key value map that can be used to attach arbitrary metadata  # noqa: E501

        :return: The annotations of this Secret.
        :rtype: List[str]
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations):
        """Sets the annotations of this Secret.

        An unstructured key value map that can be used to attach arbitrary metadata  # noqa: E501

        :param annotations: The annotations of this Secret.
        :type annotations: List[str]
        """

        self._annotations = annotations

    @property
    def files(self):
        """Gets the files of this Secret.

        The list of secret file paths. If the path is a directory, all files under the directory will be selected.  # noqa: E501

        :return: The files of this Secret.
        :rtype: List[str]
        """
        return self._files

    @files.setter
    def files(self, files):
        """Sets the files of this Secret.

        The list of secret file paths. If the path is a directory, all files under the directory will be selected.  # noqa: E501

        :param files: The files of this Secret.
        :type files: List[str]
        """

        self._files = files
