# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server.models.service_port import ServicePort
from openapi_server import util

from openapi_server.models.service_port import ServicePort  # noqa: E501

class Service(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, namespace=None, annotations=None, labels=None, selector=None, service_type=None, ports=None, cluster_ip=None, external_ips=None):  # noqa: E501
        """Service - a model defined in OpenAPI

        :param name: The name of this Service.  # noqa: E501
        :type name: str
        :param namespace: The namespace of this Service.  # noqa: E501
        :type namespace: str
        :param annotations: The annotations of this Service.  # noqa: E501
        :type annotations: List[str]
        :param labels: The labels of this Service.  # noqa: E501
        :type labels: List[str]
        :param selector: The selector of this Service.  # noqa: E501
        :type selector: List[str]
        :param service_type: The service_type of this Service.  # noqa: E501
        :type service_type: str
        :param ports: The ports of this Service.  # noqa: E501
        :type ports: List[ServicePort]
        :param cluster_ip: The cluster_ip of this Service.  # noqa: E501
        :type cluster_ip: str
        :param external_ips: The external_ips of this Service.  # noqa: E501
        :type external_ips: List[str]
        """
        self.openapi_types = {
            'name': str,
            'namespace': str,
            'annotations': List[str],
            'labels': List[str],
            'selector': List[str],
            'service_type': str,
            'ports': List[ServicePort],
            'cluster_ip': str,
            'external_ips': List[str]
        }

        self.attribute_map = {
            'name': 'name',
            'namespace': 'namespace',
            'annotations': 'annotations',
            'labels': 'labels',
            'selector': 'selector',
            'service_type': 'service_type',
            'ports': 'ports',
            'cluster_ip': 'cluster_ip',
            'external_ips': 'external_ips'
        }

        self._name = name
        self._namespace = namespace
        self._annotations = annotations
        self._labels = labels
        self._selector = selector
        self._service_type = service_type
        self._ports = ports
        self._cluster_ip = cluster_ip
        self._external_ips = external_ips

    @classmethod
    def from_dict(cls, dikt) -> 'Service':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Service of this Service.  # noqa: E501
        :rtype: Service
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this Service.

        service name  # noqa: E501

        :return: The name of this Service.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Service.

        service name  # noqa: E501

        :param name: The name of this Service.
        :type name: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def namespace(self):
        """Gets the namespace of this Service.

        namespace for resource.  # noqa: E501

        :return: The namespace of this Service.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this Service.

        namespace for resource.  # noqa: E501

        :param namespace: The namespace of this Service.
        :type namespace: str
        """

        self._namespace = namespace

    @property
    def annotations(self):
        """Gets the annotations of this Service.

        An unstructured key value map that can be used to attach arbitrary metadata  # noqa: E501

        :return: The annotations of this Service.
        :rtype: List[str]
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations):
        """Sets the annotations of this Service.

        An unstructured key value map that can be used to attach arbitrary metadata  # noqa: E501

        :param annotations: The annotations of this Service.
        :type annotations: List[str]
        """

        self._annotations = annotations

    @property
    def labels(self):
        """Gets the labels of this Service.

        Map of string keys and values that can be used to organize and categorize (scope and select) objects  # noqa: E501

        :return: The labels of this Service.
        :rtype: List[str]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this Service.

        Map of string keys and values that can be used to organize and categorize (scope and select) objects  # noqa: E501

        :param labels: The labels of this Service.
        :type labels: List[str]
        """

        self._labels = labels

    @property
    def selector(self):
        """Gets the selector of this Service.

        An array of label selector rule, the rule can either be a match label or match expression, referring the example (first is a match label, second is a match expression)   # noqa: E501

        :return: The selector of this Service.
        :rtype: List[str]
        """
        return self._selector

    @selector.setter
    def selector(self, selector):
        """Sets the selector of this Service.

        An array of label selector rule, the rule can either be a match label or match expression, referring the example (first is a match label, second is a match expression)   # noqa: E501

        :param selector: The selector of this Service.
        :type selector: List[str]
        """

        self._selector = selector

    @property
    def service_type(self):
        """Gets the service_type of this Service.


        :return: The service_type of this Service.
        :rtype: str
        """
        return self._service_type

    @service_type.setter
    def service_type(self, service_type):
        """Sets the service_type of this Service.


        :param service_type: The service_type of this Service.
        :type service_type: str
        """
        allowed_values = ["ClusterIP", "NodePort", "LoadBalancer"]  # noqa: E501
        if service_type not in allowed_values:
            raise ValueError(
                "Invalid value for `service_type` ({0}), must be one of {1}"
                .format(service_type, allowed_values)
            )

        self._service_type = service_type

    @property
    def ports(self):
        """Gets the ports of this Service.


        :return: The ports of this Service.
        :rtype: List[ServicePort]
        """
        return self._ports

    @ports.setter
    def ports(self, ports):
        """Sets the ports of this Service.


        :param ports: The ports of this Service.
        :type ports: List[ServicePort]
        """

        self._ports = ports

    @property
    def cluster_ip(self):
        """Gets the cluster_ip of this Service.

        Exposes the Service on a cluster-internal IP.  # noqa: E501

        :return: The cluster_ip of this Service.
        :rtype: str
        """
        return self._cluster_ip

    @cluster_ip.setter
    def cluster_ip(self, cluster_ip):
        """Sets the cluster_ip of this Service.

        Exposes the Service on a cluster-internal IP.  # noqa: E501

        :param cluster_ip: The cluster_ip of this Service.
        :type cluster_ip: str
        """

        self._cluster_ip = cluster_ip

    @property
    def external_ips(self):
        """Gets the external_ips of this Service.

        A list of IP addresses for which nodes in the cluster will also accept traffic for this service  # noqa: E501

        :return: The external_ips of this Service.
        :rtype: List[str]
        """
        return self._external_ips

    @external_ips.setter
    def external_ips(self, external_ips):
        """Sets the external_ips of this Service.

        A list of IP addresses for which nodes in the cluster will also accept traffic for this service  # noqa: E501

        :param external_ips: The external_ips of this Service.
        :type external_ips: List[str]
        """

        self._external_ips = external_ips
