# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server.models.endpoint import Endpoint
from openapi_server.models.service_monitor_namespace_selector import ServiceMonitorNamespaceSelector
from openapi_server import util

from openapi_server.models.endpoint import Endpoint  # noqa: E501
from openapi_server.models.service_monitor_namespace_selector import ServiceMonitorNamespaceSelector  # noqa: E501

class ServiceMonitor(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, namespace=None, labels=None, annotations=None, endpoints=None, selector=None, namespace_selector=None):  # noqa: E501
        """ServiceMonitor - a model defined in OpenAPI

        :param name: The name of this ServiceMonitor.  # noqa: E501
        :type name: str
        :param namespace: The namespace of this ServiceMonitor.  # noqa: E501
        :type namespace: str
        :param labels: The labels of this ServiceMonitor.  # noqa: E501
        :type labels: List[str]
        :param annotations: The annotations of this ServiceMonitor.  # noqa: E501
        :type annotations: List[str]
        :param endpoints: The endpoints of this ServiceMonitor.  # noqa: E501
        :type endpoints: List[Endpoint]
        :param selector: The selector of this ServiceMonitor.  # noqa: E501
        :type selector: List[str]
        :param namespace_selector: The namespace_selector of this ServiceMonitor.  # noqa: E501
        :type namespace_selector: ServiceMonitorNamespaceSelector
        """
        self.openapi_types = {
            'name': str,
            'namespace': str,
            'labels': List[str],
            'annotations': List[str],
            'endpoints': List[Endpoint],
            'selector': List[str],
            'namespace_selector': ServiceMonitorNamespaceSelector
        }

        self.attribute_map = {
            'name': 'name',
            'namespace': 'namespace',
            'labels': 'labels',
            'annotations': 'annotations',
            'endpoints': 'endpoints',
            'selector': 'selector',
            'namespace_selector': 'namespace_selector'
        }

        self._name = name
        self._namespace = namespace
        self._labels = labels
        self._annotations = annotations
        self._endpoints = endpoints
        self._selector = selector
        self._namespace_selector = namespace_selector

    @classmethod
    def from_dict(cls, dikt) -> 'ServiceMonitor':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ServiceMonitor of this ServiceMonitor.  # noqa: E501
        :rtype: ServiceMonitor
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this ServiceMonitor.

        name of service monitor, used in metadata.name  # noqa: E501

        :return: The name of this ServiceMonitor.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ServiceMonitor.

        name of service monitor, used in metadata.name  # noqa: E501

        :param name: The name of this ServiceMonitor.
        :type name: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def namespace(self):
        """Gets the namespace of this ServiceMonitor.

        namespace for resource.  # noqa: E501

        :return: The namespace of this ServiceMonitor.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this ServiceMonitor.

        namespace for resource.  # noqa: E501

        :param namespace: The namespace of this ServiceMonitor.
        :type namespace: str
        """

        self._namespace = namespace

    @property
    def labels(self):
        """Gets the labels of this ServiceMonitor.

        Map of string keys and values that can be used to organize and categorize (scope and select) objects  # noqa: E501

        :return: The labels of this ServiceMonitor.
        :rtype: List[str]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this ServiceMonitor.

        Map of string keys and values that can be used to organize and categorize (scope and select) objects  # noqa: E501

        :param labels: The labels of this ServiceMonitor.
        :type labels: List[str]
        """

        self._labels = labels

    @property
    def annotations(self):
        """Gets the annotations of this ServiceMonitor.

        An unstructured key value map that can be used to attach arbitrary metadata  # noqa: E501

        :return: The annotations of this ServiceMonitor.
        :rtype: List[str]
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations):
        """Sets the annotations of this ServiceMonitor.

        An unstructured key value map that can be used to attach arbitrary metadata  # noqa: E501

        :param annotations: The annotations of this ServiceMonitor.
        :type annotations: List[str]
        """

        self._annotations = annotations

    @property
    def endpoints(self):
        """Gets the endpoints of this ServiceMonitor.


        :return: The endpoints of this ServiceMonitor.
        :rtype: List[Endpoint]
        """
        return self._endpoints

    @endpoints.setter
    def endpoints(self, endpoints):
        """Sets the endpoints of this ServiceMonitor.


        :param endpoints: The endpoints of this ServiceMonitor.
        :type endpoints: List[Endpoint]
        """

        self._endpoints = endpoints

    @property
    def selector(self):
        """Gets the selector of this ServiceMonitor.

        An array of label selector rule, the rule can either be a match label or match expression, referring the example (first is a match label, second is a match expression)   # noqa: E501

        :return: The selector of this ServiceMonitor.
        :rtype: List[str]
        """
        return self._selector

    @selector.setter
    def selector(self, selector):
        """Sets the selector of this ServiceMonitor.

        An array of label selector rule, the rule can either be a match label or match expression, referring the example (first is a match label, second is a match expression)   # noqa: E501

        :param selector: The selector of this ServiceMonitor.
        :type selector: List[str]
        """

        self._selector = selector

    @property
    def namespace_selector(self):
        """Gets the namespace_selector of this ServiceMonitor.


        :return: The namespace_selector of this ServiceMonitor.
        :rtype: ServiceMonitorNamespaceSelector
        """
        return self._namespace_selector

    @namespace_selector.setter
    def namespace_selector(self, namespace_selector):
        """Sets the namespace_selector of this ServiceMonitor.


        :param namespace_selector: The namespace_selector of this ServiceMonitor.
        :type namespace_selector: ServiceMonitorNamespaceSelector
        """

        self._namespace_selector = namespace_selector
