# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class ServicePort(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, port=None, target_port=None, node_port=None, protocol=None):  # noqa: E501
        """ServicePort - a model defined in OpenAPI

        :param name: The name of this ServicePort.  # noqa: E501
        :type name: str
        :param port: The port of this ServicePort.  # noqa: E501
        :type port: int
        :param target_port: The target_port of this ServicePort.  # noqa: E501
        :type target_port: int
        :param node_port: The node_port of this ServicePort.  # noqa: E501
        :type node_port: int
        :param protocol: The protocol of this ServicePort.  # noqa: E501
        :type protocol: str
        """
        self.openapi_types = {
            'name': str,
            'port': int,
            'target_port': int,
            'node_port': int,
            'protocol': str
        }

        self.attribute_map = {
            'name': 'name',
            'port': 'port',
            'target_port': 'target_port',
            'node_port': 'node_port',
            'protocol': 'protocol'
        }

        self._name = name
        self._port = port
        self._target_port = target_port
        self._node_port = node_port
        self._protocol = protocol

    @classmethod
    def from_dict(cls, dikt) -> 'ServicePort':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ServicePort of this ServicePort.  # noqa: E501
        :rtype: ServicePort
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this ServicePort.

        The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names   # noqa: E501

        :return: The name of this ServicePort.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ServicePort.

        The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names   # noqa: E501

        :param name: The name of this ServicePort.
        :type name: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def port(self):
        """Gets the port of this ServicePort.

        The port that will be exposed by this service  # noqa: E501

        :return: The port of this ServicePort.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this ServicePort.

        The port that will be exposed by this service  # noqa: E501

        :param port: The port of this ServicePort.
        :type port: int
        """

        self._port = port

    @property
    def target_port(self):
        """Gets the target_port of this ServicePort.

        The port to access on the pods targeted by the service  # noqa: E501

        :return: The target_port of this ServicePort.
        :rtype: int
        """
        return self._target_port

    @target_port.setter
    def target_port(self, target_port):
        """Sets the target_port of this ServicePort.

        The port to access on the pods targeted by the service  # noqa: E501

        :param target_port: The target_port of this ServicePort.
        :type target_port: int
        """

        self._target_port = target_port

    @property
    def node_port(self):
        """Gets the node_port of this ServicePort.

        The port on each node on which this service is exposed when type is NodePort or LoadBalancer  # noqa: E501

        :return: The node_port of this ServicePort.
        :rtype: int
        """
        return self._node_port

    @node_port.setter
    def node_port(self, node_port):
        """Sets the node_port of this ServicePort.

        The port on each node on which this service is exposed when type is NodePort or LoadBalancer  # noqa: E501

        :param node_port: The node_port of this ServicePort.
        :type node_port: int
        """

        self._node_port = node_port

    @property
    def protocol(self):
        """Gets the protocol of this ServicePort.

        Defaults to TCP  # noqa: E501

        :return: The protocol of this ServicePort.
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this ServicePort.

        Defaults to TCP  # noqa: E501

        :param protocol: The protocol of this ServicePort.
        :type protocol: str
        """
        allowed_values = ["TCP", "UDP"]  # noqa: E501
        if protocol not in allowed_values:
            raise ValueError(
                "Invalid value for `protocol` ({0}), must be one of {1}"
                .format(protocol, allowed_values)
            )

        self._protocol = protocol
