# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class TopologySpreadConstraint(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, label_selector=None, max_skew=None, topology_key=None, when_unsatisfiable=None):  # noqa: E501
        """TopologySpreadConstraint - a model defined in OpenAPI

        :param label_selector: The label_selector of this TopologySpreadConstraint.  # noqa: E501
        :type label_selector: List[str]
        :param max_skew: The max_skew of this TopologySpreadConstraint.  # noqa: E501
        :type max_skew: int
        :param topology_key: The topology_key of this TopologySpreadConstraint.  # noqa: E501
        :type topology_key: str
        :param when_unsatisfiable: The when_unsatisfiable of this TopologySpreadConstraint.  # noqa: E501
        :type when_unsatisfiable: str
        """
        self.openapi_types = {
            'label_selector': List[str],
            'max_skew': int,
            'topology_key': str,
            'when_unsatisfiable': str
        }

        self.attribute_map = {
            'label_selector': 'label_selector',
            'max_skew': 'max_skew',
            'topology_key': 'topologyKey',
            'when_unsatisfiable': 'when_unsatisfiable'
        }

        self._label_selector = label_selector
        self._max_skew = max_skew
        self._topology_key = topology_key
        self._when_unsatisfiable = when_unsatisfiable

    @classmethod
    def from_dict(cls, dikt) -> 'TopologySpreadConstraint':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The TopologySpreadConstraint of this TopologySpreadConstraint.  # noqa: E501
        :rtype: TopologySpreadConstraint
        """
        return util.deserialize_model(dikt, cls)

    @property
    def label_selector(self):
        """Gets the label_selector of this TopologySpreadConstraint.

        An array of label selector rule, the rule can either be a match label or match expression, referring the example (first is a match label, second is a match expression)   # noqa: E501

        :return: The label_selector of this TopologySpreadConstraint.
        :rtype: List[str]
        """
        return self._label_selector

    @label_selector.setter
    def label_selector(self, label_selector):
        """Sets the label_selector of this TopologySpreadConstraint.

        An array of label selector rule, the rule can either be a match label or match expression, referring the example (first is a match label, second is a match expression)   # noqa: E501

        :param label_selector: The label_selector of this TopologySpreadConstraint.
        :type label_selector: List[str]
        """

        self._label_selector = label_selector

    @property
    def max_skew(self):
        """Gets the max_skew of this TopologySpreadConstraint.

        describes the degree to which Pods may be unevenly distributed. You must specify this field and the number must be greater than zero.  # noqa: E501

        :return: The max_skew of this TopologySpreadConstraint.
        :rtype: int
        """
        return self._max_skew

    @max_skew.setter
    def max_skew(self, max_skew):
        """Sets the max_skew of this TopologySpreadConstraint.

        describes the degree to which Pods may be unevenly distributed. You must specify this field and the number must be greater than zero.  # noqa: E501

        :param max_skew: The max_skew of this TopologySpreadConstraint.
        :type max_skew: int
        """

        self._max_skew = max_skew

    @property
    def topology_key(self):
        """Gets the topology_key of this TopologySpreadConstraint.

        the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology.  # noqa: E501

        :return: The topology_key of this TopologySpreadConstraint.
        :rtype: str
        """
        return self._topology_key

    @topology_key.setter
    def topology_key(self, topology_key):
        """Sets the topology_key of this TopologySpreadConstraint.

        the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology.  # noqa: E501

        :param topology_key: The topology_key of this TopologySpreadConstraint.
        :type topology_key: str
        """

        self._topology_key = topology_key

    @property
    def when_unsatisfiable(self):
        """Gets the when_unsatisfiable of this TopologySpreadConstraint.

        indicates how to deal with a Pod if it doesn't satisfy the spread constraint. Default is DoNotSchedule.  # noqa: E501

        :return: The when_unsatisfiable of this TopologySpreadConstraint.
        :rtype: str
        """
        return self._when_unsatisfiable

    @when_unsatisfiable.setter
    def when_unsatisfiable(self, when_unsatisfiable):
        """Sets the when_unsatisfiable of this TopologySpreadConstraint.

        indicates how to deal with a Pod if it doesn't satisfy the spread constraint. Default is DoNotSchedule.  # noqa: E501

        :param when_unsatisfiable: The when_unsatisfiable of this TopologySpreadConstraint.
        :type when_unsatisfiable: str
        """
        allowed_values = ["DoNotSchedule", "ScheduleAnyway"]  # noqa: E501
        if when_unsatisfiable not in allowed_values:
            raise ValueError(
                "Invalid value for `when_unsatisfiable` ({0}), must be one of {1}"
                .format(when_unsatisfiable, allowed_values)
            )

        self._when_unsatisfiable = when_unsatisfiable
