# coding: utf-8

from __future__ import absolute_import
import unittest

from flask import json
from six import BytesIO

from openapi_server.models.deploy_platform_resource import DeployPlatformResource  # noqa: E501
from openapi_server.models.deploy_resources import DeployResources  # noqa: E501
from openapi_server.models.dingman_error import DingmanError  # noqa: E501
from openapi_server.models.dingman_response import DingmanResponse  # noqa: E501
from openapi_server.test import BaseTestCase


class TestDeployResourcesController(BaseTestCase):
    """DeployResourcesController integration test stubs"""

    def test_get_deploy_platform_resource_by_pop(self):
        """Test case for get_deploy_platform_resource_by_pop

        Get DeployPlatformResources under an app service for the specific pop
        """
        headers = { 
            'Accept': 'application/json',
            'Authorization': 'Bearer special-key',
        }
        response = self.client.open(
            '/v1/app-service/{app_service_name}/deploy-platform-resources/{pop_name}'.format(app_service_name='demo-app.gss', pop_name='fra1'),
            method='GET',
            headers=headers)
        self.assert200(response,
                       'Response body is : ' + response.data.decode('utf-8'))

    def test_get_deploy_platform_resources(self):
        """Test case for get_deploy_platform_resources

        Get DeployPlatformResources under an app service for all pops
        """
        headers = { 
            'Accept': 'application/json',
            'Authorization': 'Bearer special-key',
        }
        response = self.client.open(
            '/v1/app-service/{app_service_name}/deploy-platform-resources'.format(app_service_name='demo-app.gss'),
            method='GET',
            headers=headers)
        self.assert200(response,
                       'Response body is : ' + response.data.decode('utf-8'))

    def test_get_deploy_resource_overlays(self):
        """Test case for get_deploy_resource_overlays

        Get DeployResourceOverlays for an app service
        """
        headers = { 
            'Accept': 'application/json',
            'Authorization': 'Bearer special-key',
        }
        response = self.client.open(
            '/v1/app-service/{app_service_name}/deploy-resource-overlays'.format(app_service_name='demo-app.gss'),
            method='GET',
            headers=headers)
        self.assert200(response,
                       'Response body is : ' + response.data.decode('utf-8'))

    def test_get_deploy_resources(self):
        """Test case for get_deploy_resources

        Get DeployResources under an app service
        """
        headers = { 
            'Accept': 'application/json',
            'Authorization': 'Bearer special-key',
        }
        response = self.client.open(
            '/v1/app-service/{app_service_name}/deploy-resources'.format(app_service_name='demo-app.gss'),
            method='GET',
            headers=headers)
        self.assert200(response,
                       'Response body is : ' + response.data.decode('utf-8'))

    def test_get_deploy_resources_by_pop(self):
        """Test case for get_deploy_resources_by_pop

        Get DeployResources under an app service for the specified pop
        """
        headers = { 
            'Accept': 'application/json',
            'Authorization': 'Bearer special-key',
        }
        response = self.client.open(
            '/v1/app-service/{app_service_name}/deploy-resources/{pop_name}'.format(app_service_name='demo-app.gss', pop_name='fra1'),
            method='GET',
            headers=headers)
        self.assert200(response,
                       'Response body is : ' + response.data.decode('utf-8'))

    def test_patch_deploy_resource_overlays(self):
        """Test case for patch_deploy_resource_overlays

        Patch DeployResourceOverlays under an app service
        """
        request_body = {"configs":[{"templates":[{"values":{"key1":"value1"},"name":"conf/server.conf"},{"values":{"key1":"value1"},"name":"conf/server.conf"}],"name":"server-conf","annotations":["annotation-key1:val1","annotation-key2:val2"],"files":["conf/server.conf"],"labels":["app:demo-app","version:v1.0.0"]},{"templates":[{"values":{"key1":"value1"},"name":"conf/server.conf"},{"values":{"key1":"value1"},"name":"conf/server.conf"}],"name":"server-conf","annotations":["annotation-key1:val1","annotation-key2:val2"],"files":["conf/server.conf"],"labels":["app:demo-app","version:v1.0.0"]}],"persistent_volume_claims":[{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]},{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]}],"ingress":[{"name":"demo-app-ingress","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"rules":[{"paths":[{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}},{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}}],"name":"foo-ingress-rule","host":"www.foo.com"},{"paths":[{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}},{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}}],"name":"foo-ingress-rule","host":"www.foo.com"}],"tls":[{"secret_name":"app-secret","hosts":["www.foo.com","www.bar.com"],"name":"foo-bar-ingress"},{"secret_name":"app-secret","hosts":["www.foo.com","www.bar.com"],"name":"foo-bar-ingress"}],"labels":["app:demo-app","version:v1.0.0"]},{"name":"demo-app-ingress","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"rules":[{"paths":[{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}},{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}}],"name":"foo-ingress-rule","host":"www.foo.com"},{"paths":[{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}},{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}}],"name":"foo-ingress-rule","host":"www.foo.com"}],"tls":[{"secret_name":"app-secret","hosts":["www.foo.com","www.bar.com"],"name":"foo-bar-ingress"},{"secret_name":"app-secret","hosts":["www.foo.com","www.bar.com"],"name":"foo-bar-ingress"}],"labels":["app:demo-app","version:v1.0.0"]}],"role_bindings":[{"kind":"RoleBinding","subjects":[{"kind":"ServiceAccount","name":"default"},{"kind":"ServiceAccount","name":"default"}],"name":"cm-writer","namespace":"namespace","role_ref":{"kind":"Role","api_group":"rbac.authorization.k8s.io","name":"cm-writer"},"labels":["app:demo-app","version:v1.0.0"]},{"kind":"RoleBinding","subjects":[{"kind":"ServiceAccount","name":"default"},{"kind":"ServiceAccount","name":"default"}],"name":"cm-writer","namespace":"namespace","role_ref":{"kind":"Role","api_group":"rbac.authorization.k8s.io","name":"cm-writer"},"labels":["app:demo-app","version:v1.0.0"]}],"service_monitors":[{"namespace_selector":{"match_names":["default"],"any":True},"endpoints":[{"honor_labels":True,"path":"/metrics","target_port":8080,"relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"metric_relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"scheme":"http","port":8080,"honor_timestamps":True,"scrape_timeout":"10s","interval":"30s","params":{"module":["http_2xx"]}},{"honor_labels":True,"path":"/metrics","target_port":8080,"relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"metric_relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"scheme":"http","port":8080,"honor_timestamps":True,"scrape_timeout":"10s","interval":"30s","params":{"module":["http_2xx"]}}],"name":"my-service-monitor","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"labels":["app:demo-app","version:v1.0.0"]},{"namespace_selector":{"match_names":["default"],"any":True},"endpoints":[{"honor_labels":True,"path":"/metrics","target_port":8080,"relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"metric_relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"scheme":"http","port":8080,"honor_timestamps":True,"scrape_timeout":"10s","interval":"30s","params":{"module":["http_2xx"]}},{"honor_labels":True,"path":"/metrics","target_port":8080,"relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"metric_relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"scheme":"http","port":8080,"honor_timestamps":True,"scrape_timeout":"10s","interval":"30s","params":{"module":["http_2xx"]}}],"name":"my-service-monitor","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"labels":["app:demo-app","version:v1.0.0"]}],"roles":[{"kind":"Role","name":"cm-writer","namespace":"namespace","rules":[{"api_groups":"","resources":"configmaps","verbs":["create","patch","update","get"]},{"api_groups":"","resources":"configmaps","verbs":["create","patch","update","get"]}],"labels":["app:demo-app","version:v1.0.0"]},{"kind":"Role","name":"cm-writer","namespace":"namespace","rules":[{"api_groups":"","resources":"configmaps","verbs":["create","patch","update","get"]},{"api_groups":"","resources":"configmaps","verbs":["create","patch","update","get"]}],"labels":["app:demo-app","version:v1.0.0"]}],"workloads":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"update_strategy":{"strategy_type":"RollingUpdate","rolling_update_config":{"partition":2,"max_unavailable":"10% or 2","max_surge":"10% or 2"}},"pod":{"image_pull_secrets":["image-secret","image-secret"],"dns_policy":"ClusterFirst","restart_policy":"Always","termination_grace_period_seconds":30,"volumes":[{"host_path":{"path":"/data","path_type":"Directory"},"name":"demo-vol","empty_dir":{"medium":"Memory","size_limit":"500Mi"},"config_map":{"name":"server config/secret","optional":False,"default_mode":400},"secret":{"name":"server config/secret","optional":False,"default_mode":400},"persistent_volume_claim":{"read_only":False,"claim_name":"demo-pvc"}},{"host_path":{"path":"/data","path_type":"Directory"},"name":"demo-vol","empty_dir":{"medium":"Memory","size_limit":"500Mi"},"config_map":{"name":"server config/secret","optional":False,"default_mode":400},"secret":{"name":"server config/secret","optional":False,"default_mode":400},"persistent_volume_claim":{"read_only":False,"claim_name":"demo-pvc"}}],"annotations":["annotation-key1:val1","annotation-key2:val2"],"containers":[{"image":"nginx:latest","life_cycle":{"pre_stop":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]},"post_start":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]}},"resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"volume_mounts":[{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"},{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"}],"env":{"name":"SMS_KEYS_PATH_XM","value":"dms-secret"},"ports":[{"container_port":80,"protocol":"TCP","name":"http"},{"container_port":80,"protocol":"TCP","name":"http"}],"command":["python3"],"args":["-m","openapi_server"],"readiness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"env_from":"Regular","startup_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"image_pull_policy":"IfNotPresent","volume_devices":[{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4},{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4}],"name":"http-server","container_type":"Init","liveness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"security_context":{"capabilities":{"add":["NET_ADMIN","SYS_TIME"],"drop":["NET_ADMIN","SYS_TIME"]},"run_as_group":3000,"run_as_user":1000}},{"image":"nginx:latest","life_cycle":{"pre_stop":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]},"post_start":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]}},"resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"volume_mounts":[{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"},{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"}],"env":{"name":"SMS_KEYS_PATH_XM","value":"dms-secret"},"ports":[{"container_port":80,"protocol":"TCP","name":"http"},{"container_port":80,"protocol":"TCP","name":"http"}],"command":["python3"],"args":["-m","openapi_server"],"readiness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"env_from":"Regular","startup_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"image_pull_policy":"IfNotPresent","volume_devices":[{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4},{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4}],"name":"http-server","container_type":"Init","liveness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"security_context":{"capabilities":{"add":["NET_ADMIN","SYS_TIME"],"drop":["NET_ADMIN","SYS_TIME"]},"run_as_group":3000,"run_as_user":1000}}],"topology_spread_constraints":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"when_unsatisfiable":"ScheduleAnyway","max_skew":1,"topologyKey":"kubernetes.io/hostname"},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"when_unsatisfiable":"ScheduleAnyway","max_skew":1,"topologyKey":"kubernetes.io/hostname"}],"scheduler_name":"default-scheduler","security_context":{"run_as_group":3000,"run_as_user":1000,"sysctls":[{"name":"net.ipv4.ping_group_range","value":"0 2147483647"},{"name":"net.ipv4.ping_group_range","value":"0 2147483647"}]},"labels":["app:demo-app","version:v1.0.0"],"affinity":{"pod_anti_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}},{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}}],"required_during_scheduling_ignored_during_execution":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}]},"node_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"preference":{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},"weight":0},{"preference":{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},"weight":0}],"required_during_scheduling_ignored_during_execution":{"node_selector_terms":[{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]}]}},"pod_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}},{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}}],"required_during_scheduling_ignored_during_execution":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}]}}},"revision_history_limit":3,"replicas":1,"service_name":"demo-app","name":"demo-app","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_claim_templates":[{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]},{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]}],"workload_type":"Deployment","labels":["app:demo-app","version:v1.0.0"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"update_strategy":{"strategy_type":"RollingUpdate","rolling_update_config":{"partition":2,"max_unavailable":"10% or 2","max_surge":"10% or 2"}},"pod":{"image_pull_secrets":["image-secret","image-secret"],"dns_policy":"ClusterFirst","restart_policy":"Always","termination_grace_period_seconds":30,"volumes":[{"host_path":{"path":"/data","path_type":"Directory"},"name":"demo-vol","empty_dir":{"medium":"Memory","size_limit":"500Mi"},"config_map":{"name":"server config/secret","optional":False,"default_mode":400},"secret":{"name":"server config/secret","optional":False,"default_mode":400},"persistent_volume_claim":{"read_only":False,"claim_name":"demo-pvc"}},{"host_path":{"path":"/data","path_type":"Directory"},"name":"demo-vol","empty_dir":{"medium":"Memory","size_limit":"500Mi"},"config_map":{"name":"server config/secret","optional":False,"default_mode":400},"secret":{"name":"server config/secret","optional":False,"default_mode":400},"persistent_volume_claim":{"read_only":False,"claim_name":"demo-pvc"}}],"annotations":["annotation-key1:val1","annotation-key2:val2"],"containers":[{"image":"nginx:latest","life_cycle":{"pre_stop":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]},"post_start":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]}},"resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"volume_mounts":[{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"},{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"}],"env":{"name":"SMS_KEYS_PATH_XM","value":"dms-secret"},"ports":[{"container_port":80,"protocol":"TCP","name":"http"},{"container_port":80,"protocol":"TCP","name":"http"}],"command":["python3"],"args":["-m","openapi_server"],"readiness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"env_from":"Regular","startup_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"image_pull_policy":"IfNotPresent","volume_devices":[{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4},{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4}],"name":"http-server","container_type":"Init","liveness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"security_context":{"capabilities":{"add":["NET_ADMIN","SYS_TIME"],"drop":["NET_ADMIN","SYS_TIME"]},"run_as_group":3000,"run_as_user":1000}},{"image":"nginx:latest","life_cycle":{"pre_stop":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]},"post_start":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]}},"resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"volume_mounts":[{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"},{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"}],"env":{"name":"SMS_KEYS_PATH_XM","value":"dms-secret"},"ports":[{"container_port":80,"protocol":"TCP","name":"http"},{"container_port":80,"protocol":"TCP","name":"http"}],"command":["python3"],"args":["-m","openapi_server"],"readiness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"env_from":"Regular","startup_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"image_pull_policy":"IfNotPresent","volume_devices":[{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4},{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4}],"name":"http-server","container_type":"Init","liveness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"security_context":{"capabilities":{"add":["NET_ADMIN","SYS_TIME"],"drop":["NET_ADMIN","SYS_TIME"]},"run_as_group":3000,"run_as_user":1000}}],"topology_spread_constraints":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"when_unsatisfiable":"ScheduleAnyway","max_skew":1,"topologyKey":"kubernetes.io/hostname"},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"when_unsatisfiable":"ScheduleAnyway","max_skew":1,"topologyKey":"kubernetes.io/hostname"}],"scheduler_name":"default-scheduler","security_context":{"run_as_group":3000,"run_as_user":1000,"sysctls":[{"name":"net.ipv4.ping_group_range","value":"0 2147483647"},{"name":"net.ipv4.ping_group_range","value":"0 2147483647"}]},"labels":["app:demo-app","version:v1.0.0"],"affinity":{"pod_anti_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}},{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}}],"required_during_scheduling_ignored_during_execution":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}]},"node_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"preference":{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},"weight":0},{"preference":{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},"weight":0}],"required_during_scheduling_ignored_during_execution":{"node_selector_terms":[{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]}]}},"pod_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}},{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}}],"required_during_scheduling_ignored_during_execution":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}]}}},"revision_history_limit":3,"replicas":1,"service_name":"demo-app","name":"demo-app","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_claim_templates":[{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]},{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]}],"workload_type":"Deployment","labels":["app:demo-app","version:v1.0.0"]}],"services":[{"external_ips":["1.1.1.1","2.2.2.2"],"service_type":"ClusterIP","name":"demo-app","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"ports":[{"target_port":8080,"protocol":"TCP","port":80,"name":"http","node_port":6500},{"target_port":8080,"protocol":"TCP","port":80,"name":"http","node_port":6500}],"cluster_ip":"cluster_ip","labels":["app:demo-app","version:v1.0.0"]},{"external_ips":["1.1.1.1","2.2.2.2"],"service_type":"ClusterIP","name":"demo-app","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"ports":[{"target_port":8080,"protocol":"TCP","port":80,"name":"http","node_port":6500},{"target_port":8080,"protocol":"TCP","port":80,"name":"http","node_port":6500}],"cluster_ip":"cluster_ip","labels":["app:demo-app","version:v1.0.0"]}],"secrets":[{"name":"dingman-secret","annotations":["annotation-key1:val1","annotation-key2:val2"],"files":["cert/test-domain.crt","cert/cdn-dsa"],"labels":["app:demo-app","version:v1.0.0"]},{"name":"dingman-secret","annotations":["annotation-key1:val1","annotation-key2:val2"],"files":["cert/test-domain.crt","cert/cdn-dsa"],"labels":["app:demo-app","version:v1.0.0"]}]}
        headers = { 
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': 'Bearer special-key',
        }
        response = self.client.open(
            '/v1/app-service/{app_service_name}/deploy-resource-overlays'.format(app_service_name='demo-app.gss'),
            method='PATCH',
            headers=headers,
            data=json.dumps(request_body),
            content_type='application/json')
        self.assert200(response,
                       'Response body is : ' + response.data.decode('utf-8'))

    def test_patch_deploy_resources(self):
        """Test case for patch_deploy_resources

        Patch DeployResources under an app service
        """
        deploy_resources = {"configs":[{"templates":[{"values":{"key1":"value1"},"name":"conf/server.conf"},{"values":{"key1":"value1"},"name":"conf/server.conf"}],"name":"server-conf","annotations":["annotation-key1:val1","annotation-key2:val2"],"files":["conf/server.conf"],"labels":["app:demo-app","version:v1.0.0"]},{"templates":[{"values":{"key1":"value1"},"name":"conf/server.conf"},{"values":{"key1":"value1"},"name":"conf/server.conf"}],"name":"server-conf","annotations":["annotation-key1:val1","annotation-key2:val2"],"files":["conf/server.conf"],"labels":["app:demo-app","version:v1.0.0"]}],"persistent_volume_claims":[{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]},{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]}],"ingress":[{"name":"demo-app-ingress","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"rules":[{"paths":[{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}},{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}}],"name":"foo-ingress-rule","host":"www.foo.com"},{"paths":[{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}},{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}}],"name":"foo-ingress-rule","host":"www.foo.com"}],"tls":[{"secret_name":"app-secret","hosts":["www.foo.com","www.bar.com"],"name":"foo-bar-ingress"},{"secret_name":"app-secret","hosts":["www.foo.com","www.bar.com"],"name":"foo-bar-ingress"}],"labels":["app:demo-app","version:v1.0.0"]},{"name":"demo-app-ingress","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"rules":[{"paths":[{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}},{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}}],"name":"foo-ingress-rule","host":"www.foo.com"},{"paths":[{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}},{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}}],"name":"foo-ingress-rule","host":"www.foo.com"}],"tls":[{"secret_name":"app-secret","hosts":["www.foo.com","www.bar.com"],"name":"foo-bar-ingress"},{"secret_name":"app-secret","hosts":["www.foo.com","www.bar.com"],"name":"foo-bar-ingress"}],"labels":["app:demo-app","version:v1.0.0"]}],"role_bindings":[{"kind":"RoleBinding","subjects":[{"kind":"ServiceAccount","name":"default"},{"kind":"ServiceAccount","name":"default"}],"name":"cm-writer","namespace":"namespace","role_ref":{"kind":"Role","api_group":"rbac.authorization.k8s.io","name":"cm-writer"},"labels":["app:demo-app","version:v1.0.0"]},{"kind":"RoleBinding","subjects":[{"kind":"ServiceAccount","name":"default"},{"kind":"ServiceAccount","name":"default"}],"name":"cm-writer","namespace":"namespace","role_ref":{"kind":"Role","api_group":"rbac.authorization.k8s.io","name":"cm-writer"},"labels":["app:demo-app","version:v1.0.0"]}],"service_monitors":[{"namespace_selector":{"match_names":["default"],"any":True},"endpoints":[{"honor_labels":True,"path":"/metrics","target_port":8080,"relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"metric_relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"scheme":"http","port":8080,"honor_timestamps":True,"scrape_timeout":"10s","interval":"30s","params":{"module":["http_2xx"]}},{"honor_labels":True,"path":"/metrics","target_port":8080,"relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"metric_relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"scheme":"http","port":8080,"honor_timestamps":True,"scrape_timeout":"10s","interval":"30s","params":{"module":["http_2xx"]}}],"name":"my-service-monitor","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"labels":["app:demo-app","version:v1.0.0"]},{"namespace_selector":{"match_names":["default"],"any":True},"endpoints":[{"honor_labels":True,"path":"/metrics","target_port":8080,"relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"metric_relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"scheme":"http","port":8080,"honor_timestamps":True,"scrape_timeout":"10s","interval":"30s","params":{"module":["http_2xx"]}},{"honor_labels":True,"path":"/metrics","target_port":8080,"relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"metric_relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"scheme":"http","port":8080,"honor_timestamps":True,"scrape_timeout":"10s","interval":"30s","params":{"module":["http_2xx"]}}],"name":"my-service-monitor","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"labels":["app:demo-app","version:v1.0.0"]}],"roles":[{"kind":"Role","name":"cm-writer","namespace":"namespace","rules":[{"api_groups":"","resources":"configmaps","verbs":["create","patch","update","get"]},{"api_groups":"","resources":"configmaps","verbs":["create","patch","update","get"]}],"labels":["app:demo-app","version:v1.0.0"]},{"kind":"Role","name":"cm-writer","namespace":"namespace","rules":[{"api_groups":"","resources":"configmaps","verbs":["create","patch","update","get"]},{"api_groups":"","resources":"configmaps","verbs":["create","patch","update","get"]}],"labels":["app:demo-app","version:v1.0.0"]}],"workloads":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"update_strategy":{"strategy_type":"RollingUpdate","rolling_update_config":{"partition":2,"max_unavailable":"10% or 2","max_surge":"10% or 2"}},"pod":{"image_pull_secrets":["image-secret","image-secret"],"dns_policy":"ClusterFirst","restart_policy":"Always","termination_grace_period_seconds":30,"volumes":[{"host_path":{"path":"/data","path_type":"Directory"},"name":"demo-vol","empty_dir":{"medium":"Memory","size_limit":"500Mi"},"config_map":{"name":"server config/secret","optional":False,"default_mode":400},"secret":{"name":"server config/secret","optional":False,"default_mode":400},"persistent_volume_claim":{"read_only":False,"claim_name":"demo-pvc"}},{"host_path":{"path":"/data","path_type":"Directory"},"name":"demo-vol","empty_dir":{"medium":"Memory","size_limit":"500Mi"},"config_map":{"name":"server config/secret","optional":False,"default_mode":400},"secret":{"name":"server config/secret","optional":False,"default_mode":400},"persistent_volume_claim":{"read_only":False,"claim_name":"demo-pvc"}}],"annotations":["annotation-key1:val1","annotation-key2:val2"],"containers":[{"image":"nginx:latest","life_cycle":{"pre_stop":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]},"post_start":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]}},"resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"volume_mounts":[{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"},{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"}],"env":{"name":"SMS_KEYS_PATH_XM","value":"dms-secret"},"ports":[{"container_port":80,"protocol":"TCP","name":"http"},{"container_port":80,"protocol":"TCP","name":"http"}],"command":["python3"],"args":["-m","openapi_server"],"readiness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"env_from":"Regular","startup_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"image_pull_policy":"IfNotPresent","volume_devices":[{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4},{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4}],"name":"http-server","container_type":"Init","liveness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"security_context":{"capabilities":{"add":["NET_ADMIN","SYS_TIME"],"drop":["NET_ADMIN","SYS_TIME"]},"run_as_group":3000,"run_as_user":1000}},{"image":"nginx:latest","life_cycle":{"pre_stop":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]},"post_start":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]}},"resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"volume_mounts":[{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"},{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"}],"env":{"name":"SMS_KEYS_PATH_XM","value":"dms-secret"},"ports":[{"container_port":80,"protocol":"TCP","name":"http"},{"container_port":80,"protocol":"TCP","name":"http"}],"command":["python3"],"args":["-m","openapi_server"],"readiness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"env_from":"Regular","startup_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"image_pull_policy":"IfNotPresent","volume_devices":[{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4},{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4}],"name":"http-server","container_type":"Init","liveness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"security_context":{"capabilities":{"add":["NET_ADMIN","SYS_TIME"],"drop":["NET_ADMIN","SYS_TIME"]},"run_as_group":3000,"run_as_user":1000}}],"topology_spread_constraints":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"when_unsatisfiable":"ScheduleAnyway","max_skew":1,"topologyKey":"kubernetes.io/hostname"},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"when_unsatisfiable":"ScheduleAnyway","max_skew":1,"topologyKey":"kubernetes.io/hostname"}],"scheduler_name":"default-scheduler","security_context":{"run_as_group":3000,"run_as_user":1000,"sysctls":[{"name":"net.ipv4.ping_group_range","value":"0 2147483647"},{"name":"net.ipv4.ping_group_range","value":"0 2147483647"}]},"labels":["app:demo-app","version:v1.0.0"],"affinity":{"pod_anti_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}},{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}}],"required_during_scheduling_ignored_during_execution":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}]},"node_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"preference":{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},"weight":0},{"preference":{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},"weight":0}],"required_during_scheduling_ignored_during_execution":{"node_selector_terms":[{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]}]}},"pod_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}},{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}}],"required_during_scheduling_ignored_during_execution":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}]}}},"revision_history_limit":3,"replicas":1,"service_name":"demo-app","name":"demo-app","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_claim_templates":[{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]},{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]}],"workload_type":"Deployment","labels":["app:demo-app","version:v1.0.0"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"update_strategy":{"strategy_type":"RollingUpdate","rolling_update_config":{"partition":2,"max_unavailable":"10% or 2","max_surge":"10% or 2"}},"pod":{"image_pull_secrets":["image-secret","image-secret"],"dns_policy":"ClusterFirst","restart_policy":"Always","termination_grace_period_seconds":30,"volumes":[{"host_path":{"path":"/data","path_type":"Directory"},"name":"demo-vol","empty_dir":{"medium":"Memory","size_limit":"500Mi"},"config_map":{"name":"server config/secret","optional":False,"default_mode":400},"secret":{"name":"server config/secret","optional":False,"default_mode":400},"persistent_volume_claim":{"read_only":False,"claim_name":"demo-pvc"}},{"host_path":{"path":"/data","path_type":"Directory"},"name":"demo-vol","empty_dir":{"medium":"Memory","size_limit":"500Mi"},"config_map":{"name":"server config/secret","optional":False,"default_mode":400},"secret":{"name":"server config/secret","optional":False,"default_mode":400},"persistent_volume_claim":{"read_only":False,"claim_name":"demo-pvc"}}],"annotations":["annotation-key1:val1","annotation-key2:val2"],"containers":[{"image":"nginx:latest","life_cycle":{"pre_stop":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]},"post_start":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]}},"resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"volume_mounts":[{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"},{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"}],"env":{"name":"SMS_KEYS_PATH_XM","value":"dms-secret"},"ports":[{"container_port":80,"protocol":"TCP","name":"http"},{"container_port":80,"protocol":"TCP","name":"http"}],"command":["python3"],"args":["-m","openapi_server"],"readiness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"env_from":"Regular","startup_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"image_pull_policy":"IfNotPresent","volume_devices":[{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4},{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4}],"name":"http-server","container_type":"Init","liveness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"security_context":{"capabilities":{"add":["NET_ADMIN","SYS_TIME"],"drop":["NET_ADMIN","SYS_TIME"]},"run_as_group":3000,"run_as_user":1000}},{"image":"nginx:latest","life_cycle":{"pre_stop":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]},"post_start":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]}},"resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"volume_mounts":[{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"},{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"}],"env":{"name":"SMS_KEYS_PATH_XM","value":"dms-secret"},"ports":[{"container_port":80,"protocol":"TCP","name":"http"},{"container_port":80,"protocol":"TCP","name":"http"}],"command":["python3"],"args":["-m","openapi_server"],"readiness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"env_from":"Regular","startup_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"image_pull_policy":"IfNotPresent","volume_devices":[{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4},{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4}],"name":"http-server","container_type":"Init","liveness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"security_context":{"capabilities":{"add":["NET_ADMIN","SYS_TIME"],"drop":["NET_ADMIN","SYS_TIME"]},"run_as_group":3000,"run_as_user":1000}}],"topology_spread_constraints":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"when_unsatisfiable":"ScheduleAnyway","max_skew":1,"topologyKey":"kubernetes.io/hostname"},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"when_unsatisfiable":"ScheduleAnyway","max_skew":1,"topologyKey":"kubernetes.io/hostname"}],"scheduler_name":"default-scheduler","security_context":{"run_as_group":3000,"run_as_user":1000,"sysctls":[{"name":"net.ipv4.ping_group_range","value":"0 2147483647"},{"name":"net.ipv4.ping_group_range","value":"0 2147483647"}]},"labels":["app:demo-app","version:v1.0.0"],"affinity":{"pod_anti_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}},{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}}],"required_during_scheduling_ignored_during_execution":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}]},"node_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"preference":{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},"weight":0},{"preference":{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},"weight":0}],"required_during_scheduling_ignored_during_execution":{"node_selector_terms":[{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]}]}},"pod_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}},{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}}],"required_during_scheduling_ignored_during_execution":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}]}}},"revision_history_limit":3,"replicas":1,"service_name":"demo-app","name":"demo-app","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_claim_templates":[{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]},{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]}],"workload_type":"Deployment","labels":["app:demo-app","version:v1.0.0"]}],"services":[{"external_ips":["1.1.1.1","2.2.2.2"],"service_type":"ClusterIP","name":"demo-app","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"ports":[{"target_port":8080,"protocol":"TCP","port":80,"name":"http","node_port":6500},{"target_port":8080,"protocol":"TCP","port":80,"name":"http","node_port":6500}],"cluster_ip":"cluster_ip","labels":["app:demo-app","version:v1.0.0"]},{"external_ips":["1.1.1.1","2.2.2.2"],"service_type":"ClusterIP","name":"demo-app","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"ports":[{"target_port":8080,"protocol":"TCP","port":80,"name":"http","node_port":6500},{"target_port":8080,"protocol":"TCP","port":80,"name":"http","node_port":6500}],"cluster_ip":"cluster_ip","labels":["app:demo-app","version:v1.0.0"]}],"secrets":[{"name":"dingman-secret","annotations":["annotation-key1:val1","annotation-key2:val2"],"files":["cert/test-domain.crt","cert/cdn-dsa"],"labels":["app:demo-app","version:v1.0.0"]},{"name":"dingman-secret","annotations":["annotation-key1:val1","annotation-key2:val2"],"files":["cert/test-domain.crt","cert/cdn-dsa"],"labels":["app:demo-app","version:v1.0.0"]}]}
        headers = { 
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': 'Bearer special-key',
        }
        response = self.client.open(
            '/v1/app-service/{app_service_name}/deploy-resources'.format(app_service_name='demo-app.gss'),
            method='PATCH',
            headers=headers,
            data=json.dumps(deploy_resources),
            content_type='application/json')
        self.assert200(response,
                       'Response body is : ' + response.data.decode('utf-8'))

    def test_put_deploy_resource_overlays(self):
        """Test case for put_deploy_resource_overlays

        Put DeployResourceOverlays for an app service
        """
        request_body = {"configs":[{"templates":[{"values":{"key1":"value1"},"name":"conf/server.conf"},{"values":{"key1":"value1"},"name":"conf/server.conf"}],"name":"server-conf","annotations":["annotation-key1:val1","annotation-key2:val2"],"files":["conf/server.conf"],"labels":["app:demo-app","version:v1.0.0"]},{"templates":[{"values":{"key1":"value1"},"name":"conf/server.conf"},{"values":{"key1":"value1"},"name":"conf/server.conf"}],"name":"server-conf","annotations":["annotation-key1:val1","annotation-key2:val2"],"files":["conf/server.conf"],"labels":["app:demo-app","version:v1.0.0"]}],"persistent_volume_claims":[{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]},{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]}],"ingress":[{"name":"demo-app-ingress","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"rules":[{"paths":[{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}},{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}}],"name":"foo-ingress-rule","host":"www.foo.com"},{"paths":[{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}},{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}}],"name":"foo-ingress-rule","host":"www.foo.com"}],"tls":[{"secret_name":"app-secret","hosts":["www.foo.com","www.bar.com"],"name":"foo-bar-ingress"},{"secret_name":"app-secret","hosts":["www.foo.com","www.bar.com"],"name":"foo-bar-ingress"}],"labels":["app:demo-app","version:v1.0.0"]},{"name":"demo-app-ingress","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"rules":[{"paths":[{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}},{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}}],"name":"foo-ingress-rule","host":"www.foo.com"},{"paths":[{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}},{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}}],"name":"foo-ingress-rule","host":"www.foo.com"}],"tls":[{"secret_name":"app-secret","hosts":["www.foo.com","www.bar.com"],"name":"foo-bar-ingress"},{"secret_name":"app-secret","hosts":["www.foo.com","www.bar.com"],"name":"foo-bar-ingress"}],"labels":["app:demo-app","version:v1.0.0"]}],"role_bindings":[{"kind":"RoleBinding","subjects":[{"kind":"ServiceAccount","name":"default"},{"kind":"ServiceAccount","name":"default"}],"name":"cm-writer","namespace":"namespace","role_ref":{"kind":"Role","api_group":"rbac.authorization.k8s.io","name":"cm-writer"},"labels":["app:demo-app","version:v1.0.0"]},{"kind":"RoleBinding","subjects":[{"kind":"ServiceAccount","name":"default"},{"kind":"ServiceAccount","name":"default"}],"name":"cm-writer","namespace":"namespace","role_ref":{"kind":"Role","api_group":"rbac.authorization.k8s.io","name":"cm-writer"},"labels":["app:demo-app","version:v1.0.0"]}],"service_monitors":[{"namespace_selector":{"match_names":["default"],"any":True},"endpoints":[{"honor_labels":True,"path":"/metrics","target_port":8080,"relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"metric_relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"scheme":"http","port":8080,"honor_timestamps":True,"scrape_timeout":"10s","interval":"30s","params":{"module":["http_2xx"]}},{"honor_labels":True,"path":"/metrics","target_port":8080,"relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"metric_relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"scheme":"http","port":8080,"honor_timestamps":True,"scrape_timeout":"10s","interval":"30s","params":{"module":["http_2xx"]}}],"name":"my-service-monitor","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"labels":["app:demo-app","version:v1.0.0"]},{"namespace_selector":{"match_names":["default"],"any":True},"endpoints":[{"honor_labels":True,"path":"/metrics","target_port":8080,"relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"metric_relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"scheme":"http","port":8080,"honor_timestamps":True,"scrape_timeout":"10s","interval":"30s","params":{"module":["http_2xx"]}},{"honor_labels":True,"path":"/metrics","target_port":8080,"relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"metric_relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"scheme":"http","port":8080,"honor_timestamps":True,"scrape_timeout":"10s","interval":"30s","params":{"module":["http_2xx"]}}],"name":"my-service-monitor","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"labels":["app:demo-app","version:v1.0.0"]}],"roles":[{"kind":"Role","name":"cm-writer","namespace":"namespace","rules":[{"api_groups":"","resources":"configmaps","verbs":["create","patch","update","get"]},{"api_groups":"","resources":"configmaps","verbs":["create","patch","update","get"]}],"labels":["app:demo-app","version:v1.0.0"]},{"kind":"Role","name":"cm-writer","namespace":"namespace","rules":[{"api_groups":"","resources":"configmaps","verbs":["create","patch","update","get"]},{"api_groups":"","resources":"configmaps","verbs":["create","patch","update","get"]}],"labels":["app:demo-app","version:v1.0.0"]}],"workloads":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"update_strategy":{"strategy_type":"RollingUpdate","rolling_update_config":{"partition":2,"max_unavailable":"10% or 2","max_surge":"10% or 2"}},"pod":{"image_pull_secrets":["image-secret","image-secret"],"dns_policy":"ClusterFirst","restart_policy":"Always","termination_grace_period_seconds":30,"volumes":[{"host_path":{"path":"/data","path_type":"Directory"},"name":"demo-vol","empty_dir":{"medium":"Memory","size_limit":"500Mi"},"config_map":{"name":"server config/secret","optional":False,"default_mode":400},"secret":{"name":"server config/secret","optional":False,"default_mode":400},"persistent_volume_claim":{"read_only":False,"claim_name":"demo-pvc"}},{"host_path":{"path":"/data","path_type":"Directory"},"name":"demo-vol","empty_dir":{"medium":"Memory","size_limit":"500Mi"},"config_map":{"name":"server config/secret","optional":False,"default_mode":400},"secret":{"name":"server config/secret","optional":False,"default_mode":400},"persistent_volume_claim":{"read_only":False,"claim_name":"demo-pvc"}}],"annotations":["annotation-key1:val1","annotation-key2:val2"],"containers":[{"image":"nginx:latest","life_cycle":{"pre_stop":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]},"post_start":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]}},"resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"volume_mounts":[{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"},{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"}],"env":{"name":"SMS_KEYS_PATH_XM","value":"dms-secret"},"ports":[{"container_port":80,"protocol":"TCP","name":"http"},{"container_port":80,"protocol":"TCP","name":"http"}],"command":["python3"],"args":["-m","openapi_server"],"readiness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"env_from":"Regular","startup_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"image_pull_policy":"IfNotPresent","volume_devices":[{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4},{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4}],"name":"http-server","container_type":"Init","liveness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"security_context":{"capabilities":{"add":["NET_ADMIN","SYS_TIME"],"drop":["NET_ADMIN","SYS_TIME"]},"run_as_group":3000,"run_as_user":1000}},{"image":"nginx:latest","life_cycle":{"pre_stop":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]},"post_start":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]}},"resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"volume_mounts":[{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"},{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"}],"env":{"name":"SMS_KEYS_PATH_XM","value":"dms-secret"},"ports":[{"container_port":80,"protocol":"TCP","name":"http"},{"container_port":80,"protocol":"TCP","name":"http"}],"command":["python3"],"args":["-m","openapi_server"],"readiness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"env_from":"Regular","startup_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"image_pull_policy":"IfNotPresent","volume_devices":[{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4},{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4}],"name":"http-server","container_type":"Init","liveness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"security_context":{"capabilities":{"add":["NET_ADMIN","SYS_TIME"],"drop":["NET_ADMIN","SYS_TIME"]},"run_as_group":3000,"run_as_user":1000}}],"topology_spread_constraints":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"when_unsatisfiable":"ScheduleAnyway","max_skew":1,"topologyKey":"kubernetes.io/hostname"},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"when_unsatisfiable":"ScheduleAnyway","max_skew":1,"topologyKey":"kubernetes.io/hostname"}],"scheduler_name":"default-scheduler","security_context":{"run_as_group":3000,"run_as_user":1000,"sysctls":[{"name":"net.ipv4.ping_group_range","value":"0 2147483647"},{"name":"net.ipv4.ping_group_range","value":"0 2147483647"}]},"labels":["app:demo-app","version:v1.0.0"],"affinity":{"pod_anti_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}},{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}}],"required_during_scheduling_ignored_during_execution":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}]},"node_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"preference":{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},"weight":0},{"preference":{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},"weight":0}],"required_during_scheduling_ignored_during_execution":{"node_selector_terms":[{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]}]}},"pod_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}},{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}}],"required_during_scheduling_ignored_during_execution":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}]}}},"revision_history_limit":3,"replicas":1,"service_name":"demo-app","name":"demo-app","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_claim_templates":[{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]},{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]}],"workload_type":"Deployment","labels":["app:demo-app","version:v1.0.0"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"update_strategy":{"strategy_type":"RollingUpdate","rolling_update_config":{"partition":2,"max_unavailable":"10% or 2","max_surge":"10% or 2"}},"pod":{"image_pull_secrets":["image-secret","image-secret"],"dns_policy":"ClusterFirst","restart_policy":"Always","termination_grace_period_seconds":30,"volumes":[{"host_path":{"path":"/data","path_type":"Directory"},"name":"demo-vol","empty_dir":{"medium":"Memory","size_limit":"500Mi"},"config_map":{"name":"server config/secret","optional":False,"default_mode":400},"secret":{"name":"server config/secret","optional":False,"default_mode":400},"persistent_volume_claim":{"read_only":False,"claim_name":"demo-pvc"}},{"host_path":{"path":"/data","path_type":"Directory"},"name":"demo-vol","empty_dir":{"medium":"Memory","size_limit":"500Mi"},"config_map":{"name":"server config/secret","optional":False,"default_mode":400},"secret":{"name":"server config/secret","optional":False,"default_mode":400},"persistent_volume_claim":{"read_only":False,"claim_name":"demo-pvc"}}],"annotations":["annotation-key1:val1","annotation-key2:val2"],"containers":[{"image":"nginx:latest","life_cycle":{"pre_stop":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]},"post_start":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]}},"resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"volume_mounts":[{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"},{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"}],"env":{"name":"SMS_KEYS_PATH_XM","value":"dms-secret"},"ports":[{"container_port":80,"protocol":"TCP","name":"http"},{"container_port":80,"protocol":"TCP","name":"http"}],"command":["python3"],"args":["-m","openapi_server"],"readiness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"env_from":"Regular","startup_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"image_pull_policy":"IfNotPresent","volume_devices":[{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4},{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4}],"name":"http-server","container_type":"Init","liveness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"security_context":{"capabilities":{"add":["NET_ADMIN","SYS_TIME"],"drop":["NET_ADMIN","SYS_TIME"]},"run_as_group":3000,"run_as_user":1000}},{"image":"nginx:latest","life_cycle":{"pre_stop":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]},"post_start":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]}},"resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"volume_mounts":[{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"},{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"}],"env":{"name":"SMS_KEYS_PATH_XM","value":"dms-secret"},"ports":[{"container_port":80,"protocol":"TCP","name":"http"},{"container_port":80,"protocol":"TCP","name":"http"}],"command":["python3"],"args":["-m","openapi_server"],"readiness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"env_from":"Regular","startup_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"image_pull_policy":"IfNotPresent","volume_devices":[{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4},{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4}],"name":"http-server","container_type":"Init","liveness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"security_context":{"capabilities":{"add":["NET_ADMIN","SYS_TIME"],"drop":["NET_ADMIN","SYS_TIME"]},"run_as_group":3000,"run_as_user":1000}}],"topology_spread_constraints":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"when_unsatisfiable":"ScheduleAnyway","max_skew":1,"topologyKey":"kubernetes.io/hostname"},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"when_unsatisfiable":"ScheduleAnyway","max_skew":1,"topologyKey":"kubernetes.io/hostname"}],"scheduler_name":"default-scheduler","security_context":{"run_as_group":3000,"run_as_user":1000,"sysctls":[{"name":"net.ipv4.ping_group_range","value":"0 2147483647"},{"name":"net.ipv4.ping_group_range","value":"0 2147483647"}]},"labels":["app:demo-app","version:v1.0.0"],"affinity":{"pod_anti_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}},{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}}],"required_during_scheduling_ignored_during_execution":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}]},"node_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"preference":{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},"weight":0},{"preference":{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},"weight":0}],"required_during_scheduling_ignored_during_execution":{"node_selector_terms":[{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]}]}},"pod_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}},{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}}],"required_during_scheduling_ignored_during_execution":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}]}}},"revision_history_limit":3,"replicas":1,"service_name":"demo-app","name":"demo-app","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_claim_templates":[{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]},{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]}],"workload_type":"Deployment","labels":["app:demo-app","version:v1.0.0"]}],"services":[{"external_ips":["1.1.1.1","2.2.2.2"],"service_type":"ClusterIP","name":"demo-app","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"ports":[{"target_port":8080,"protocol":"TCP","port":80,"name":"http","node_port":6500},{"target_port":8080,"protocol":"TCP","port":80,"name":"http","node_port":6500}],"cluster_ip":"cluster_ip","labels":["app:demo-app","version:v1.0.0"]},{"external_ips":["1.1.1.1","2.2.2.2"],"service_type":"ClusterIP","name":"demo-app","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"ports":[{"target_port":8080,"protocol":"TCP","port":80,"name":"http","node_port":6500},{"target_port":8080,"protocol":"TCP","port":80,"name":"http","node_port":6500}],"cluster_ip":"cluster_ip","labels":["app:demo-app","version:v1.0.0"]}],"secrets":[{"name":"dingman-secret","annotations":["annotation-key1:val1","annotation-key2:val2"],"files":["cert/test-domain.crt","cert/cdn-dsa"],"labels":["app:demo-app","version:v1.0.0"]},{"name":"dingman-secret","annotations":["annotation-key1:val1","annotation-key2:val2"],"files":["cert/test-domain.crt","cert/cdn-dsa"],"labels":["app:demo-app","version:v1.0.0"]}]}
        headers = { 
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': 'Bearer special-key',
        }
        response = self.client.open(
            '/v1/app-service/{app_service_name}/deploy-resource-overlays'.format(app_service_name='demo-app.gss'),
            method='PUT',
            headers=headers,
            data=json.dumps(request_body),
            content_type='application/json')
        self.assert200(response,
                       'Response body is : ' + response.data.decode('utf-8'))

    def test_put_deploy_resources(self):
        """Test case for put_deploy_resources

        Put DeployResources for an app-service
        """
        deploy_resources = {"configs":[{"templates":[{"values":{"key1":"value1"},"name":"conf/server.conf"},{"values":{"key1":"value1"},"name":"conf/server.conf"}],"name":"server-conf","annotations":["annotation-key1:val1","annotation-key2:val2"],"files":["conf/server.conf"],"labels":["app:demo-app","version:v1.0.0"]},{"templates":[{"values":{"key1":"value1"},"name":"conf/server.conf"},{"values":{"key1":"value1"},"name":"conf/server.conf"}],"name":"server-conf","annotations":["annotation-key1:val1","annotation-key2:val2"],"files":["conf/server.conf"],"labels":["app:demo-app","version:v1.0.0"]}],"persistent_volume_claims":[{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]},{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]}],"ingress":[{"name":"demo-app-ingress","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"rules":[{"paths":[{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}},{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}}],"name":"foo-ingress-rule","host":"www.foo.com"},{"paths":[{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}},{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}}],"name":"foo-ingress-rule","host":"www.foo.com"}],"tls":[{"secret_name":"app-secret","hosts":["www.foo.com","www.bar.com"],"name":"foo-bar-ingress"},{"secret_name":"app-secret","hosts":["www.foo.com","www.bar.com"],"name":"foo-bar-ingress"}],"labels":["app:demo-app","version:v1.0.0"]},{"name":"demo-app-ingress","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"rules":[{"paths":[{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}},{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}}],"name":"foo-ingress-rule","host":"www.foo.com"},{"paths":[{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}},{"path":"/bar","name":"ingress-path-bar","path_type":"Exact","backend":{"service":{"port":80,"name":"demo-app-service"}}}],"name":"foo-ingress-rule","host":"www.foo.com"}],"tls":[{"secret_name":"app-secret","hosts":["www.foo.com","www.bar.com"],"name":"foo-bar-ingress"},{"secret_name":"app-secret","hosts":["www.foo.com","www.bar.com"],"name":"foo-bar-ingress"}],"labels":["app:demo-app","version:v1.0.0"]}],"role_bindings":[{"kind":"RoleBinding","subjects":[{"kind":"ServiceAccount","name":"default"},{"kind":"ServiceAccount","name":"default"}],"name":"cm-writer","namespace":"namespace","role_ref":{"kind":"Role","api_group":"rbac.authorization.k8s.io","name":"cm-writer"},"labels":["app:demo-app","version:v1.0.0"]},{"kind":"RoleBinding","subjects":[{"kind":"ServiceAccount","name":"default"},{"kind":"ServiceAccount","name":"default"}],"name":"cm-writer","namespace":"namespace","role_ref":{"kind":"Role","api_group":"rbac.authorization.k8s.io","name":"cm-writer"},"labels":["app:demo-app","version:v1.0.0"]}],"service_monitors":[{"namespace_selector":{"match_names":["default"],"any":True},"endpoints":[{"honor_labels":True,"path":"/metrics","target_port":8080,"relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"metric_relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"scheme":"http","port":8080,"honor_timestamps":True,"scrape_timeout":"10s","interval":"30s","params":{"module":["http_2xx"]}},{"honor_labels":True,"path":"/metrics","target_port":8080,"relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"metric_relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"scheme":"http","port":8080,"honor_timestamps":True,"scrape_timeout":"10s","interval":"30s","params":{"module":["http_2xx"]}}],"name":"my-service-monitor","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"labels":["app:demo-app","version:v1.0.0"]},{"namespace_selector":{"match_names":["default"],"any":True},"endpoints":[{"honor_labels":True,"path":"/metrics","target_port":8080,"relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"metric_relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"scheme":"http","port":8080,"honor_timestamps":True,"scrape_timeout":"10s","interval":"30s","params":{"module":["http_2xx"]}},{"honor_labels":True,"path":"/metrics","target_port":8080,"relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"metric_relabelings":[{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"},{"regex":"(.*)","source_labels":["__meta_kubernetes_pod_label_app_kubernetes_io_name"],"action":"replace","separator":";","replacement":"$1","target_label":"__metrics_path__"}],"scheme":"http","port":8080,"honor_timestamps":True,"scrape_timeout":"10s","interval":"30s","params":{"module":["http_2xx"]}}],"name":"my-service-monitor","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"labels":["app:demo-app","version:v1.0.0"]}],"roles":[{"kind":"Role","name":"cm-writer","namespace":"namespace","rules":[{"api_groups":"","resources":"configmaps","verbs":["create","patch","update","get"]},{"api_groups":"","resources":"configmaps","verbs":["create","patch","update","get"]}],"labels":["app:demo-app","version:v1.0.0"]},{"kind":"Role","name":"cm-writer","namespace":"namespace","rules":[{"api_groups":"","resources":"configmaps","verbs":["create","patch","update","get"]},{"api_groups":"","resources":"configmaps","verbs":["create","patch","update","get"]}],"labels":["app:demo-app","version:v1.0.0"]}],"workloads":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"update_strategy":{"strategy_type":"RollingUpdate","rolling_update_config":{"partition":2,"max_unavailable":"10% or 2","max_surge":"10% or 2"}},"pod":{"image_pull_secrets":["image-secret","image-secret"],"dns_policy":"ClusterFirst","restart_policy":"Always","termination_grace_period_seconds":30,"volumes":[{"host_path":{"path":"/data","path_type":"Directory"},"name":"demo-vol","empty_dir":{"medium":"Memory","size_limit":"500Mi"},"config_map":{"name":"server config/secret","optional":False,"default_mode":400},"secret":{"name":"server config/secret","optional":False,"default_mode":400},"persistent_volume_claim":{"read_only":False,"claim_name":"demo-pvc"}},{"host_path":{"path":"/data","path_type":"Directory"},"name":"demo-vol","empty_dir":{"medium":"Memory","size_limit":"500Mi"},"config_map":{"name":"server config/secret","optional":False,"default_mode":400},"secret":{"name":"server config/secret","optional":False,"default_mode":400},"persistent_volume_claim":{"read_only":False,"claim_name":"demo-pvc"}}],"annotations":["annotation-key1:val1","annotation-key2:val2"],"containers":[{"image":"nginx:latest","life_cycle":{"pre_stop":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]},"post_start":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]}},"resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"volume_mounts":[{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"},{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"}],"env":{"name":"SMS_KEYS_PATH_XM","value":"dms-secret"},"ports":[{"container_port":80,"protocol":"TCP","name":"http"},{"container_port":80,"protocol":"TCP","name":"http"}],"command":["python3"],"args":["-m","openapi_server"],"readiness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"env_from":"Regular","startup_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"image_pull_policy":"IfNotPresent","volume_devices":[{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4},{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4}],"name":"http-server","container_type":"Init","liveness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"security_context":{"capabilities":{"add":["NET_ADMIN","SYS_TIME"],"drop":["NET_ADMIN","SYS_TIME"]},"run_as_group":3000,"run_as_user":1000}},{"image":"nginx:latest","life_cycle":{"pre_stop":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]},"post_start":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]}},"resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"volume_mounts":[{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"},{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"}],"env":{"name":"SMS_KEYS_PATH_XM","value":"dms-secret"},"ports":[{"container_port":80,"protocol":"TCP","name":"http"},{"container_port":80,"protocol":"TCP","name":"http"}],"command":["python3"],"args":["-m","openapi_server"],"readiness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"env_from":"Regular","startup_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"image_pull_policy":"IfNotPresent","volume_devices":[{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4},{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4}],"name":"http-server","container_type":"Init","liveness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"security_context":{"capabilities":{"add":["NET_ADMIN","SYS_TIME"],"drop":["NET_ADMIN","SYS_TIME"]},"run_as_group":3000,"run_as_user":1000}}],"topology_spread_constraints":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"when_unsatisfiable":"ScheduleAnyway","max_skew":1,"topologyKey":"kubernetes.io/hostname"},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"when_unsatisfiable":"ScheduleAnyway","max_skew":1,"topologyKey":"kubernetes.io/hostname"}],"scheduler_name":"default-scheduler","security_context":{"run_as_group":3000,"run_as_user":1000,"sysctls":[{"name":"net.ipv4.ping_group_range","value":"0 2147483647"},{"name":"net.ipv4.ping_group_range","value":"0 2147483647"}]},"labels":["app:demo-app","version:v1.0.0"],"affinity":{"pod_anti_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}},{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}}],"required_during_scheduling_ignored_during_execution":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}]},"node_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"preference":{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},"weight":0},{"preference":{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},"weight":0}],"required_during_scheduling_ignored_during_execution":{"node_selector_terms":[{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]}]}},"pod_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}},{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}}],"required_during_scheduling_ignored_during_execution":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}]}}},"revision_history_limit":3,"replicas":1,"service_name":"demo-app","name":"demo-app","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_claim_templates":[{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]},{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]}],"workload_type":"Deployment","labels":["app:demo-app","version:v1.0.0"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"update_strategy":{"strategy_type":"RollingUpdate","rolling_update_config":{"partition":2,"max_unavailable":"10% or 2","max_surge":"10% or 2"}},"pod":{"image_pull_secrets":["image-secret","image-secret"],"dns_policy":"ClusterFirst","restart_policy":"Always","termination_grace_period_seconds":30,"volumes":[{"host_path":{"path":"/data","path_type":"Directory"},"name":"demo-vol","empty_dir":{"medium":"Memory","size_limit":"500Mi"},"config_map":{"name":"server config/secret","optional":False,"default_mode":400},"secret":{"name":"server config/secret","optional":False,"default_mode":400},"persistent_volume_claim":{"read_only":False,"claim_name":"demo-pvc"}},{"host_path":{"path":"/data","path_type":"Directory"},"name":"demo-vol","empty_dir":{"medium":"Memory","size_limit":"500Mi"},"config_map":{"name":"server config/secret","optional":False,"default_mode":400},"secret":{"name":"server config/secret","optional":False,"default_mode":400},"persistent_volume_claim":{"read_only":False,"claim_name":"demo-pvc"}}],"annotations":["annotation-key1:val1","annotation-key2:val2"],"containers":[{"image":"nginx:latest","life_cycle":{"pre_stop":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]},"post_start":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]}},"resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"volume_mounts":[{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"},{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"}],"env":{"name":"SMS_KEYS_PATH_XM","value":"dms-secret"},"ports":[{"container_port":80,"protocol":"TCP","name":"http"},{"container_port":80,"protocol":"TCP","name":"http"}],"command":["python3"],"args":["-m","openapi_server"],"readiness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"env_from":"Regular","startup_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"image_pull_policy":"IfNotPresent","volume_devices":[{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4},{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4}],"name":"http-server","container_type":"Init","liveness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"security_context":{"capabilities":{"add":["NET_ADMIN","SYS_TIME"],"drop":["NET_ADMIN","SYS_TIME"]},"run_as_group":3000,"run_as_user":1000}},{"image":"nginx:latest","life_cycle":{"pre_stop":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]},"post_start":{"tcp_socket":{"port":30181,"host":"127.0.0.1"},"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"exec_command":["/bin/showdown.sh"]}},"resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"volume_mounts":[{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"},{"path":"/opt/server/conf","read_only":True,"name":"demo-vol","sub_path":"server.conf"}],"env":{"name":"SMS_KEYS_PATH_XM","value":"dms-secret"},"ports":[{"container_port":80,"protocol":"TCP","name":"http"},{"container_port":80,"protocol":"TCP","name":"http"}],"command":["python3"],"args":["-m","openapi_server"],"readiness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"env_from":"Regular","startup_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"image_pull_policy":"IfNotPresent","volume_devices":[{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4},{"name":"demo-vol","device_path":"/dev/sda1","bcache_nums":4}],"name":"http-server","container_type":"Init","liveness_probe":{"period_seconds":60,"initial_delay_seconds":600,"tcp_socket":{"port":30181,"host":"127.0.0.1"},"failure_threshold":3,"http_get":{"path":"/show?domain=v19.tiktokcdn.com","http_headers":["x-devsre-authorization:Bearer eyJhbGciOiJ","content-type:application/json"],"scheme":"HTTPS","port":8888,"host":"gss-dns-agent.example.org"},"timeout_seconds":60,"exec_command":["/gss/dingman/bin/dingman-clit","-address","127.0.0.1:30501","-command","show pop:all summary:health-status"]},"security_context":{"capabilities":{"add":["NET_ADMIN","SYS_TIME"],"drop":["NET_ADMIN","SYS_TIME"]},"run_as_group":3000,"run_as_user":1000}}],"topology_spread_constraints":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"when_unsatisfiable":"ScheduleAnyway","max_skew":1,"topologyKey":"kubernetes.io/hostname"},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"when_unsatisfiable":"ScheduleAnyway","max_skew":1,"topologyKey":"kubernetes.io/hostname"}],"scheduler_name":"default-scheduler","security_context":{"run_as_group":3000,"run_as_user":1000,"sysctls":[{"name":"net.ipv4.ping_group_range","value":"0 2147483647"},{"name":"net.ipv4.ping_group_range","value":"0 2147483647"}]},"labels":["app:demo-app","version:v1.0.0"],"affinity":{"pod_anti_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}},{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}}],"required_during_scheduling_ignored_during_execution":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}]},"node_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"preference":{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},"weight":0},{"preference":{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},"weight":0}],"required_during_scheduling_ignored_during_execution":{"node_selector_terms":[{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]},{"match_expressions":["key:version, operator:In, values:[v1.0.0, v1.0.1]"],"match_fields":["key:version, operator:In, values:[v1.0.0, v1.0.1]"]}]}},"pod_affinity":{"preferred_during_scheduling_ignored_during_execution":[{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}},{"weight":6,"pod_affinity_term":{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}}],"required_during_scheduling_ignored_during_execution":[{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]},{"label_selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"topology_key":"topology_key","namespaces":["namespaces","namespaces"]}]}}},"revision_history_limit":3,"replicas":1,"service_name":"demo-app","name":"demo-app","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_claim_templates":[{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]},{"volume_mode":"Filesystem","request_resources":{"requests":{"memory":"256Mi","cpu":"0.1"},"limits":{"memory":"512Mi","cpu":"0.5"}},"name":"my-pvc","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"volume_name":"my-pv","storage_class_name":"standard","access_modes":["ReadWriteOnce"],"labels":["app:demo-app","version:v1.0.0"]}],"workload_type":"Deployment","labels":["app:demo-app","version:v1.0.0"]}],"services":[{"external_ips":["1.1.1.1","2.2.2.2"],"service_type":"ClusterIP","name":"demo-app","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"ports":[{"target_port":8080,"protocol":"TCP","port":80,"name":"http","node_port":6500},{"target_port":8080,"protocol":"TCP","port":80,"name":"http","node_port":6500}],"cluster_ip":"cluster_ip","labels":["app:demo-app","version:v1.0.0"]},{"external_ips":["1.1.1.1","2.2.2.2"],"service_type":"ClusterIP","name":"demo-app","namespace":"gitops-cdn-cache","annotations":["annotation-key1:val1","annotation-key2:val2"],"selector":["app:demo-app","key:version, operator:In, values:[v1.0.0, v1.0.1]"],"ports":[{"target_port":8080,"protocol":"TCP","port":80,"name":"http","node_port":6500},{"target_port":8080,"protocol":"TCP","port":80,"name":"http","node_port":6500}],"cluster_ip":"cluster_ip","labels":["app:demo-app","version:v1.0.0"]}],"secrets":[{"name":"dingman-secret","annotations":["annotation-key1:val1","annotation-key2:val2"],"files":["cert/test-domain.crt","cert/cdn-dsa"],"labels":["app:demo-app","version:v1.0.0"]},{"name":"dingman-secret","annotations":["annotation-key1:val1","annotation-key2:val2"],"files":["cert/test-domain.crt","cert/cdn-dsa"],"labels":["app:demo-app","version:v1.0.0"]}]}
        headers = { 
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': 'Bearer special-key',
        }
        response = self.client.open(
            '/v1/app-service/{app_service_name}/deploy-resources'.format(app_service_name='demo-app.gss'),
            method='PUT',
            headers=headers,
            data=json.dumps(deploy_resources),
            content_type='application/json')
        self.assert200(response,
                       'Response body is : ' + response.data.decode('utf-8'))


if __name__ == '__main__':
    unittest.main()
