# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class ContainerPort(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, container_port=None, protocol=None):  # noqa: E501
        """ContainerPort - a model defined in OpenAPI

        :param name: The name of this ContainerPort.  # noqa: E501
        :type name: str
        :param container_port: The container_port of this ContainerPort.  # noqa: E501
        :type container_port: int
        :param protocol: The protocol of this ContainerPort.  # noqa: E501
        :type protocol: str
        """
        self.openapi_types = {
            'name': str,
            'container_port': int,
            'protocol': str
        }

        self.attribute_map = {
            'name': 'name',
            'container_port': 'container_port',
            'protocol': 'protocol'
        }

        self._name = name
        self._container_port = container_port
        self._protocol = protocol

    @classmethod
    def from_dict(cls, dikt) -> 'ContainerPort':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ContainerPort of this ContainerPort.  # noqa: E501
        :rtype: ContainerPort
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this ContainerPort.

        Container port name, if specified, this must be an IANA_SVC_NAME and unique within the pod  # noqa: E501

        :return: The name of this ContainerPort.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ContainerPort.

        Container port name, if specified, this must be an IANA_SVC_NAME and unique within the pod  # noqa: E501

        :param name: The name of this ContainerPort.
        :type name: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def container_port(self):
        """Gets the container_port of this ContainerPort.


        :return: The container_port of this ContainerPort.
        :rtype: int
        """
        return self._container_port

    @container_port.setter
    def container_port(self, container_port):
        """Sets the container_port of this ContainerPort.


        :param container_port: The container_port of this ContainerPort.
        :type container_port: int
        """

        self._container_port = container_port

    @property
    def protocol(self):
        """Gets the protocol of this ContainerPort.

        Defaults to TCP  # noqa: E501

        :return: The protocol of this ContainerPort.
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this ContainerPort.

        Defaults to TCP  # noqa: E501

        :param protocol: The protocol of this ContainerPort.
        :type protocol: str
        """
        allowed_values = ["TCP", "UDP"]  # noqa: E501
        if protocol not in allowed_values:
            raise ValueError(
                "Invalid value for `protocol` ({0}), must be one of {1}"
                .format(protocol, allowed_values)
            )

        self._protocol = protocol
