# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class IngressTLS(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, name=None, hosts=None, secret_name=None):  # noqa: E501
        """IngressTLS - a model defined in OpenAPI

        :param name: The name of this IngressTLS.  # noqa: E501
        :type name: str
        :param hosts: The hosts of this IngressTLS.  # noqa: E501
        :type hosts: List[str]
        :param secret_name: The secret_name of this IngressTLS.  # noqa: E501
        :type secret_name: str
        """
        self.openapi_types = {
            'name': str,
            'hosts': List[str],
            'secret_name': str
        }

        self.attribute_map = {
            'name': 'name',
            'hosts': 'hosts',
            'secret_name': 'secret_name'
        }

        self._name = name
        self._hosts = hosts
        self._secret_name = secret_name

    @classmethod
    def from_dict(cls, dikt) -> 'IngressTLS':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The IngressTLS of this IngressTLS.  # noqa: E501
        :rtype: IngressTLS
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self):
        """Gets the name of this IngressTLS.

        Name of the TLS config.  # noqa: E501

        :return: The name of this IngressTLS.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this IngressTLS.

        Name of the TLS config.  # noqa: E501

        :param name: The name of this IngressTLS.
        :type name: str
        """

        self._name = name

    @property
    def hosts(self):
        """Gets the hosts of this IngressTLS.

        A list of hosts included in the TLS certificate.  # noqa: E501

        :return: The hosts of this IngressTLS.
        :rtype: List[str]
        """
        return self._hosts

    @hosts.setter
    def hosts(self, hosts):
        """Sets the hosts of this IngressTLS.

        A list of hosts included in the TLS certificate.  # noqa: E501

        :param hosts: The hosts of this IngressTLS.
        :type hosts: List[str]
        """

        self._hosts = hosts

    @property
    def secret_name(self):
        """Gets the secret_name of this IngressTLS.

        The name of the secret used to terminate TLS traffic on port 443.  # noqa: E501

        :return: The secret_name of this IngressTLS.
        :rtype: str
        """
        return self._secret_name

    @secret_name.setter
    def secret_name(self, secret_name):
        """Sets the secret_name of this IngressTLS.

        The name of the secret used to terminate TLS traffic on port 443.  # noqa: E501

        :param secret_name: The secret_name of this IngressTLS.
        :type secret_name: str
        """

        self._secret_name = secret_name
