# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class RBACRule(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, api_groups=None, resources=None, verbs=None):  # noqa: E501
        """RBACRule - a model defined in OpenAPI

        :param api_groups: The api_groups of this RBACRule.  # noqa: E501
        :type api_groups: List[str]
        :param resources: The resources of this RBACRule.  # noqa: E501
        :type resources: List[str]
        :param verbs: The verbs of this RBACRule.  # noqa: E501
        :type verbs: List[str]
        """
        self.openapi_types = {
            'api_groups': List[str],
            'resources': List[str],
            'verbs': List[str]
        }

        self.attribute_map = {
            'api_groups': 'api_groups',
            'resources': 'resources',
            'verbs': 'verbs'
        }

        self._api_groups = api_groups
        self._resources = resources
        self._verbs = verbs

    @classmethod
    def from_dict(cls, dikt) -> 'RBACRule':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The RBACRule of this RBACRule.  # noqa: E501
        :rtype: RBACRule
        """
        return util.deserialize_model(dikt, cls)

    @property
    def api_groups(self):
        """Gets the api_groups of this RBACRule.

        Specifies the API group for which the permissions are granted. An empty string ('') means the core Kubernetes API group.  # noqa: E501

        :return: The api_groups of this RBACRule.
        :rtype: List[str]
        """
        return self._api_groups

    @api_groups.setter
    def api_groups(self, api_groups):
        """Sets the api_groups of this RBACRule.

        Specifies the API group for which the permissions are granted. An empty string ('') means the core Kubernetes API group.  # noqa: E501

        :param api_groups: The api_groups of this RBACRule.
        :type api_groups: List[str]
        """

        self._api_groups = api_groups

    @property
    def resources(self):
        """Gets the resources of this RBACRule.

        Specifies the types of resources to which the permissions apply.  # noqa: E501

        :return: The resources of this RBACRule.
        :rtype: List[str]
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """Sets the resources of this RBACRule.

        Specifies the types of resources to which the permissions apply.  # noqa: E501

        :param resources: The resources of this RBACRule.
        :type resources: List[str]
        """

        self._resources = resources

    @property
    def verbs(self):
        """Gets the verbs of this RBACRule.

        Specifies the allowed actions or verbs that can be performed on the specified resources.  # noqa: E501

        :return: The verbs of this RBACRule.
        :rtype: List[str]
        """
        return self._verbs

    @verbs.setter
    def verbs(self, verbs):
        """Sets the verbs of this RBACRule.

        Specifies the allowed actions or verbs that can be performed on the specified resources.  # noqa: E501

        :param verbs: The verbs of this RBACRule.
        :type verbs: List[str]
        """

        self._verbs = verbs
