# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from openapi_server.models.base_model_ import Model
from openapi_server import util


class RelabelConfig(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, source_labels=None, separator=None, regex=None, replacement=None, target_label=None, action=None):  # noqa: E501
        """RelabelConfig - a model defined in OpenAPI

        :param source_labels: The source_labels of this RelabelConfig.  # noqa: E501
        :type source_labels: List[str]
        :param separator: The separator of this RelabelConfig.  # noqa: E501
        :type separator: str
        :param regex: The regex of this RelabelConfig.  # noqa: E501
        :type regex: str
        :param replacement: The replacement of this RelabelConfig.  # noqa: E501
        :type replacement: str
        :param target_label: The target_label of this RelabelConfig.  # noqa: E501
        :type target_label: str
        :param action: The action of this RelabelConfig.  # noqa: E501
        :type action: str
        """
        self.openapi_types = {
            'source_labels': List[str],
            'separator': str,
            'regex': str,
            'replacement': str,
            'target_label': str,
            'action': str
        }

        self.attribute_map = {
            'source_labels': 'source_labels',
            'separator': 'separator',
            'regex': 'regex',
            'replacement': 'replacement',
            'target_label': 'target_label',
            'action': 'action'
        }

        self._source_labels = source_labels
        self._separator = separator
        self._regex = regex
        self._replacement = replacement
        self._target_label = target_label
        self._action = action

    @classmethod
    def from_dict(cls, dikt) -> 'RelabelConfig':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The RelabelConfig of this RelabelConfig.  # noqa: E501
        :rtype: RelabelConfig
        """
        return util.deserialize_model(dikt, cls)

    @property
    def source_labels(self):
        """Gets the source_labels of this RelabelConfig.

        SourceLabels selects labels from the source  # noqa: E501

        :return: The source_labels of this RelabelConfig.
        :rtype: List[str]
        """
        return self._source_labels

    @source_labels.setter
    def source_labels(self, source_labels):
        """Sets the source_labels of this RelabelConfig.

        SourceLabels selects labels from the source  # noqa: E501

        :param source_labels: The source_labels of this RelabelConfig.
        :type source_labels: List[str]
        """

        self._source_labels = source_labels

    @property
    def separator(self):
        """Gets the separator of this RelabelConfig.

        Separator placed between concatenated source labels.  # noqa: E501

        :return: The separator of this RelabelConfig.
        :rtype: str
        """
        return self._separator

    @separator.setter
    def separator(self, separator):
        """Sets the separator of this RelabelConfig.

        Separator placed between concatenated source labels.  # noqa: E501

        :param separator: The separator of this RelabelConfig.
        :type separator: str
        """

        self._separator = separator

    @property
    def regex(self):
        """Gets the regex of this RelabelConfig.

        Regular expression against which the extracted value is matched. Default is (.*)  # noqa: E501

        :return: The regex of this RelabelConfig.
        :rtype: str
        """
        return self._regex

    @regex.setter
    def regex(self, regex):
        """Sets the regex of this RelabelConfig.

        Regular expression against which the extracted value is matched. Default is (.*)  # noqa: E501

        :param regex: The regex of this RelabelConfig.
        :type regex: str
        """

        self._regex = regex

    @property
    def replacement(self):
        """Gets the replacement of this RelabelConfig.

        Replacement value against which a regex replace is performed if the regular expression matches. Regex capture groups are available.  # noqa: E501

        :return: The replacement of this RelabelConfig.
        :rtype: str
        """
        return self._replacement

    @replacement.setter
    def replacement(self, replacement):
        """Sets the replacement of this RelabelConfig.

        Replacement value against which a regex replace is performed if the regular expression matches. Regex capture groups are available.  # noqa: E501

        :param replacement: The replacement of this RelabelConfig.
        :type replacement: str
        """

        self._replacement = replacement

    @property
    def target_label(self):
        """Gets the target_label of this RelabelConfig.

        Label to which the resulting value is written in a replace action.  # noqa: E501

        :return: The target_label of this RelabelConfig.
        :rtype: str
        """
        return self._target_label

    @target_label.setter
    def target_label(self, target_label):
        """Sets the target_label of this RelabelConfig.

        Label to which the resulting value is written in a replace action.  # noqa: E501

        :param target_label: The target_label of this RelabelConfig.
        :type target_label: str
        """

        self._target_label = target_label

    @property
    def action(self):
        """Gets the action of this RelabelConfig.

        Action to perform based on regex matching.  # noqa: E501

        :return: The action of this RelabelConfig.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this RelabelConfig.

        Action to perform based on regex matching.  # noqa: E501

        :param action: The action of this RelabelConfig.
        :type action: str
        """

        self._action = action
