# ----------------------------------------------------------------------------
#  Detect 3rd-party GUI libraries
# ----------------------------------------------------------------------------

#--- Win32 UI ---
ocv_clear_vars(HAVE_WIN32UI)
if(WITH_WIN32UI)
  try_compile(HAVE_WIN32UI
    "${OpenCV_BINARY_DIR}"
    "${OpenCV_SOURCE_DIR}/cmake/checks/win32uitest.cpp"
    CMAKE_FLAGS "-DLINK_LIBRARIES:STRING=user32;gdi32")
endif()

macro(ocv_find_package_Qt4)
  find_package(Qt4 COMPONENTS QtCore QtGui QtTest ${ARGN})
  if(QT4_FOUND)
    set(QT_FOUND 1)
    ocv_assert(QT_VERSION_MAJOR EQUAL 4)
  endif()
endmacro()

macro(ocv_find_package_Qt OCV_QT_VER)
  find_package(Qt${OCV_QT_VER} COMPONENTS Core Gui Widgets Test Concurrent ${ARGN} NO_MODULE)
  if(Qt${OCV_QT_VER}_FOUND)
    set(QT_FOUND 1)
    set(QT_VERSION "${Qt${OCV_QT_VER}_VERSION}")
    set(QT_VERSION_MAJOR "${Qt${OCV_QT_VER}_VERSION_MAJOR}")
    set(QT_VERSION_MINOR "${Qt${OCV_QT_VER}_VERSION_MINOR}")
    set(QT_VERSION_PATCH "${Qt${OCV_QT_VER}_VERSION_PATCH}")
    set(QT_VERSION_TWEAK "${Qt${OCV_QT_VER}_VERSION_TWEAK}")
    set(QT_VERSION_COUNT "${Qt${OCV_QT_VER}_VERSION_COUNT}")
  endif()
endmacro()

# --- QT4 ---
if(WITH_QT)
  if(NOT WITH_QT GREATER 0)
    # BUG: Qt5Config.cmake script can't handle components properly: find_package(QT NAMES Qt6 Qt5 REQUIRED NO_MODULE COMPONENTS Core Gui Widgets Test Concurrent)
    ocv_find_package_Qt(6 QUIET)
    if(NOT QT_FOUND)
      ocv_find_package_Qt(5 QUIET)
    endif()
    if(NOT QT_FOUND)
      ocv_find_package_Qt4(QUIET)
    endif()
  elseif(WITH_QT EQUAL 4)
    ocv_find_package_Qt4(REQUIRED)
  else()  # WITH_QT=<major version>
    ocv_find_package_Qt("${WITH_QT}" REQUIRED)
  endif()
  if(QT_FOUND)
    set(HAVE_QT ON)
    if(QT_VERSION_MAJOR GREATER 4)
      find_package(Qt${QT_VERSION_MAJOR} COMPONENTS OpenGL QUIET)
      if(Qt${QT_VERSION_MAJOR}OpenGL_FOUND)
        set(QT_QTOPENGL_FOUND ON)  # HAVE_QT_OPENGL is defined below
      endif()
    endif()
  endif()
endif()

# --- GTK ---
ocv_clear_vars(HAVE_GTK HAVE_GTK3 HAVE_GTHREAD HAVE_GTKGLEXT)
if(WITH_GTK AND NOT HAVE_QT)
  if(NOT WITH_GTK_2_X)
    ocv_check_modules(GTK3 gtk+-3.0)
    if(HAVE_GTK3)
      ocv_append_build_options(HIGHGUI GTK3)
      set(HAVE_GTK TRUE)
    endif()
  endif()
  if(NOT HAVE_GTK)
    ocv_check_modules(GTK2 gtk+-2.0)
    if(HAVE_GTK2)
      if (GTK2_VERSION VERSION_LESS MIN_VER_GTK)
        message (FATAL_ERROR "GTK support requires a minimum version of ${MIN_VER_GTK} (${GTK2_VERSION} found)")
      else()
        ocv_append_build_options(HIGHGUI GTK2)
        set(HAVE_GTK TRUE)
      endif()
    endif()
  endif()
  ocv_check_modules(GTHREAD gthread-2.0)
  if(HAVE_GTK AND NOT HAVE_GTHREAD)
    message(FATAL_ERROR "gthread not found. This library is required when building with GTK support")
  else()
    ocv_append_build_options(HIGHGUI GTHREAD)
  endif()
  if(WITH_OPENGL AND NOT HAVE_GTK3)
    ocv_check_modules(GTKGLEXT gtkglext-1.0)
    if(HAVE_GTKGLEXT)
      ocv_append_build_options(HIGHGUI GTKGLEXT)
    endif()
  endif()
endif()

# --- OpenGl ---
ocv_clear_vars(HAVE_OPENGL HAVE_QT_OPENGL)
if(WITH_OPENGL)
  if(WITH_WIN32UI OR (HAVE_QT AND QT_QTOPENGL_FOUND) OR HAVE_GTKGLEXT)
    find_package (OpenGL QUIET)
    if(OPENGL_FOUND)
      set(HAVE_OPENGL TRUE)
      list(APPEND OPENCV_LINKER_LIBS ${OPENGL_LIBRARIES})
      if(QT_QTOPENGL_FOUND)
        set(HAVE_QT_OPENGL TRUE)
      else()
        ocv_include_directories(${OPENGL_INCLUDE_DIR})
      endif()
    endif()
  endif()
endif(WITH_OPENGL)

# --- Carbon & Cocoa ---
if(APPLE)
  if(WITH_CARBON)
    set(HAVE_CARBON YES)
  elseif(NOT IOS AND CV_CLANG)
    set(HAVE_COCOA YES)
  endif()
endif()
