# coding=utf-8
# Generated by Django 2.2.24 on 2021-12-15 01:50

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import opaque_keys.edx.django.models


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("openedx_plugin_cms", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="CourseAudit",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "course_id",
                    opaque_keys.edx.django.models.CourseKeyField(
                        db_index=True,
                        help_text="Example: course-v1:edX+DemoX+Demo_Course",
                        max_length=255,
                        verbose_name="course_id Course Key",
                    ),
                ),
                (
                    "a_order",
                    models.IntegerField(
                        blank=True,
                        help_text=(  # noqa: B950
                            "the sequence in which this block is presented in the"
                            " course, based on the outline format in Course Management"
                            " Studio."
                        ),
                        null=True,
                        verbose_name="Order",
                    ),
                ),
                (
                    "b_course",
                    models.CharField(
                        blank=True,
                        help_text=("The display name of the course from Course Management" " Studio."),
                        max_length=255,
                        null=True,
                        verbose_name="Course Display Name",
                    ),
                ),
                (
                    "c_module",
                    models.CharField(
                        blank=True,
                        help_text=(
                            "The display name of the Course Module (aka Chapter) in" " Course Management Studio."
                        ),
                        max_length=255,
                        null=True,
                        verbose_name="Course Module",
                    ),
                ),
                (
                    "d_section",
                    models.CharField(
                        blank=True,
                        help_text=("The display name of the Course Section in Course" " Management Studio."),
                        max_length=255,
                        null=True,
                        verbose_name="Course Section",
                    ),
                ),
                (
                    "e_unit",
                    models.CharField(
                        blank=True,
                        help_text=(
                            "The display name of the Course Unit (aka Subsection) in" " Course Management Studio."
                        ),
                        max_length=255,
                        null=True,
                        verbose_name="Course Unit",
                    ),
                ),
                (
                    "e2_block_type",
                    models.CharField(
                        blank=True,
                        help_text=(
                            "Type of XBlock. Usually chapter, sequential, vertical," " html, discussion, or problem."
                        ),
                        max_length=255,
                        null=True,
                        verbose_name="Block Type",
                    ),
                ),
                (
                    "f_graded",
                    models.CharField(
                        blank=True,
                        help_text="True if this block contains graded content.",
                        max_length=255,
                        null=True,
                        verbose_name="Graded (Y/N)",
                    ),
                ),
                (
                    "g_section_weight",
                    models.FloatField(
                        blank=True,
                        help_text="The section weight from the grading policy.",
                        null=True,
                        verbose_name="Section Weight",
                    ),
                ),
                (
                    "h_number_graded_sections",
                    models.IntegerField(
                        blank=True,
                        help_text=("The number of graded content blocks within this section."),
                        null=True,
                        verbose_name="Number of Graded Sections",
                    ),
                ),
                (
                    "i_component_type",
                    models.CharField(
                        blank=True,
                        help_text=(  # noqa: B950
                            "For problem types only: the kind of Xblock used. Examples:"
                            " imageresponse, customresponse, optionresponse,"
                            " formularesponse, numericalresponse."
                        ),
                        max_length=255,
                        null=True,
                        verbose_name="Component Type",
                    ),
                ),
                (
                    "j_non_standard_element",
                    models.BooleanField(
                        blank=True,
                        help_text="True if this block contains non-standard content",
                        null=True,
                        verbose_name="Non-standard Element",
                    ),
                ),
                (
                    "k_problem_weight",
                    models.FloatField(
                        blank=True,
                        help_text=(
                            "The point potential of this problem based on the grading" " policy for the course."
                        ),
                        null=True,
                        verbose_name="Problem Weight",
                    ),
                ),
                (
                    "m_iframe_external_url",
                    models.URLField(blank=True, null=True, verbose_name="iFrame external url"),
                ),
                (
                    "n_asset_type",
                    models.CharField(
                        blank=True,
                        help_text=(  # noqa: B950
                            "The kind of file types referenced in any freeform html"
                            " content in this block. Example: getting-started_x250.png"
                        ),
                        max_length=255,
                        null=True,
                        verbose_name="Asset Type",
                    ),
                ),
                (
                    "o_unit_url",
                    models.URLField(blank=True, null=True, verbose_name="LMS URL"),
                ),
                (
                    "p_studio_url",
                    models.URLField(blank=True, null=True, verbose_name="Studio URL"),
                ),
                (
                    "q_xml_filename",
                    models.CharField(
                        blank=True,
                        help_text=(  # noqa: B950
                            "the full path to the xml file for this block, if it"
                            " exists. Example:"
                            " html/030e35c4756a4ddc8d40b95fbbfff4d4.xml"
                        ),
                        max_length=255,
                        null=True,
                        verbose_name="XML Filename",
                    ),
                ),
                (
                    "r_publication_date",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        help_text=("The most recent publication or modification date of this" " block"),
                        null=True,
                        verbose_name="Publication Date",
                    ),
                ),
                (
                    "t_change_made",
                    models.DateTimeField(blank=True, db_index=True, null=True, verbose_name="Change Made"),
                ),
                (
                    "s_changed_by",
                    models.ForeignKey(
                        blank=True,
                        help_text=("the username of the person who most recently published or" " modified this block."),
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Changed By",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
