# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.semantic_search_response import SemanticSearchResponse
from .raw_client import AsyncRawAiClient, RawAiClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AiClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAiClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAiClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAiClient
        """
        return self._raw_client

    def semantic_search(
        self,
        *,
        entity_id: str,
        query: str,
        limit: typing.Optional[int] = OMIT,
        source_types: typing.Optional[typing.Sequence[str]] = OMIT,
        document_types: typing.Optional[typing.Sequence[str]] = OMIT,
        time_start: typing.Optional[dt.datetime] = OMIT,
        time_end: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SemanticSearchResponse:
        """
        Perform semantic search across vectorized data

        Parameters
        ----------
        entity_id : str

        query : str

        limit : typing.Optional[int]

        source_types : typing.Optional[typing.Sequence[str]]

        document_types : typing.Optional[typing.Sequence[str]]

        time_start : typing.Optional[dt.datetime]

        time_end : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SemanticSearchResponse
            Search results

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.ai.semantic_search(entity_id='entityId', query='query', )
        """
        _response = self._raw_client.semantic_search(
            entity_id=entity_id,
            query=query,
            limit=limit,
            source_types=source_types,
            document_types=document_types,
            time_start=time_start,
            time_end=time_end,
            request_options=request_options,
        )
        return _response.data


class AsyncAiClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAiClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAiClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAiClient
        """
        return self._raw_client

    async def semantic_search(
        self,
        *,
        entity_id: str,
        query: str,
        limit: typing.Optional[int] = OMIT,
        source_types: typing.Optional[typing.Sequence[str]] = OMIT,
        document_types: typing.Optional[typing.Sequence[str]] = OMIT,
        time_start: typing.Optional[dt.datetime] = OMIT,
        time_end: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SemanticSearchResponse:
        """
        Perform semantic search across vectorized data

        Parameters
        ----------
        entity_id : str

        query : str

        limit : typing.Optional[int]

        source_types : typing.Optional[typing.Sequence[str]]

        document_types : typing.Optional[typing.Sequence[str]]

        time_start : typing.Optional[dt.datetime]

        time_end : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SemanticSearchResponse
            Search results

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.ai.semantic_search(entity_id='entityId', query='query', )
        asyncio.run(main())
        """
        _response = await self._raw_client.semantic_search(
            entity_id=entity_id,
            query=query,
            limit=limit,
            source_types=source_types,
            document_types=document_types,
            time_start=time_start,
            time_end=time_end,
            request_options=request_options,
        )
        return _response.data
