# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.bad_request_error import BadRequestError
from ..errors.internal_server_error import InternalServerError
from ..types.semantic_search_response import SemanticSearchResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawAiClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def semantic_search(
        self,
        *,
        entity_id: str,
        query: str,
        limit: typing.Optional[int] = OMIT,
        source_types: typing.Optional[typing.Sequence[str]] = OMIT,
        document_types: typing.Optional[typing.Sequence[str]] = OMIT,
        time_start: typing.Optional[dt.datetime] = OMIT,
        time_end: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SemanticSearchResponse]:
        """
        Perform semantic search across vectorized data

        Parameters
        ----------
        entity_id : str

        query : str

        limit : typing.Optional[int]

        source_types : typing.Optional[typing.Sequence[str]]

        document_types : typing.Optional[typing.Sequence[str]]

        time_start : typing.Optional[dt.datetime]

        time_end : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SemanticSearchResponse]
            Search results
        """
        _response = self._client_wrapper.httpx_client.request(
            "ai/semantic-search",
            method="POST",
            json={
                "entityId": entity_id,
                "query": query,
                "limit": limit,
                "sourceTypes": source_types,
                "documentTypes": document_types,
                "timeStart": time_start,
                "timeEnd": time_end,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SemanticSearchResponse,
                    parse_obj_as(
                        type_=SemanticSearchResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)


class AsyncRawAiClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def semantic_search(
        self,
        *,
        entity_id: str,
        query: str,
        limit: typing.Optional[int] = OMIT,
        source_types: typing.Optional[typing.Sequence[str]] = OMIT,
        document_types: typing.Optional[typing.Sequence[str]] = OMIT,
        time_start: typing.Optional[dt.datetime] = OMIT,
        time_end: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SemanticSearchResponse]:
        """
        Perform semantic search across vectorized data

        Parameters
        ----------
        entity_id : str

        query : str

        limit : typing.Optional[int]

        source_types : typing.Optional[typing.Sequence[str]]

        document_types : typing.Optional[typing.Sequence[str]]

        time_start : typing.Optional[dt.datetime]

        time_end : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SemanticSearchResponse]
            Search results
        """
        _response = await self._client_wrapper.httpx_client.request(
            "ai/semantic-search",
            method="POST",
            json={
                "entityId": entity_id,
                "query": query,
                "limit": limit,
                "sourceTypes": source_types,
                "documentTypes": document_types,
                "timeStart": time_start,
                "timeEnd": time_end,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SemanticSearchResponse,
                    parse_obj_as(
                        type_=SemanticSearchResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response.text)
        raise ApiError(headers=dict(_response.headers), status_code=_response.status_code, body=_response_json)
