# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.token_response import TokenResponse
from .raw_client import AsyncRawAuthenticationClient, RawAuthenticationClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AuthenticationClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAuthenticationClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAuthenticationClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAuthenticationClient
        """
        return self._raw_client

    def generate_token(
        self, *, client_id: str, client_secret: str, request_options: typing.Optional[RequestOptions] = None
    ) -> TokenResponse:
        """
        Generate a JWT token for API authentication

        Parameters
        ----------
        client_id : str
            Client ID

        client_secret : str
            Client secret

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TokenResponse
            Token generated successfully

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.authentication.generate_token(client_id='client_id', client_secret='client_secret', )
        """
        _response = self._raw_client.generate_token(
            client_id=client_id, client_secret=client_secret, request_options=request_options
        )
        return _response.data


class AsyncAuthenticationClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAuthenticationClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAuthenticationClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAuthenticationClient
        """
        return self._raw_client

    async def generate_token(
        self, *, client_id: str, client_secret: str, request_options: typing.Optional[RequestOptions] = None
    ) -> TokenResponse:
        """
        Generate a JWT token for API authentication

        Parameters
        ----------
        client_id : str
            Client ID

        client_secret : str
            Client secret

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TokenResponse
            Token generated successfully

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.authentication.generate_token(client_id='client_id', client_secret='client_secret', )
        asyncio.run(main())
        """
        _response = await self._raw_client.generate_token(
            client_id=client_id, client_secret=client_secret, request_options=request_options
        )
        return _response.data
