# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.bank_account_response import BankAccountResponse
from ..types.link_token_response import LinkTokenResponse
from .raw_client import AsyncRawBanksClient, RawBanksClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class BanksClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawBanksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawBanksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawBanksClient
        """
        return self._raw_client

    def create_plaid_link_token(
        self, *, entity_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> LinkTokenResponse:
        """
        Generate a link token for Plaid integration

        Parameters
        ----------
        entity_id : str
            entity ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LinkTokenResponse
            Link token created

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.banks.create_plaid_link_token(entity_id='entityId', )
        """
        _response = self._raw_client.create_plaid_link_token(entity_id=entity_id, request_options=request_options)
        return _response.data

    def add_bank_account(
        self, *, entity_id: str, public_token: str, request_options: typing.Optional[RequestOptions] = None
    ) -> BankAccountResponse:
        """
        Add a bank account using public token from Plaid

        Parameters
        ----------
        entity_id : str
            entity ID

        public_token : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BankAccountResponse
            Bank account added

        Examples
        --------
        from openledger import OpenLedgerClient
        client = OpenLedgerClient(token="YOUR_TOKEN", )
        client.banks.add_bank_account(entity_id='entityId', public_token='public_token', )
        """
        _response = self._raw_client.add_bank_account(
            entity_id=entity_id, public_token=public_token, request_options=request_options
        )
        return _response.data


class AsyncBanksClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawBanksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawBanksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawBanksClient
        """
        return self._raw_client

    async def create_plaid_link_token(
        self, *, entity_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> LinkTokenResponse:
        """
        Generate a link token for Plaid integration

        Parameters
        ----------
        entity_id : str
            entity ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LinkTokenResponse
            Link token created

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.banks.create_plaid_link_token(entity_id='entityId', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_plaid_link_token(entity_id=entity_id, request_options=request_options)
        return _response.data

    async def add_bank_account(
        self, *, entity_id: str, public_token: str, request_options: typing.Optional[RequestOptions] = None
    ) -> BankAccountResponse:
        """
        Add a bank account using public token from Plaid

        Parameters
        ----------
        entity_id : str
            entity ID

        public_token : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BankAccountResponse
            Bank account added

        Examples
        --------
        from openledger import AsyncOpenLedgerClient
        import asyncio
        client = AsyncOpenLedgerClient(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.banks.add_bank_account(entity_id='entityId', public_token='public_token', )
        asyncio.run(main())
        """
        _response = await self._raw_client.add_bank_account(
            entity_id=entity_id, public_token=public_token, request_options=request_options
        )
        return _response.data
